/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.hessian;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.util.reflection.Reflections;

public class HessianServer {
    public static final String CONTENT_TYPE_HESSIAN = "application/x-hessian";
    private static final Class<?>[] BOOLEAN_PARAM = new Class[]{Boolean.TYPE};
    private static final Object[] TRUE_PARAM = new Object[]{true};
    private final ClassLoader loader;
    private final Class<?> serializerFactoryClass;
    private Object serializerFactory;
    private Object skeleton;
    private Logger debugLogger = null;

    public HessianServer(ClassLoader classLoader) throws HessianIsMissingException {
        this.loader = classLoader;
        try {
            this.serializerFactoryClass = classLoader.loadClass("com.caucho.hessian.io.SerializerFactory");
            this.serializerFactory = this.serializerFactoryClass.getConstructor(ClassLoader.class).newInstance(this.loader);
        }
        catch (Exception e) {
            throw new HessianIsMissingException(e);
        }
        Reflections.invokeByReflection((Object)this.serializerFactory, (String)"setAllowNonSerializable", (Class[])BOOLEAN_PARAM, (Object[])TRUE_PARAM);
    }

    public HessianServer serializerFactory(Object serializerFactory) {
        this.serializerFactory = serializerFactory;
        return this;
    }

    public HessianServer sendCollectionType(boolean sendCollectionType) {
        Reflections.invokeByReflection((Object)this.serializerFactory, (String)"setSendCollectionType", (Class[])BOOLEAN_PARAM, (Object[])new Object[]{sendCollectionType});
        return this;
    }

    public HessianServer debug(boolean debug) {
        this.debugLogger = debug ? Logger.getLogger("OpenEJB.hessian.DEBUG") : null;
        return this;
    }

    public HessianServer createSkeleton(Object instance, Class<?> itf) {
        try {
            this.skeleton = this.loader.loadClass("com.caucho.hessian.server.HessianSkeleton").getConstructor(Object.class, Class.class).newInstance(instance, itf);
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
        return this;
    }

    public Object getSerializerFactory() {
        return this.serializerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(InputStream inputStream, OutputStream outputStream) throws Throwable {
        Object out;
        Object in;
        int code;
        InputStream isToUse = inputStream;
        OutputStream osToUse = outputStream;
        if (this.debugLogger != null && this.debugLogger.isLoggable(Level.FINE)) {
            isToUse = (InputStream)InputStream.class.cast(this.loader.loadClass("com.caucho.hessian.io.HessianDebugInputStream").getConstructor(InputStream.class, Logger.class, Level.class).newInstance(inputStream, this.debugLogger, Level.FINE));
            Reflections.invokeByReflection((Object)isToUse, (String)"startTop2", (Class[])new Class[0], null);
            osToUse = (OutputStream)OutputStream.class.cast(this.loader.loadClass("com.caucho.hessian.io.HessianDebugOutputStream").getConstructor(OutputStream.class, Logger.class, Level.class).newInstance(outputStream, this.debugLogger, Level.FINE));
            Reflections.invokeByReflection((Object)osToUse, (String)"startTop2", (Class[])new Class[0], null);
        }
        if (!isToUse.markSupported()) {
            isToUse = new BufferedInputStream(isToUse);
            isToUse.mark(1);
        }
        if ((code = isToUse.read()) == 72 || code == 67) {
            int major = isToUse.read();
            int minor = isToUse.read();
            if (major != 2) {
                throw new IOException("Version " + major + "." + minor + " is not understood");
            }
            in = this.loader.loadClass("com.caucho.hessian.io.Hessian2Input").getConstructor(InputStream.class).newInstance(isToUse);
            out = this.loader.loadClass("com.caucho.hessian.io.Hessian2Output").getConstructor(OutputStream.class).newInstance(osToUse);
            Reflections.invokeByReflection(in, (String)"readCall", (Class[])new Class[0], null);
        } else if (code == 99) {
            int major = isToUse.read();
            int minor = isToUse.read();
            in = this.loader.loadClass("com.caucho.hessian.io.HessianInput").getConstructor(InputStream.class).newInstance(isToUse);
            out = major >= 2 ? this.loader.loadClass("com.caucho.hessian.io.Hessian2Output").getConstructor(OutputStream.class).newInstance(osToUse) : this.loader.loadClass("com.caucho.hessian.io.HessianOutput").getConstructor(OutputStream.class).newInstance(osToUse);
        } else {
            throw new IOException("Expected 'H'/'C' (Hessian 2.0) or 'c' (Hessian 1.0) in hessian input at " + code);
        }
        Reflections.invokeByReflection(in, (String)"setSerializerFactory", (Class[])new Class[]{this.serializerFactoryClass}, (Object[])new Object[]{this.serializerFactory});
        Reflections.invokeByReflection(out, (String)"setSerializerFactory", (Class[])new Class[]{this.serializerFactoryClass}, (Object[])new Object[]{this.serializerFactory});
        try {
            Reflections.invokeByReflection((Object)this.skeleton, (String)"invoke", (Class[])new Class[]{this.loader.loadClass("com.caucho.hessian.io.AbstractHessianInput"), this.loader.loadClass("com.caucho.hessian.io.AbstractHessianOutput")}, (Object[])new Object[]{in, out});
        }
        finally {
            try {
                Reflections.invokeByReflection(in, (String)"close", (Class[])new Class[0], null);
                isToUse.close();
            }
            catch (IOException iOException) {}
            try {
                Reflections.invokeByReflection(out, (String)"close", (Class[])new Class[0], null);
                osToUse.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static class HessianIsMissingException
    extends Exception {
        public HessianIsMissingException(Exception e) {
            super(e);
        }
    }
}

