/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client.hessian;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.ivm.naming.ContextWrapper;
import org.apache.openejb.util.reflection.Reflections;

public class HessianInitialContextFactory
implements InitialContextFactory {
    public static final String API = "openejb.hessian.client.api";
    public static final String FORCE_SERIALIZABLE = "openejb.hessian.client.force-serializable";
    public static final String CHUNKED = "openejb.hessian.client.chunked";
    public static final String DEBUG = "openejb.hessian.client.debug";
    public static final String READ_TIMEOUT = "openejb.hessian.client.read-timeout";
    public static final String CONNECT_TIMEOUT = "openejb.hessian.client.connect-timeout";
    private static final Class<?>[] BOOLEAN_PARAM = new Class[]{Boolean.TYPE};
    private static final Class<?>[] LONG_PARAM = new Class[]{Long.TYPE};
    private static final Class<?>[] STRING_PARAM = new Class[]{String.class};
    private static final Class<?>[] CREATE_PARAM = new Class[]{Class.class, String.class, ClassLoader.class};

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        return new HessianContext(environment);
    }

    private static class HessianContext
    extends ContextWrapper {
        private final Hashtable<?, ?> environment;
        private final ClassLoader loader;
        private final String url;
        private final Class<?> api;
        private final boolean allowNonSerializable;
        private final String user;
        private final String password;
        private final boolean chunked;
        private final boolean debug;
        private final int readTimeout;
        private final int connectTimeout;
        private final Constructor<?> factoryConstructor;
        private final Constructor<?> serializerConstructor;

        public HessianContext(Hashtable<?, ?> environment) {
            super(null);
            this.environment = environment;
            Object baseUrl = (String)String.class.cast(environment.get("java.naming.provider.url"));
            if (baseUrl == null) {
                throw new IllegalArgumentException("provider url should be set");
            }
            if (!((String)baseUrl).endsWith("/")) {
                baseUrl = (String)baseUrl + "/";
            }
            this.url = baseUrl;
            this.loader = Thread.currentThread().getContextClassLoader();
            this.user = (String)String.class.cast(environment.get("java.naming.security.principal"));
            this.password = (String)String.class.cast(environment.get("java.naming.security.credentials"));
            this.allowNonSerializable = environment.get(HessianInitialContextFactory.FORCE_SERIALIZABLE) == null || !"true".equals(String.class.cast(environment.get(HessianInitialContextFactory.FORCE_SERIALIZABLE)));
            this.chunked = environment.get(HessianInitialContextFactory.CHUNKED) == null || "true".equals(String.class.cast(environment.get(HessianInitialContextFactory.CHUNKED)));
            this.debug = "true".equals(String.class.cast(environment.get(HessianInitialContextFactory.DEBUG)));
            this.readTimeout = environment.get(HessianInitialContextFactory.READ_TIMEOUT) == null ? -1 : Integer.parseInt((String)String.class.cast(environment.get(HessianInitialContextFactory.READ_TIMEOUT)));
            this.connectTimeout = environment.get(HessianInitialContextFactory.CONNECT_TIMEOUT) == null ? -1 : Integer.parseInt((String)String.class.cast(environment.get(HessianInitialContextFactory.CONNECT_TIMEOUT)));
            String apiClassname = (String)String.class.cast(environment.get(HessianInitialContextFactory.API));
            if (apiClassname != null) {
                try {
                    this.api = this.loader.loadClass(apiClassname);
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBRuntimeException((Exception)e);
                }
            } else {
                this.api = null;
            }
            try {
                this.factoryConstructor = this.loader.loadClass("com.caucho.hessian.client.HessianProxyFactory").getConstructor(ClassLoader.class);
                this.serializerConstructor = this.loader.loadClass("com.caucho.hessian.io.SerializerFactory").getConstructor(ClassLoader.class);
            }
            catch (Exception e) {
                throw new OpenEJBRuntimeException(e);
            }
        }

        public Object lookup(Name name) throws NamingException {
            return this.lookup(name.toString());
        }

        public Object lookup(String name) throws NamingException {
            Object clientFactory = this.factoryConstructor.newInstance(this.loader);
            Object factory = this.serializerConstructor.newInstance(this.loader);
            Reflections.invokeByReflection(factory, (String)"setAllowNonSerializable", (Class[])BOOLEAN_PARAM, (Object[])new Object[]{this.allowNonSerializable});
            Reflections.invokeByReflection(clientFactory, (String)"setSerializerFactory", (Class[])new Class[]{this.serializerConstructor.getDeclaringClass()}, (Object[])new Object[]{factory});
            if (this.user != null) {
                Reflections.invokeByReflection(clientFactory, (String)"setUser", (Class[])STRING_PARAM, (Object[])new Object[]{this.user});
                Reflections.invokeByReflection(clientFactory, (String)"setPassword", (Class[])STRING_PARAM, (Object[])new Object[]{this.password});
            }
            Reflections.invokeByReflection(clientFactory, (String)"setChunkedPost", (Class[])BOOLEAN_PARAM, (Object[])new Object[]{this.chunked});
            Reflections.invokeByReflection(clientFactory, (String)"setDebug", (Class[])BOOLEAN_PARAM, (Object[])new Object[]{this.debug});
            Reflections.invokeByReflection(clientFactory, (String)"setReadTimeout", (Class[])LONG_PARAM, (Object[])new Object[]{this.readTimeout});
            Reflections.invokeByReflection(clientFactory, (String)"setConnectTimeout", (Class[])LONG_PARAM, (Object[])new Object[]{this.connectTimeout});
            String completeUrl = this.url + name;
            try {
                if (this.api != null) {
                    return Reflections.invokeByReflection(clientFactory, (String)"create", (Class[])CREATE_PARAM, (Object[])new Object[]{this.api, completeUrl, this.loader});
                }
                return Reflections.invokeByReflection(clientFactory, (String)"create", (Class[])STRING_PARAM, (Object[])new Object[]{completeUrl});
            }
            catch (Exception e) {
                try {
                    throw new NamingException(e.getMessage());
                }
                catch (Exception e2) {
                    throw new OpenEJBRuntimeException(e2);
                }
            }
        }

        public Hashtable<?, ?> getEnvironment() throws NamingException {
            return this.environment;
        }
    }
}

