/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.hessian;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Properties;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.event.AssemblerAfterApplicationCreated;
import org.apache.openejb.assembler.classic.event.AssemblerBeforeApplicationDestroyed;
import org.apache.openejb.assembler.classic.event.NewEjbAvailableAfterApplicationCreated;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.hessian.HessianRegistry;
import org.apache.openejb.server.hessian.HessianRegistryImpl;
import org.apache.openejb.server.hessian.HessianServer;
import org.apache.openejb.server.hessian.TomcatHessianRegistry;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.ProxyEJB;

public class HessianService
implements ServerService,
SelfManaging {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("hessian"), HessianService.class);
    private boolean disabled;
    private boolean debug;
    private boolean sendCollectionType;
    private String serializerFactory;
    private String realmName;
    private String virtualHost;
    private String transportGuarantee;
    private String authMethod;
    private HessianRegistry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(AppInfo app, Collection<BeanContext> beanContexts) {
        if (this.disabled) {
            return;
        }
        for (BeanContext beanContext : beanContexts) {
            Class remoteItf = beanContext.getBusinessRemoteInterface();
            if (remoteItf == null) continue;
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = beanContext.getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                HessianServer server;
                try {
                    server = new HessianServer(classLoader).debug(this.debug);
                }
                catch (HessianServer.HessianIsMissingException e) {
                    LOGGER.info("Hessian is not available so openejb-hessian will not deploy any service");
                    Thread.currentThread().setContextClassLoader(old);
                    break;
                }
                if (this.serializerFactory != null) {
                    try {
                        server.serializerFactory(classLoader.loadClass(this.serializerFactory).newInstance()).sendCollectionType(this.sendCollectionType);
                    }
                    catch (Exception e) {
                        throw new OpenEJBRuntimeException(e);
                    }
                } else {
                    server.sendCollectionType(this.sendCollectionType);
                }
                server.createSkeleton(ProxyEJB.simpleProxy((BeanContext)beanContext, (Class[])new Class[]{remoteItf}), remoteItf);
                try {
                    LOGGER.info("Hessian(url=" + this.registry.deploy(classLoader, server, this.virtualHost, HessianService.appName(app, beanContext), this.authMethod, this.transportGuarantee, this.realmName, (String)String.class.cast(beanContext.getDeploymentID())) + ", interface=" + remoteItf.getName() + ")");
                }
                catch (URISyntaxException e) {
                    throw new OpenEJBRuntimeException((Exception)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void start() throws ServiceException {
        SystemInstance.get().addObserver((Object)this);
        SystemInstance.get().setComponent(HessianService.class, (Object)this);
        this.registry = this.setRegistry();
        Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        if (assembler != null) {
            for (AppInfo appInfo : assembler.getDeployedApplications()) {
                this.deploy(new AssemblerAfterApplicationCreated(appInfo, ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContext((Object)appInfo.appId), null));
            }
        }
    }

    private HessianRegistry setRegistry() {
        HessianRegistry registry = (HessianRegistry)SystemInstance.get().getComponent(HessianRegistry.class);
        if (registry == null) {
            try {
                HessianService.class.getClassLoader().loadClass("org.apache.catalina.Context");
                registry = new TomcatHessianRegistry();
            }
            catch (Throwable t) {
                if (SystemInstance.get().getComponent(HttpListenerRegistry.class) != null) {
                    registry = new HessianRegistryImpl();
                }
                throw new IllegalStateException("openejb-http is missing at classpath");
            }
            SystemInstance.get().setComponent(HessianRegistry.class, (Object)registry);
        }
        return registry;
    }

    public HessianRegistry getRegistry() {
        return this.registry;
    }

    public void stop() throws ServiceException {
        SystemInstance.get().removeObserver((Object)this);
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException();
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException();
    }

    public void newEjbToDeploy(@Observes NewEjbAvailableAfterApplicationCreated event) {
        this.deploy(event.getApp(), event.getBeanContexts());
    }

    public void deploy(@Observes AssemblerAfterApplicationCreated event) {
        AppInfo appInfo = event.getApp();
        this.deploy(appInfo, event.getContext().getBeanContexts());
    }

    public void undeploy(@Observes AssemblerBeforeApplicationDestroyed event) {
        if (this.disabled) {
            return;
        }
        for (BeanContext beanContext : event.getContext().getBeanContexts()) {
            Class remoteItf = beanContext.getBusinessRemoteInterface();
            if (remoteItf == null) continue;
            String name = (String)String.class.cast(beanContext.getDeploymentID());
            this.registry.undeploy(this.virtualHost, HessianService.appName(event.getApp(), beanContext), name);
            LOGGER.info("Undeployed hessian service " + name);
        }
    }

    public static String appName(AppInfo app, BeanContext beanContext) {
        if (!app.webApps.isEmpty()) {
            for (EjbJarInfo ejbJar : app.ejbJars) {
                for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                    if (!bean.ejbName.equals(beanContext.getEjbName()) || !ejbJar.webapp) continue;
                    return ejbJar.moduleName;
                }
            }
        }
        return app.appId;
    }

    public String getName() {
        return "hessian";
    }

    public String getIP() {
        return "n/a";
    }

    public int getPort() {
        return -1;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isSendCollectionType() {
        return this.sendCollectionType;
    }

    public void setSendCollectionType(boolean sendCollectionType) {
        this.sendCollectionType = sendCollectionType;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public void setTransportGuarantee(String transportGuarantee) {
        this.transportGuarantee = transportGuarantee;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public void init(Properties props) throws Exception {
        this.disabled = Boolean.parseBoolean(props.getProperty("disabled", "false"));
        this.debug = Boolean.parseBoolean(props.getProperty("debug", "false"));
        this.sendCollectionType = Boolean.parseBoolean(props.getProperty("sendCollectionType", "false"));
        this.realmName = props.getProperty("realmName");
        this.transportGuarantee = props.getProperty("transportGuarantee", "NONE");
        this.virtualHost = props.getProperty("virtualHost", "localhost");
        this.authMethod = props.getProperty("authMethod", "NONE");
        this.serializerFactory = props.getProperty("serializerFactory", null);
    }
}

