/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.hessian;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.hessian.HessianRegistry;
import org.apache.openejb.server.hessian.HessianServer;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.OpenEJBHttpRegistry;
import org.apache.openejb.server.httpd.util.HttpUtil;

public class HessianRegistryImpl
extends OpenEJBHttpRegistry
implements HessianRegistry {
    @Override
    public String deploy(ClassLoader loader, HessianServer listener, String host, String app, String authMethod, String transportGuarantee, String realmName, String name) {
        String path = HessianRegistryImpl.generateEndpointName(app, name);
        this.addWrappedHttpListener(new HessianListener(listener), loader, path);
        return HttpUtil.selectSingleAddress((List)this.getResolvedAddresses(path));
    }

    @Override
    public void undeploy(String host, String app, String name) {
        ((HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class)).removeHttpListener(HessianRegistryImpl.generateEndpointName(app, name));
    }

    private static String generateEndpointName(String app, String name) {
        return "/" + app + HESSIAN + name;
    }

    protected static class HessianListener
    implements HttpListener {
        private final HessianServer delegate;

        protected HessianListener(HessianServer server) {
            this.delegate = server;
        }

        public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
            try {
                this.delegate.invoke((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
            }
            catch (Throwable throwable) {
                if (Exception.class.isInstance(throwable)) {
                    throw (Exception)Exception.class.cast(throwable);
                }
                throw new OpenEJBRuntimeException(throwable.getMessage(), throwable);
            }
        }
    }
}

