/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi.internal;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessSessionBean;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.apache.openejb.AppContext;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.cdi.OpenEJBLifecycle;
import org.apache.openejb.cdi.api.Hessian;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.hessian.HessianRegistry;
import org.apache.openejb.server.hessian.HessianServer;
import org.apache.openejb.server.hessian.HessianService;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;

public class HessianExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(HessianExtension.class.getName());
    private final Collection<Deployment> toDeploy = new ArrayList<Deployment>();
    private final Collection<DeployedEndpoint> deployed = new ArrayList<DeployedEndpoint>();
    private AppInfo appInfo;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.appInfo = (AppInfo)OpenEJBLifecycle.CURRENT_APP_INFO.get();
        if (this.appInfo == null) {
            throw new IllegalStateException("Without OpenEJBLifecycle this Extension can't work correctly");
        }
    }

    protected <X> void findHessianWebServices(@Observes ProcessBean<X> processBean) {
        if (ProcessSessionBean.class.isInstance(processBean)) {
            return;
        }
        Bean bean = processBean.getBean();
        Class beanClass = bean.getBeanClass();
        for (Class<?> itf : beanClass.getInterfaces()) {
            Hessian hessian = itf.getAnnotation(Hessian.class);
            String key = "openejb.hessian." + beanClass.getName() + "_" + itf.getName() + ".path";
            String path = this.appInfo.properties.getProperty(key, SystemInstance.get().getProperty(key));
            if (hessian == null && path == null) continue;
            this.toDeploy.add(new Deployment(itf, path, bean));
        }
    }

    protected void deploy(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager bm) {
        HessianService service = (HessianService)SystemInstance.get().getComponent(HessianService.class);
        if (service == null) {
            LOGGER.severe("HessianService not yet started, no hessian CDI webservices will be deployed");
            return;
        }
        HessianRegistry registry = service.getRegistry();
        String appName = this.findAppName();
        for (Deployment deployment : this.toDeploy) {
            HessianServer server;
            Hessian hessian = deployment.itf.getAnnotation(Hessian.class);
            try {
                server = new HessianServer(deployment.bean.getBeanClass().getClassLoader());
            }
            catch (HessianServer.HessianIsMissingException e) {
                LOGGER.info("Hessian is not available so openejb-hessian will not deploy any service");
                break;
            }
            try {
                if (hessian != null && hessian.serializerFactory() != Object.class && !hessian.serializerFactory().isInstance(server.getSerializerFactory())) {
                    server.serializerFactory(hessian.serializerFactory().newInstance());
                }
            }
            catch (Exception e) {
                throw new OpenEJBRuntimeException(e);
            }
            if (hessian != null) {
                server.sendCollectionType(hessian.sendCollectionType());
            }
            if (Dependent.class.equals((Object)deployment.bean.getScope())) {
                LOGGER.warning("@Dependent can lead to memory leaks ATM");
            }
            server.createSkeleton(bm.getReference(deployment.bean, deployment.itf, null), deployment.itf);
            String name = HessianExtension.getName(deployment.path, deployment.itf);
            try {
                LOGGER.info("Hessian(url=" + registry.deploy(deployment.itf.getClassLoader(), server, service.getVirtualHost(), appName, service.getAuthMethod(), service.getTransportGuarantee(), service.getRealmName(), name) + ", interface=" + name + ")");
                this.deployed.add(new DeployedEndpoint(appName, name));
            }
            catch (URISyntaxException e) {
                throw new OpenEJBRuntimeException((Exception)e);
            }
        }
        this.toDeploy.clear();
    }

    private String findAppName() {
        if (this.appInfo.webAppAlone) {
            return ((WebAppInfo)this.appInfo.webApps.iterator().next()).contextRoot;
        }
        for (AppContext app : ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContexts()) {
            for (WebContext webContext : app.getWebContexts()) {
                if (!this.isSameContext(webContext.getWebBeansContext())) continue;
                String contextRoot = webContext.getContextRoot();
                if (contextRoot != null) {
                    if (contextRoot.startsWith("/")) {
                        return contextRoot.substring(1);
                    }
                    return contextRoot;
                }
                return webContext.getId();
            }
            if (!this.isSameContext(app.getWebBeansContext())) continue;
            return app.getId();
        }
        throw new IllegalArgumentException("Can't find application matching bean manager");
    }

    private boolean isSameContext(WebBeansContext app) {
        BeanManagerImpl bm = app.getBeanManagerImpl();
        try {
            return bm.isInUse() && this.equals(bm.getExtension(HessianExtension.class));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void shutdown(@Observes BeforeShutdown unused) {
        HessianService service = (HessianService)SystemInstance.get().getComponent(HessianService.class);
        if (service == null) {
            return;
        }
        HessianRegistry registry = service.getRegistry();
        for (DeployedEndpoint pair : this.deployed) {
            registry.undeploy(service.getVirtualHost(), pair.app, pair.name);
            LOGGER.info("Undeployed CDI hessian service " + pair.name);
        }
        this.deployed.clear();
    }

    private static String getName(String path, Class<?> itf) {
        if (path != null) {
            return path;
        }
        Hessian hessian = itf.getAnnotation(Hessian.class);
        if (hessian != null) {
            String name = hessian.path();
            if (name.isEmpty()) {
                return itf.getName();
            }
            return name;
        }
        return itf.getName();
    }

    protected static class Deployment {
        private final Class<?> itf;
        private final String path;
        private final Bean<?> bean;

        public Deployment(Class<?> itf, String path, Bean<?> bean) {
            this.itf = itf;
            this.path = path;
            this.bean = bean;
        }
    }

    protected static class DeployedEndpoint {
        private final String app;
        private final String name;

        protected DeployedEndpoint(String app, String name) {
            this.app = app;
            this.name = name;
        }
    }
}

