/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

public class Logs {
    public static String forceLength(String httpMethod, int l, boolean right) {
        int i;
        String http = httpMethod == null ? "" : httpMethod;
        StringBuilder builder = new StringBuilder();
        if (!right) {
            for (i = 0; i < l - http.length(); ++i) {
                builder.append(" ");
            }
        }
        builder.append(http);
        if (right) {
            for (i = 0; i < l - http.length(); ++i) {
                builder.append(" ");
            }
        }
        return builder.toString();
    }

    public static String toSimpleString(Method mtd) {
        try {
            StringBuilder sb = new StringBuilder();
            TypeVariable<Method>[] typeparms = mtd.getTypeParameters();
            if (typeparms.length > 0) {
                boolean first = true;
                sb.append("<");
                for (TypeVariable<Method> typeparm : typeparms) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(Logs.name(typeparm));
                    first = false;
                }
                sb.append("> ");
            }
            Type genRetType = mtd.getGenericReturnType();
            sb.append(Logs.name(genRetType)).append(" ");
            sb.append(mtd.getName()).append("(");
            Type[] params = mtd.getGenericParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(Logs.name(params[j]));
                if (j >= params.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            Type[] exceptions = mtd.getGenericExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(Logs.name(exceptions[k]));
                    if (k >= exceptions.length - 1) continue;
                    sb.append(",");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public static String name(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName().replace("java.lang.", "").replace("java.util", "");
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(Logs.name(pt.getRawType()));
            Type[] args = pt.getActualTypeArguments();
            if (args != null) {
                builder.append("<");
                for (int i = 0; i < args.length; ++i) {
                    builder.append(Logs.name(args[i]));
                    if (i >= args.length - 1) continue;
                    builder.append(", ");
                }
                builder.append(">");
            }
            return builder.toString();
        }
        return type.toString();
    }

    public static String singleSlash(String address, String value) {
        if (address.endsWith("/") && value.startsWith("/")) {
            return address + value.substring(1);
        }
        if (!address.endsWith("/") && !value.startsWith("/")) {
            return address + '/' + value;
        }
        if (value.equals("/")) {
            return address;
        }
        return address + value;
    }

    public static class LogResourceEndpointInfo
    implements Comparable<LogResourceEndpointInfo> {
        public final String type;
        public final String address;
        public final String classname;
        public final List<LogOperationEndpointInfo> operations;
        public final int methodSize;
        public final int methodStrSize;

        public LogResourceEndpointInfo(String type, String address, String classname, List<LogOperationEndpointInfo> operations, int methodSize, int methodStrSize) {
            this.type = type;
            this.address = address;
            this.classname = classname;
            this.operations = operations;
            this.methodSize = methodSize;
            this.methodStrSize = methodStrSize;
        }

        @Override
        public int compareTo(LogResourceEndpointInfo o) {
            int compare = this.type.compareTo(o.type);
            if (compare != 0) {
                return compare;
            }
            compare = this.address.compareTo(o.address);
            if (compare != 0) {
                return compare;
            }
            return this.classname.compareTo(o.classname);
        }
    }

    public static class LogOperationEndpointInfo
    implements Comparable<LogOperationEndpointInfo> {
        public final String http;
        public final String address;
        public final String method;

        public LogOperationEndpointInfo(String http, String address, String method) {
            this.address = address;
            this.method = method;
            this.http = http != null ? http : "";
        }

        @Override
        public int compareTo(LogOperationEndpointInfo o) {
            int compare = this.http.compareTo(o.http);
            if (compare != 0) {
                return compare;
            }
            compare = this.address.compareTo(o.address);
            if (compare != 0) {
                return compare;
            }
            return this.method.compareTo(o.method);
        }

        public String toString() {
            return "LogOperationEndpointInfo{http='" + this.http + '\'' + ", address='" + this.address + '\'' + ", method='" + this.method + '\'' + '}';
        }
    }
}

