/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli.command;

import org.apache.openejb.server.cli.command.AbstractCommand;
import org.apache.openejb.server.cli.command.Command;
import org.apache.openejb.util.OpenEJBScripter;

@Command(name="script", usage="script <code>", description="execute script code in the specified language. ejb can be accessed through their ejb name in the script.")
public class ScriptCommand
extends AbstractCommand {
    protected OpenEJBScripter scripter;
    protected String language;
    protected String script;

    @Override
    public void execute(String cmd) {
        try {
            this.parse(cmd);
            Object result = this.scripter.evaluate(this.language, this.script);
            this.streamManager.writeOut(this.streamManager.asString(result));
        }
        catch (Exception e) {
            this.streamManager.writeErr(e);
        }
    }

    private void parse(String parseableCmd) {
        int spaceIdx = parseableCmd.indexOf(" ");
        if (spaceIdx < 0) {
            throw new IllegalArgumentException("bad syntax, see help");
        }
        this.language = parseableCmd.substring(0, spaceIdx);
        this.script = parseableCmd.substring(spaceIdx + 1, parseableCmd.length());
    }

    public void setScripter(OpenEJBScripter scripter) {
        this.scripter = scripter;
    }
}

