/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.config;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.servlet.ServletContext;
import java.security.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.openejb.util.CachedSupplier;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.microprofile.jwt.JWTLogCategories;
import org.apache.tomee.microprofile.jwt.config.JWTAuthConfiguration;
import org.apache.tomee.microprofile.jwt.keys.DecryptKeys;
import org.apache.tomee.microprofile.jwt.keys.FixedKeys;
import org.apache.tomee.microprofile.jwt.keys.PublicKeys;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ApplicationScoped
public class JWTAuthConfigurationProperties {
    public static final String PUBLIC_KEY_ERROR = "Could not read MicroProfile Public Key";
    public static final String PUBLIC_KEY_ERROR_LOCATION = "Could not read MicroProfile Public Key from Location: ";
    private static final Logger CONFIGURATION = Logger.getInstance((LogCategory)JWTLogCategories.CONFIG, JWTAuthConfigurationProperties.class);
    private Config config;
    private JWTAuthConfiguration jwtAuthConfiguration;

    public void init(@Observes @Initialized(value=ApplicationScoped.class) ServletContext context) {
        this.config = ConfigProvider.getConfig();
        this.jwtAuthConfiguration = this.createJWTAuthConfiguration();
    }

    public Optional<JWTAuthConfiguration> getJWTAuthConfiguration() {
        return Optional.ofNullable(this.jwtAuthConfiguration);
    }

    private Optional<String> getVerifierPublicKey() {
        return this.config.getOptionalValue("mp.jwt.verify.publickey", String.class).map(s -> s.isEmpty() ? null : s);
    }

    private Optional<String> getPublicKeyLocation() {
        return this.config.getOptionalValue("mp.jwt.verify.publickey.location", String.class).map(s -> s.isEmpty() ? null : s);
    }

    private Optional<String> getIssuer() {
        return this.config.getOptionalValue("mp.jwt.verify.issuer", String.class);
    }

    private List<String> getAudiences() {
        String audiences = this.config.getOptionalValue("mp.jwt.verify.audiences", String.class).orElse(null);
        if (audiences == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(audiences.split(" *, *"));
    }

    private JWTAuthConfiguration createJWTAuthConfiguration() {
        if (this.getVerifierPublicKey().isPresent() && this.getPublicKeyLocation().isPresent()) {
            throw new DeploymentException("Both mp.jwt.verify.publickey and mp.jwt.verify.publickey.location are being supplied. You must use only one.");
        }
        List<String> audiences = this.getAudiences();
        Supplier<Map<String, Key>> publicKeys = Keys.VERIFY.configure(this.config);
        Supplier<Map<String, Key>> decryptKeys = Keys.DECRYPT.configure(this.config);
        Boolean allowNoExp = this.queryAllowExp();
        return new JWTAuthConfiguration(publicKeys, this.getIssuer().orElse(null), allowNoExp, audiences.toArray(new String[0]), decryptKeys, this.config.getOptionalValue("mp.jwt.token.header", String.class).map(String::toLowerCase).orElse("authorization"), this.config.getOptionalValue("mp.jwt.token.cookie", String.class).map(String::toLowerCase).orElse("bearer"), this.config.getOptionalValue("mp.jwt.decrypt.key.algorithm", String.class).orElse(null), this.config.getOptionalValue("mp.jwt.verify.publickey.algorithm", String.class).orElse(null), this.config.getOptionalValue("mp.jwt.verify.token.age", Integer.class).orElse(null), this.config.getOptionalValue("mp.jwt.verify.clock.skew", Integer.class).orElse(0));
    }

    private Boolean queryAllowExp() {
        Optional allowExp = this.config.getOptionalValue("tomee.mp.jwt.allow.no-exp", Boolean.class);
        Optional allowExpDeprecatedValue = this.config.getOptionalValue("mp.jwt.tomee.allow.no-exp", Boolean.class);
        if (allowExpDeprecatedValue.isPresent()) {
            CONFIGURATION.warning("mp.jwt.tomee.allow.no-exp property is deprecated, use tomee.mp.jwt.allow.no-exp property instead.");
        }
        return allowExp.or(() -> allowExpDeprecatedValue).orElse(false);
    }

    static enum Keys {
        VERIFY("mp.jwt.verify.publickey", "tomee.jwt.verify.publickey"),
        DECRYPT("mp.jwt.decrypt.key", "tomee.jwt.decrypt.key");

        private final String mpPrefix;
        private final String tomeePrefix;

        private Keys(String mpPrefix, String tomeePrefix) {
            this.mpPrefix = mpPrefix;
            this.tomeePrefix = tomeePrefix;
        }

        public Supplier<Map<String, Key>> configure(Config config) {
            Options options = new Options(config);
            Optional<String> contents = options.contents();
            Optional<String> location = options.location();
            if (contents.isEmpty() && location.isEmpty()) {
                return new Unset();
            }
            Supplier<Map<String, Key>> supplier = switch (this) {
                case VERIFY -> new PublicKeys(contents, location);
                case DECRYPT -> new DecryptKeys(contents, location);
                default -> throw new IllegalArgumentException("Unsupported enum value: " + this);
            };
            if (options.cached()) {
                return CachedSupplier.builder((Supplier)supplier).refreshInterval(options.refreshInterval()).initialRetryDelay(options.initialRetryDelay()).maxRetryDelay(options.maxRetryDelay()).accessTimeout(options.accessTimeout()).logger(Logger.getInstance((LogCategory)JWTLogCategories.KEYS, supplier.getClass())).build();
            }
            return new FixedKeys(supplier.get());
        }

        class Options {
            private final Config config;

            public Options(Config config) {
                this.config = config;
            }

            Optional<String> contents() {
                return this.config.getOptionalValue(Keys.this.mpPrefix, String.class);
            }

            Optional<String> location() {
                return this.config.getOptionalValue(Keys.this.mpPrefix + ".location", String.class);
            }

            boolean cached() {
                boolean cacheByDefault = this.location().filter(s -> s.startsWith("http")).isPresent();
                return this.config.getOptionalValue(Keys.this.tomeePrefix + ".cache", Boolean.class).orElse(cacheByDefault);
            }

            Duration initialRetryDelay() {
                return this.config.getOptionalValue(Keys.this.tomeePrefix + ".cache.initialRetryDelay", Duration.class).orElse(new Duration(2L, TimeUnit.SECONDS));
            }

            Duration maxRetryDelay() {
                return this.config.getOptionalValue(Keys.this.tomeePrefix + ".cache.maxRetryDelay", Duration.class).orElse(new Duration(1L, TimeUnit.HOURS));
            }

            Duration accessTimeout() {
                return this.config.getOptionalValue(Keys.this.tomeePrefix + ".cache.accessTimeout", Duration.class).orElse(new Duration(30L, TimeUnit.SECONDS));
            }

            Duration refreshInterval() {
                return this.config.getOptionalValue(Keys.this.tomeePrefix + ".cache.refreshInterval", Duration.class).orElse(new Duration(1L, TimeUnit.DAYS));
            }
        }
    }

    public static class Unset
    implements Supplier<Map<String, Key>> {
        @Override
        public Map<String, Key> get() {
            return Collections.EMPTY_MAP;
        }
    }
}

