/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin.runner;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.Zips;
import org.apache.tomee.util.QuickServerXmlParser;

public class ExecRunner {
    private static final String SH_BAT_AUTO = "[.sh|.bat]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] rawArgs) throws Exception {
        int lastSlash;
        String cmd;
        File[] scripts;
        String[] args = rawArgs == null || rawArgs.length == 0 ? new String[]{"run"} : rawArgs;
        Properties config = new Properties();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = contextClassLoader.getResourceAsStream("configuration.properties");
        if (is == null) {
            throw new IllegalArgumentException("Config not found");
        }
        config.load(new InputStreamReader(is, "UTF-8"));
        is.close();
        String distrib = config.getProperty("distribution");
        String workingDir = config.getProperty("workingDir");
        InputStream distribIs = contextClassLoader.getResourceAsStream(distrib);
        File distribOutput = new File(workingDir);
        File timestampFile = new File(distribOutput, "timestamp.txt");
        boolean forceDelete = Boolean.getBoolean("tomee.runner.force-delete");
        if (forceDelete || !timestampFile.exists() || Long.parseLong(IO.slurp((File)timestampFile).replace(System.getProperty("line.separator"), "")) < Long.parseLong(config.getProperty("timestamp"))) {
            if (forceDelete || timestampFile.exists()) {
                System.out.println("Deleting " + distribOutput.getAbsolutePath());
                Files.delete((File)distribOutput);
            }
            System.out.println("Extracting tomee to " + distribOutput.getAbsolutePath());
            Zips.unzip((InputStream)distribIs, (File)distribOutput, (boolean)false);
            IO.writeString((File)timestampFile, (String)config.getProperty("timestamp", Long.toString(System.currentTimeMillis())));
        }
        if ((scripts = new File(distribOutput, "bin").listFiles()) != null) {
            for (File f : scripts) {
                ExecRunner.setExecutable(f);
            }
        }
        if ((cmd = config.getProperty("command")).endsWith(SH_BAT_AUTO) && (lastSlash = cmd.lastIndexOf(47)) > 0) {
            String dir = cmd.substring(0, lastSlash);
            boolean isWin = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
            String script = cmd.substring(lastSlash + 1, cmd.length() - SH_BAT_AUTO.length()).replace('/', isWin ? (char)'\\' : '/') + (isWin ? ".bat" : ".sh");
            File scriptFile = new File(distribOutput, dir + File.separator + script);
            if (!scriptFile.exists()) {
                throw new IllegalArgumentException("Can't find  " + cmd);
            }
            cmd = scriptFile.getAbsolutePath();
            ExecRunner.setExecutable(scriptFile);
        }
        String additionalArgs = System.getProperty("additionalSystemProperties");
        HashMap map = new HashMap();
        Collection<Runnable> preTasks = ExecRunner.buildRunnables(config.getProperty("preTasks"), map);
        Collection<Runnable> postTasks = ExecRunner.buildRunnables(config.getProperty("postTasks"), map);
        boolean doWait = Boolean.parseBoolean(config.getProperty("waitFor"));
        if (!doWait && !postTasks.isEmpty()) {
            throw new IllegalArgumentException("You can't use post task if you dont wait for the process.");
        }
        for (Runnable r : preTasks) {
            r.run();
        }
        try {
            ArrayList<String> params = new ArrayList<String>();
            if ("java".equals(cmd)) {
                File base = ExecRunner.findBase(distribOutput);
                QuickServerXmlParser parser = QuickServerXmlParser.parse((File)new File(base, "conf/server.xml"));
                System.setProperty("openejb.home", base.getAbsolutePath());
                System.setProperty("server.shutdown.port", parser.stop());
                System.setProperty("server.shutdown.command", config.getProperty("shutdownCommand"));
                RemoteServer server = new RemoteServer();
                server.setPortStartup(Integer.parseInt(parser.http()));
                if (config.containsKey("additionalClasspath")) {
                    server.setAdditionalClasspath(config.getProperty("additionalClasspath"));
                }
                LinkedList<String> jvmArgs = new LinkedList<String>();
                if (additionalArgs != null) {
                    Collections.addAll(jvmArgs, additionalArgs.split(" "));
                }
                for (String k : config.stringPropertyNames()) {
                    if (!k.startsWith("jvmArg.")) continue;
                    jvmArgs.add(config.getProperty(k));
                }
                String userProps = (String)String.class.cast(map.get("jvmArgs"));
                if (userProps != null) {
                    Collections.addAll(jvmArgs, userProps.split(" "));
                }
                if ("run".equals(args[0])) {
                    args[0] = "start";
                }
                try {
                    server.start(jvmArgs, args[0], true);
                }
                catch (Exception e) {
                    server.destroy();
                    throw e;
                }
                if (doWait) {
                    server.getServer().waitFor();
                }
            } else {
                if (cmd.endsWith(".bat") && !cmd.startsWith("cmd.exe")) {
                    params.add("cmd.exe");
                    params.add("/c");
                }
                params.add(cmd);
                params.addAll(Arrays.asList(args));
                ProcessBuilder builder = new ProcessBuilder(params.toArray(new String[params.size()])).inheritIO().directory(ExecRunner.findBase(distribOutput));
                String existingOpts = System.getenv("CATALINA_OPTS");
                String catalinaOpts = config.getProperty("catalinaOpts");
                if (catalinaOpts != null || existingOpts != null || additionalArgs != null) {
                    builder.environment().put("CATALINA_OPTS", ExecRunner.identityOrEmpty(catalinaOpts) + " " + ExecRunner.identityOrEmpty(existingOpts) + " " + ExecRunner.identityOrEmpty(additionalArgs) + " " + ExecRunner.identityOrEmpty((String)String.class.cast(map.get("jvmArgs"))));
                }
                if (doWait) {
                    builder.start().waitFor();
                }
            }
            System.out.flush();
            System.err.flush();
            System.out.println("Exited Successfully!");
        }
        finally {
            for (Runnable r : postTasks) {
                r.run();
            }
        }
    }

    private static Collection<Runnable> buildRunnables(String classes, Map<?, ?> state) {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        if (classes == null || classes.trim().isEmpty()) {
            return tasks;
        }
        for (String className : classes.split(" *, *")) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                try {
                    Constructor<?> cons = clazz.getConstructor(Map.class);
                    tasks.add((Runnable)Runnable.class.cast(cons.newInstance(state)));
                }
                catch (Throwable th) {
                    tasks.add((Runnable)Runnable.class.cast(clazz.newInstance()));
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return tasks;
    }

    private static void setExecutable(File f) {
        if (f.getName().endsWith(".sh") && !f.canExecute() && !f.setExecutable(true, true)) {
            System.err.println("Failed make file executable: " + String.valueOf(f));
        }
    }

    private static File findBase(File distribOutput) {
        File[] extracted = distribOutput.listFiles();
        if (extracted != null) {
            File newRoot = null;
            for (File e : extracted) {
                if (!e.isDirectory()) continue;
                if (newRoot == null) {
                    newRoot = e;
                    continue;
                }
                newRoot = null;
                break;
            }
            if (newRoot != null) {
                return newRoot;
            }
        }
        return distribOutput;
    }

    private static String identityOrEmpty(String value) {
        return value != null ? value : "";
    }

    private ExecRunner() {
    }
}

