/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin.customizer.monkey;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.loader.IO;
import org.apache.openejb.maven.plugin.customizer.monkey.file.PatchFolderFinder;
import org.apache.openejb.maven.plugin.customizer.monkey.index.FileIndexer;
import org.apache.openejb.maven.plugin.customizer.monkey.index.Item;
import org.apache.openejb.maven.plugin.customizer.monkey.jar.JarPatcher;

public class Monkey
implements Runnable {
    public static final String MONKEY_CONFIGURATION_FILE = "tomee-monkey.properties";
    private final File base;
    private final File classes;
    private final File tempFolder;
    private final Properties configuration;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Monkey(File base) {
        this.base = base;
        File target = new PatchFolderFinder().findTarget(base);
        this.classes = new File(target, "classes");
        if (!this.classes.isDirectory()) {
            throw new IllegalArgumentException("target/classes doesn't exist");
        }
        this.tempFolder = new File(target, "MonkeyPatcher_" + System.currentTimeMillis());
        this.tempFolder.mkdirs();
        File configurationFile = new File(this.classes, MONKEY_CONFIGURATION_FILE);
        this.configuration = new Properties();
        if (!configurationFile.isFile()) return;
        FileInputStream is = null;
        try {
            is = new FileInputStream(configurationFile);
            this.configuration.load(is);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalArgumentException(e);
                catch (IOException e2) {
                    throw new IllegalStateException(e2);
                }
            }
            catch (Throwable throwable) {
                IO.close(is);
                throw throwable;
            }
        }
        IO.close((Closeable)is);
    }

    @Override
    public void run() {
        PrintStream stream = System.out;
        FileIndexer indexer = new FileIndexer(this.base, this.classes, this.configuration, MONKEY_CONFIGURATION_FILE).index().dump(stream);
        stream.println();
        JarPatcher patcher = new JarPatcher();
        stream.println("Patcher:");
        for (Map.Entry<File, List<Item>> entry : indexer.getIndex().entrySet()) {
            patcher.patch(stream, this.tempFolder, entry.getKey(), entry.getValue());
        }
        stream.println();
        stream.println(indexer.getIndex().size() + " jar patched.");
    }
}

