/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.Zips;
import org.apache.openejb.maven.plugin.AbstractAddressMojo;
import org.apache.openejb.maven.plugin.TomEEException;
import org.apache.openejb.maven.plugin.cli.Args;
import org.apache.openejb.util.JarExtractor;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.NetworkUtil;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.tomee.util.QuickServerXmlParser;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractTomEEMojo
extends AbstractAddressMojo {
    private static final String NAME_STR = "?name=";
    private static final String UNZIP_PREFIX = "unzip:";
    private static final String REMOVE_PREFIX = "remove:";
    public static final String QUIT_CMD = "quit";
    public static final String EXIT_CMD = "exit";
    public static final String TOM_EE = "TomEE";
    @Component
    protected ArtifactFactory factory;
    @Component
    protected ArtifactResolver resolver;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository local;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepos;
    @Parameter(property="tomee-plugin.skipCurrentProject", defaultValue="false")
    protected boolean skipCurrentProject;
    @Parameter(property="tomee-plugin.version", defaultValue="-1")
    protected String tomeeVersion;
    @Parameter(property="tomee-plugin.groupId", defaultValue="org.apache.tomee")
    protected String tomeeGroupId;
    @Parameter(property="tomee-plugin.artifactId", defaultValue="apache-tomee")
    protected String tomeeArtifactId;
    @Parameter(property="tomee-plugin.type", defaultValue="zip", readonly=true)
    protected String tomeeType;
    @Parameter(property="tomee-plugin.apache-repos", defaultValue="snapshots")
    protected String apacheRepos;
    @Parameter(property="tomee-plugin.classifier", defaultValue="webprofile")
    protected String tomeeClassifier;
    @Parameter(property="tomee-plugin.shutdown")
    protected String tomeeShutdownPort;
    @Parameter(property="tomee-plugin.shutdown.attempts", defaultValue="60")
    protected int tomeeShutdownAttempts;
    @Parameter(property="tomee-plugin.shutdown-command", defaultValue="SHUTDOWN")
    protected String tomeeShutdownCommand;
    @Parameter(property="tomee-plugin.ajp")
    protected String tomeeAjpPort;
    @Parameter(property="tomee-plugin.args")
    protected String args;
    @Parameter(property="tomee-plugin.debug", defaultValue="false")
    protected boolean debug;
    @Parameter(property="tomee-plugin.simple-log", defaultValue="false")
    protected boolean simpleLog;
    @Parameter(property="tomee-plugin.extractWars", defaultValue="false")
    protected boolean extractWars;
    @Parameter(property="tomee-plugin.stripWarVersion", defaultValue="true")
    protected boolean stripWarVersion;
    @Parameter(property="tomee-plugin.stripVersion", defaultValue="false")
    protected boolean stripVersion;
    @Parameter(property="tomee-plugin.debugPort", defaultValue="5005")
    protected int debugPort;
    @Parameter(defaultValue="${project.basedir}/src/main/webapp", property="tomee-plugin.webappResources")
    protected File webappResources;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="tomee-plugin.webappClasses")
    protected File webappClasses;
    @Parameter(defaultValue="${project.build.directory}/apache-tomee", property="tomee-plugin.catalina-base")
    protected File catalinaBase;
    @Parameter
    protected String context;
    @Parameter
    protected String webappDir;
    @Parameter(defaultValue="apps")
    protected String appDir;
    @Parameter(defaultValue="lib")
    protected String libDir;
    @Parameter(defaultValue="${project.basedir}/src/main")
    protected File mainDir;
    @Parameter(defaultValue="${project.build.directory}")
    protected File target;
    @Parameter(property="tomee-plugin.conf", defaultValue="${project.basedir}/src/main/tomee/conf")
    protected File config;
    @Parameter(property="tomee-plugin.bin", defaultValue="${project.basedir}/src/main/tomee/bin")
    protected File bin;
    @Parameter(property="tomee-plugin.lib", defaultValue="${project.basedir}/src/main/tomee/lib")
    protected File lib;
    @Parameter
    protected Map<String, String> systemVariables;
    @Parameter
    protected List<String> classpaths;
    @Parameter(property="tomee-plugin.classpathSeparator")
    protected String classpathSeparator;
    @Parameter
    protected List<String> customizers;
    @Parameter
    protected List<String> jsCustomizers;
    @Parameter
    protected List<String> groovyCustomizers;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="tomee-plugin.webappDefaultConfig", defaultValue="false")
    protected boolean webappDefaultConfig;
    @Parameter(property="tomee-plugin.quick-session", defaultValue="true")
    protected boolean quickSession;
    @Parameter(property="tomee-plugin.force-reloadable", defaultValue="false")
    protected boolean forceReloadable;
    @Parameter(property="tomee-plugin.jsp-development", defaultValue="true")
    protected boolean forceJspDevelopment;
    @Parameter
    protected List<String> libs;
    @Parameter
    protected List<String> endorsedLibs;
    @Parameter
    protected List<String> javaagents;
    @Parameter(property="tomee-plugin.persist-javaagents", defaultValue="false")
    protected boolean persistJavaagents;
    @Parameter
    protected List<String> webapps;
    @Parameter
    protected List<String> apps;
    @Parameter(property="tomee-plugin.classes", defaultValue="${project.build.outputDirectory}", readonly=true)
    protected File classes;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}")
    protected File warFile;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", readonly=true)
    protected File workWarFile;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    protected String finalName;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    protected String artifactId;
    @Parameter(property="tomee-plugin.remove-default-webapps", defaultValue="true")
    protected boolean removeDefaultWebapps;
    @Parameter(property="tomee-plugin.deploy-openejb-internal-application", defaultValue="false")
    protected boolean deployOpenEjbApplication;
    @Parameter(property="tomee-plugin.remove-tomee-webapps", defaultValue="true")
    protected boolean removeTomeeWebapp;
    @Parameter(property="tomee-plugin.ejb-remote", defaultValue="true")
    protected boolean ejbRemote;
    @Parameter(defaultValue="${project.packaging}", readonly=true)
    protected String packaging;
    @Parameter(property="tomee-plugin.check-started", defaultValue="false")
    protected boolean checkStarted;
    @Parameter(property="tomee-plugin.check-started-attempts", defaultValue="60")
    protected int checkStartedAttempts;
    @Parameter(property="tomee-plugin.use-console", defaultValue="true")
    protected boolean useConsole;
    @Parameter(property="tomee-plugin.exiting", defaultValue="false")
    protected boolean tomeeAlreadyInstalled;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="tomee-plugin.openejb", defaultValue="false")
    protected boolean useOpenEJB;
    @Parameter
    protected List<File> docBases;
    @Parameter
    protected List<File> externalRepositories;
    @Parameter
    protected PlexusConfiguration inlinedServerXml;
    @Parameter
    protected PlexusConfiguration inlinedTomEEXml;
    @Parameter(property="tomee-plugin.override-on-unzip", defaultValue="true")
    protected boolean overrideOnUnzip;
    @Parameter(property="tomee-plugin.skip-root-folder-on-unzip", defaultValue="true")
    protected boolean skipRootFolderOnUnzip;
    @Parameter(property="tomee-plugin.keystore")
    protected String keystore;
    protected File deployedFile = null;
    protected RemoteServer server = null;
    protected String container = "TomEE";

    /*
     * Exception decompiling
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void scriptCustomization(List<String> customizers, String ext) throws MojoExecutionException {
        if (customizers != null) {
            ScriptEngine engine = new ScriptEngineManager().getEngineByExtension(ext);
            if (engine == null) {
                throw new IllegalStateException("No engine for " + ext + ". Maybe add the JSR223 implementation as plugin dependency.");
            }
            for (String js : customizers) {
                try {
                    SimpleBindings bindings = new SimpleBindings();
                    bindings.put("catalinaBase", (Object)this.catalinaBase.getAbsolutePath());
                    bindings.put("resolver", (Object)new Resolver(){

                        @Override
                        public File resolve(String group, String artifact, String version, String classifier, String type) {
                            try {
                                return AbstractTomEEMojo.this.resolve((String)group, (String)artifact, (String)version, (String)classifier, (String)type).resolved;
                            }
                            catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                                throw new IllegalArgumentException(e);
                            }
                        }

                        @Override
                        public File resolve(String group, String artifact, String version) {
                            try {
                                return AbstractTomEEMojo.this.resolve((String)group, (String)artifact, (String)version, null, (String)"jar").resolved;
                            }
                            catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                                throw new IllegalArgumentException(e);
                            }
                        }

                        @Override
                        public File resolve(String group, String artifact, String version, String type) {
                            try {
                                return AbstractTomEEMojo.this.resolve((String)group, (String)artifact, (String)version, null, (String)type).resolved;
                            }
                            catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                                throw new IllegalArgumentException(e);
                            }
                        }
                    });
                    engine.eval((Reader)new StringReader(js), (Bindings)bindings);
                }
                catch (ScriptException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        }
    }

    private void alignConfigOnServerXmlCurrentConfig() {
        File sXml = new File(this.catalinaBase, "conf/server.xml");
        if (sXml.isFile()) {
            String appBase;
            QuickServerXmlParser quickServerXmlParser = QuickServerXmlParser.parse((File)sXml, (boolean)false);
            this.tomeeHttpPort = quickServerXmlParser.value("HTTP", null);
            this.tomeeHttpsPort = quickServerXmlParser.value("HTTPS", null);
            this.tomeeAjpPort = quickServerXmlParser.value("AJP", null);
            this.tomeeShutdownPort = quickServerXmlParser.value("STOP", null);
            String host = quickServerXmlParser.value("host", null);
            if (host != null) {
                this.tomeeHost = host;
            }
            if ((appBase = quickServerXmlParser.value("app-base", null)) != null) {
                this.webappDir = appBase;
            }
        }
        if (this.webappDir == null) {
            this.webappDir = "webapps";
        }
    }

    private ClassLoader createClassLoader(ClassLoader parent) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : this.project.getArtifacts()) {
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)("can't use artifact " + artifact.toString()));
            }
        }
        if (this.classes != null && this.classes.exists()) {
            try {
                urls.add(this.classes.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)("can't use path " + this.classes.getAbsolutePath()));
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    protected void fixConfig() {
        if (this.useOpenEJB) {
            this.tomeeGroupId = "org.apache.tomee";
            this.tomeeArtifactId = "openejb-standalone";
            this.tomeeClassifier = null;
            this.tomeeShutdownCommand = "Q";
            if ("8005".equals(this.tomeeShutdownPort)) {
                this.tomeeShutdownPort = "4200";
            }
            if (this.tomeeVersion.startsWith("2.")) {
                this.tomeeVersion = OpenEjbVersion.get().getVersion();
            }
            if (this.catalinaBase.getName().equals("apache-tomee") && this.catalinaBase.getParentFile().equals(this.target)) {
                this.catalinaBase = new File(this.target, "apache-openejb");
            }
            if (this.config.getParentFile().getName().equals("tomee") && this.config.getParentFile().getParentFile().equals(this.mainDir)) {
                this.config = new File(this.mainDir, "openejb/conf");
            }
            if (this.lib.getParentFile().getName().equals("tomee") && this.lib.getParentFile().getParentFile().equals(this.mainDir)) {
                this.lib = new File(this.mainDir, "openejb/lib");
            }
            if (this.bin.getParentFile().getName().equals("tomee") && this.bin.getParentFile().getParentFile().equals(this.mainDir)) {
                this.bin = new File(this.mainDir, "openejb/bin");
            }
        }
    }

    protected String getAdditionalClasspath() {
        if (!this.classpaths.isEmpty()) {
            StringBuilder cpBuilder = new StringBuilder();
            for (String cp : this.classpaths) {
                String[] split = cp.split(":");
                if (split.length >= 3) {
                    FileWithMavenMeta jar;
                    try {
                        jar = this.resolve(split[0], split[1], split[2], split.length > 4 ? split[4] : null, split.length > 3 ? split[3] : "jar");
                    }
                    catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                        throw new IllegalArgumentException(e);
                    }
                    File classpathRoot = new File(this.catalinaBase, "boot");
                    if (!classpathRoot.isDirectory()) {
                        Files.mkdirs((File)classpathRoot);
                    }
                    File target = new File(classpathRoot, this.stripVersion ? jar.stripVersion(true) : jar.resolved.getName());
                    try {
                        IO.copy((File)jar.resolved, (File)target);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                    cpBuilder.append("${openejb.base}/boot/").append(target.getName());
                } else {
                    cpBuilder.append(cp);
                }
                if (this.classpathSeparator == null) {
                    this.classpathSeparator = File.pathSeparator;
                }
                cpBuilder.append(this.classpathSeparator);
            }
            return cpBuilder.substring(0, cpBuilder.length() - 1);
        }
        return null;
    }

    private List<String> webappsAlreadyAdded() {
        File[] files;
        ArrayList<String> list = new ArrayList<String>();
        File webapps = new File(this.catalinaBase, this.webappDirOrImplicitDefault());
        if (webapps.exists() && webapps.isDirectory() && (files = webapps.listFiles()) != null) {
            for (File f : files) {
                list.add(f.getName());
            }
        }
        return list;
    }

    private String webappDirOrImplicitDefault() {
        return this.webappDir == null ? "webapps" : this.webappDir;
    }

    private void activateSimpleLog() {
        File loggingProperties = new File(this.catalinaBase, "conf/logging.properties");
        if (loggingProperties.exists() && !new File(this.config, "conf/logging.properties").exists()) {
            try {
                Object content = IO.slurp((File)loggingProperties);
                content = !((String)content).contains("java.util.logging.ConsoleHandler.formatter") ? (String)content + System.getProperty("line.separator") + "java.util.logging.ConsoleHandler.formatter = org.apache.tomee.jul.formatter.SimpleTomEEFormatter" : ((String)content).replace(SimpleFormatter.class.getName(), "org.apache.tomee.jul.formatter.SimpleTomEEFormatter");
                AbstractTomEEMojo.doWrite(loggingProperties, (String)content);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Can't set SimpleTomEEFormatter", (Throwable)e);
            }
        }
    }

    private void removeDefaultWebapps(boolean removeTomee, Collection<String> providedWebapps) {
        File[] files;
        File webapps = new File(this.catalinaBase, this.webappDirOrImplicitDefault());
        if (webapps.isDirectory() && null != (files = webapps.listFiles())) {
            for (File webapp : files) {
                String name = webapp.getName();
                if (!webapp.isDirectory() || providedWebapps.contains(name) || !removeTomee && name.equals("tomee")) continue;
                try {
                    FileUtils.deleteDirectory((File)webapp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.getLog().info((CharSequence)"Removed not mandatory default webapps");
    }

    private void copyLibs(List<String> files, File destParent, String defaultType) {
        if (files == null || files.isEmpty()) {
            return;
        }
        if (!destParent.exists() && !destParent.mkdirs()) {
            this.getLog().warn((CharSequence)("can't create '" + destParent.getPath() + "'"));
        }
        for (String file : files) {
            this.updateLib(file, destParent, defaultType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateLib(String rawLib, File rawDestParent, String defaultType) {
        BufferedOutputStream os;
        BufferedInputStream is;
        block13: {
            boolean isExplodedWar;
            is = null;
            os = null;
            String lib = rawLib;
            Object extractedName = null;
            if (lib.contains(NAME_STR)) {
                lib = lib.substring(0, rawLib.indexOf(NAME_STR));
                extractedName = rawLib.substring(rawLib.indexOf(NAME_STR) + NAME_STR.length(), rawLib.length());
                if (!(((String)extractedName).endsWith(".jar") || ((String)extractedName).endsWith(".war") || ((String)extractedName).endsWith(".ear") || ((String)extractedName).endsWith(".rar"))) {
                    extractedName = (String)extractedName + "." + defaultType;
                }
            }
            boolean isWar = "war".equals(defaultType);
            boolean unzip = isExplodedWar = this.extractWars && isWar;
            if (lib.startsWith(UNZIP_PREFIX)) {
                lib = lib.substring(UNZIP_PREFIX.length());
                unzip = true;
            }
            File destParent = rawDestParent;
            if (lib.startsWith(REMOVE_PREFIX)) {
                final String prefix = lib.substring(REMOVE_PREFIX.length());
                File[] files = destParent.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(prefix);
                    }
                });
                if (files == null) return;
                for (File file : files) {
                    if (!IO.delete((File)file)) {
                        file.deleteOnExit();
                    }
                    this.getLog().info((CharSequence)("Deleted " + file.getPath()));
                }
                return;
            }
            try {
                FileWithMavenMeta file = this.mvnToFile(lib, defaultType);
                if (extractedName == null && (this.stripVersion || isWar && this.stripWarVersion)) {
                    Object object = this.isCurrentArtifact(file) && file.version != null ? this.finalName.replace("-" + file.version, "") : (extractedName = file.stripVersion(!isExplodedWar));
                }
                if (!unzip) {
                    File dest = extractedName == null ? new File(destParent, file.resolved.getName()) : new File(destParent, (String)extractedName);
                    is = new BufferedInputStream(new FileInputStream(file.resolved));
                    os = new BufferedOutputStream(new FileOutputStream(dest));
                    IOUtil.copy((InputStream)is, (OutputStream)os);
                    this.getLog().info((CharSequence)("Copied '" + lib + "' in '" + dest.getAbsolutePath()));
                    break block13;
                }
                if (isExplodedWar) {
                    destParent = Files.mkdirs((File)new File(rawDestParent, (String)(extractedName != null ? extractedName : file.resolved.getName().replace(".war", ""))));
                }
                Zips.unzip((File)file.resolved, (File)destParent, (!isExplodedWar ? 1 : 0) != 0);
                this.getLog().info((CharSequence)("Unzipped '" + lib + "' in '" + destParent.getAbsolutePath()));
            }
            catch (Exception e) {
                try {
                    this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                    throw new TomEEException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(is);
                    IOUtil.close(os);
                    throw throwable;
                }
            }
        }
        IOUtil.close((InputStream)is);
        IOUtil.close(os);
        return;
    }

    private boolean isCurrentArtifact(FileWithMavenMeta file) {
        return file.artifact.equals(this.artifactId);
    }

    private FileWithMavenMeta mvnToFile(String lib, String defaultType) throws ArtifactResolutionException, ArtifactNotFoundException {
        String[] infos = lib.split(":");
        if (infos.length < 3) {
            throw new TomEEException("format for librairies should be <groupId>:<artifactId>:<version>[:<type>[:<classifier>]]");
        }
        String type = infos.length >= 4 ? infos[3] : defaultType;
        String classifier = infos.length == 5 ? infos[4] : null;
        return this.resolve(infos[0], infos[1], infos[2], classifier, type);
    }

    private FileWithMavenMeta resolve(String group, String artifact, String version, String classifier, String type) throws ArtifactResolutionException, ArtifactNotFoundException {
        Artifact dependencyArtifact = this.factory.createDependencyArtifact(group, artifact, VersionRange.createFromVersion((String)version), type, classifier, "compile");
        this.resolver.resolve(dependencyArtifact, this.remoteRepos, this.local);
        return new FileWithMavenMeta(group, artifact, version, classifier, type, dependencyArtifact.getFile());
    }

    private void copyWar() {
        File out;
        block15: {
            block14: {
                if ("pom".equals(this.packaging)) {
                    return;
                }
                boolean war = "war".equals(this.packaging);
                String name = this.destinationName();
                if (war) {
                    out = new File(this.catalinaBase, this.webappDir + "/" + name);
                } else {
                    File parent = new File(this.catalinaBase, this.appDir);
                    if (!parent.exists() && !parent.mkdirs()) {
                        this.getLog().warn((CharSequence)("can't create '" + parent.getPath() + "'"));
                    }
                    out = new File(parent, name);
                }
                JarExtractor.delete((File)out);
                if (!this.warFile.isDirectory() && name.endsWith("." + this.packaging)) {
                    String dir = name.substring(0, name.lastIndexOf(46));
                    File unpacked = war ? new File(this.catalinaBase, this.webappDir + "/" + dir) : new File(this.catalinaBase, this.appDir + "/" + dir);
                    JarExtractor.delete((File)unpacked);
                }
                if (this.extractWars) {
                    this.warFile = this.workWarFile;
                    if (this.context == null && out.getName().endsWith(".war") && !this.warFile.getName().endsWith(".war")) {
                        out = new File(out.getParentFile(), this.warFile.getName());
                    }
                }
                if (this.warFile.exists() && this.warFile.isDirectory()) {
                    try {
                        IO.copyDirectory((File)this.warFile, (File)out);
                    }
                    catch (IOException e) {
                        throw new TomEEException(e.getMessage(), e);
                    }
                }
                if (!this.warFile.exists()) break block14;
                FileInputStream is = null;
                FileOutputStream os = null;
                try {
                    is = new FileInputStream(this.warFile);
                    os = new FileOutputStream(out);
                    IOUtil.copy((InputStream)is, (OutputStream)os);
                    this.getLog().info((CharSequence)("Installed '" + this.warFile.getAbsolutePath() + "' in " + out.getAbsolutePath()));
                }
                catch (Exception e) {
                    try {
                        throw new TomEEException(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(is);
                        IOUtil.close(os);
                        throw throwable;
                    }
                }
                IOUtil.close((InputStream)is);
                IOUtil.close((OutputStream)os);
                break block15;
            }
            this.getLog().warn((CharSequence)("'" + String.valueOf(this.warFile) + "' doesn't exist, ignoring (maybe run mvn package before this plugin)"));
        }
        this.deployedFile = out;
    }

    protected String destinationName() {
        if (this.context != null) {
            if (!this.context.contains(".") && !this.warFile.isDirectory()) {
                return this.context + "." + this.packaging;
            }
            return this.context;
        }
        return this.warFile.getName();
    }

    private void overrideServerXml() {
        String original;
        File serverXml = new File(this.catalinaBase, "conf/server.xml");
        if (!serverXml.exists()) {
            return;
        }
        QuickServerXmlParser parser = QuickServerXmlParser.parse((File)serverXml);
        String value = original = AbstractTomEEMojo.read(serverXml);
        if (this.tomeeHttpsPort != null && this.tomeeHttpsPort.length() > 0 && parser.value("HTTPS", null) == null) {
            File conf;
            Object keystorePath;
            Object object = keystorePath = this.keystore != null ? this.keystore : parser.keystore();
            if (keystorePath == null && (conf = new File(this.catalinaBase, "conf")).isDirectory()) {
                File[] jks = conf.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jks");
                    }
                });
                if (jks != null && jks.length == 1) {
                    keystorePath = "${catalina.base}/conf/" + jks[0].getName();
                } else {
                    throw new IllegalArgumentException("Ambiguous jks in conf/,please use <keystore /> to force it.");
                }
            }
            if (keystorePath == null) {
                throw new IllegalArgumentException("No keystore specified, please use <keystore></keystore>");
            }
            value = value.replace("<Service name=\"Catalina\">", "<Service name=\"Catalina\">\n    <Connector port=\"" + this.tomeeHttpsPort + "\" protocol=\"HTTP/1.1\" SSLEnabled=\"true\"\n                scheme=\"https\" secure=\"true\"\n                clientAuth=\"false\" sslProtocol=\"TLS\" keystoreFile=\"" + (String)keystorePath + "\" />\n");
        }
        if (this.tomeeHttpPort != null) {
            value = value.replace("\"" + parser.http() + "\"", "\"" + this.tomeeHttpPort + "\"");
        }
        if (this.tomeeHttpsPort != null) {
            value = value.replace("\"" + parser.https() + "\"", "\"" + this.tomeeHttpsPort + "\"");
        }
        if (this.tomeeAjpPort != null) {
            value = value.replace("\"" + parser.ajp() + "\"", "\"" + this.tomeeAjpPort + "\"");
        }
        if (this.tomeeShutdownPort != null) {
            value = value.replace("\"" + parser.stop() + "\"", "\"" + this.tomeeShutdownPort + "\"");
        }
        if (this.webappDir != null) {
            value = value.replace("\"" + parser.value("app-base", "webapps") + "\"", "\"" + this.webappDir + "\"");
        }
        if (this.tomeeHost != null) {
            value = value.replace("\"" + parser.host() + "\"", "\"" + this.tomeeHost + "\"");
        }
        if (!original.equals(value)) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(serverXml);
                writer.write(value);
            }
            catch (IOException e) {
                try {
                    throw new TomEEException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)writer);
        }
    }

    private static String read(File file) {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            StringBuilder sb = new StringBuilder();
            int i = in.read();
            while (i != -1) {
                sb.append((char)i);
                i = in.read();
            }
            string = sb.toString();
        }
        catch (Exception e) {
            try {
                throw new TomEEException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)in);
        return string;
    }

    private Collection<File> overrideConf(File dir, String baseDir) {
        if (!dir.exists()) {
            return Collections.emptyList();
        }
        File[] files = dir.listFiles();
        if (files != null) {
            ArrayList<File> copied = new ArrayList<File>();
            for (File f : files) {
                if (f.isHidden()) continue;
                String file = baseDir + "/" + f.getName();
                File destination = new File(this.catalinaBase, file);
                if (f.isDirectory()) {
                    Files.mkdirs((File)destination);
                    try {
                        IO.copyDirectory((File)f, (File)destination);
                        continue;
                    }
                    catch (IOException e) {
                        throw new TomEEException(e.getMessage(), e);
                    }
                }
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    in = new FileInputStream(f);
                    out = new FileOutputStream(destination);
                    IOUtil.copy((InputStream)in, (OutputStream)out);
                    copied.add(f);
                    this.getLog().info((CharSequence)("Override '" + file + "'"));
                }
                catch (Exception e) {
                    try {
                        throw new TomEEException(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(in);
                        IOUtil.close(out);
                        throw throwable;
                    }
                }
                IOUtil.close((InputStream)in);
                IOUtil.close((OutputStream)out);
            }
            return copied;
        }
        return Collections.emptyList();
    }

    protected void run() {
        if (this.classpaths == null) {
            this.classpaths = new ArrayList<String>();
        }
        this.tomeeHttpPort = AbstractTomEEMojo.getOrInitPort(this.tomeeHttpPort);
        this.tomeeHttpsPort = AbstractTomEEMojo.getOrInitPort(this.tomeeHttpsPort);
        this.tomeeAjpPort = AbstractTomEEMojo.getOrInitPort(this.tomeeAjpPort);
        this.tomeeShutdownPort = AbstractTomEEMojo.getOrInitPort(this.tomeeShutdownPort);
        List<String> strings = this.generateJVMArgs();
        System.setProperty("openejb.home", this.catalinaBase.getAbsolutePath());
        if (this.debug) {
            System.setProperty("openejb.server.debug", "true");
            System.setProperty("server.debug.port", Integer.toString(this.debugPort));
        }
        System.setProperty("server.shutdown.port", String.valueOf(this.tomeeShutdownPort));
        System.setProperty("server.shutdown.command", this.tomeeShutdownCommand);
        Properties override = new Properties();
        override.setProperty("openejb.home", System.getProperty("openejb.home"));
        if (this.debug) {
            override.setProperty("openejb.server.debug", System.getProperty("openejb.server.debug"));
            override.setProperty("server.debug.port", System.getProperty("server.debug.port"));
        }
        override.setProperty("server.shutdown.port", System.getProperty("server.shutdown.port"));
        override.setProperty("server.shutdown.command", System.getProperty("server.shutdown.command"));
        this.server = new RemoteServer(override, this.getConnectAttempts(), this.debug);
        this.server.setAdditionalClasspath(this.getAdditionalClasspath());
        this.addShutdownHooks(this.server);
        if (TOM_EE.equals(this.container)) {
            try {
                this.server.setPortStartup(Integer.parseInt(this.tomeeHttpPort == null ? this.tomeeHttpsPort : this.tomeeHttpPort));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.getLog().info((CharSequence)("Running '" + ((Object)((Object)this)).getClass().getName().replace("TomEEMojo", "").toLowerCase(Locale.ENGLISH) + "'. Configured TomEE in plugin is " + this.tomeeHost + ":" + this.server.getPortStartup() + " (plugin shutdown port is " + this.tomeeShutdownPort + " and https port is " + this.tomeeHttpsPort + ")"));
        } else {
            this.getLog().info((CharSequence)("Running '" + ((Object)((Object)this)).getClass().getSimpleName().replace("TomEEMojo", "").toLowerCase(Locale.ENGLISH)));
        }
        InputStream originalIn = System.in;
        this.serverCmd(this.server, strings);
        if (this.getWaitTomEE()) {
            final CountDownLatch stopCondition = new CountDownLatch(1);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    AbstractTomEEMojo.this.stopServer(stopCondition);
                }
            });
            if (this.useConsole) {
                String line;
                Scanner reader = new Scanner(originalIn);
                System.out.flush();
                this.getLog().info((CharSequence)("Waiting for command: " + String.valueOf(this.availableCommands())));
                while ((line = this.getNextLine(reader)) != null && !AbstractTomEEMojo.isQuit(line)) {
                    if ("ignore".equals(line) || this.handleLine(line.trim())) continue;
                    System.out.flush();
                    this.getLog().warn((CharSequence)("Command '" + line + "' not understood. Use one of " + String.valueOf(this.availableCommands())));
                }
                reader.close();
                this.stopServer(stopCondition);
            }
            try {
                stopCondition.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static String getOrInitPort(String raw) {
        try {
            if (Integer.parseInt(raw) <= 0) {
                return Integer.toString(NetworkUtil.getNextAvailablePort());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return raw;
    }

    private String getNextLine(Scanner reader) {
        try {
            return reader.nextLine();
        }
        catch (NoSuchElementException e) {
            return "ignore";
        }
    }

    protected List<String> generateJVMArgs() {
        boolean deactivateStrictServletCompliance;
        String deployOpenEjbAppKey = "openejb.system.apps";
        String servletCompliance = "org.apache.catalina.STRICT_SERVLET_COMPLIANCE";
        boolean bl = deactivateStrictServletCompliance = this.args == null || !this.args.contains("org.apache.catalina.STRICT_SERVLET_COMPLIANCE");
        if (this.webappDefaultConfig) {
            this.forceDefaultForNiceWebAppDevelopment();
        }
        ArrayList<String> strings = new ArrayList<String>();
        if (this.systemVariables != null) {
            for (Map.Entry<String, String> entry : this.systemVariables.entrySet()) {
                String value;
                String key = entry.getKey();
                if ("org.apache.catalina.STRICT_SERVLET_COMPLIANCE".equals(key)) {
                    deactivateStrictServletCompliance = false;
                }
                if ((value = entry.getValue()) == null) {
                    strings.add("-D" + key);
                } else {
                    strings.add(String.format("-D%s=%s", key, value));
                }
                if (!"openejb.system.apps".equals(key)) continue;
                this.deployOpenEjbApplication = true;
            }
        }
        if (deactivateStrictServletCompliance) {
            strings.add("-Dorg.apache.catalina.STRICT_SERVLET_COMPLIANCE=false");
        }
        if (this.quickSession) {
            strings.add("-Dopenejb.session.manager=org.apache.tomee.catalina.session.QuickSessionManager");
        }
        if (this.removeTomeeWebapp && this.ejbRemote) {
            strings.add("-Dtomee.remote.support=true");
        }
        if (!(this.deployOpenEjbApplication || this.args != null && this.args.contains("-Dopenejb.system.apps"))) {
            strings.add("-Dopenejb.system.apps=false");
        }
        if (this.args != null) {
            strings.addAll(Args.parse(this.args));
        }
        if (this.javaagents != null) {
            this.addJavaagents(strings);
        }
        if (this.forceReloadable) {
            strings.add("-Dtomee.force-reloadable=true");
        }
        if (!this.getWaitTomEE()) {
            strings.add("-Dtomee.noshutdownhook=true");
        }
        String appName = null;
        if (this.docBases != null && !this.docBases.isEmpty()) {
            if ("war".equals(this.packaging)) {
                appName = this.destinationName().replace(".war", "");
                if (appName.startsWith("/")) {
                    appName = appName.substring(1);
                }
                strings.add("-Dtomee." + appName + ".docBases=" + AbstractTomEEMojo.filesToString(this.docBases));
            } else {
                this.getLog().warn((CharSequence)"docBases parameter only valid for a war");
            }
        }
        if (this.externalRepositories != null && !this.externalRepositories.isEmpty()) {
            if ("war".equals(this.packaging)) {
                String string = appName = appName == null ? this.destinationName().replace(".war", "") : appName;
                if (appName.startsWith("/")) {
                    appName = appName.substring(1);
                }
                strings.add("-Dtomee." + appName + ".externalRepositories=" + AbstractTomEEMojo.filesToString(this.externalRepositories));
            } else {
                this.getLog().warn((CharSequence)"externalRepositories parameter only valid for a war");
            }
        }
        if (this.forceJspDevelopment) {
            this.getLog().info((CharSequence)"TomEE will run in development mode");
            strings.add("-Dtomee.jsp-development=true");
        }
        return strings;
    }

    private void addJavaagents(List<String> strings) {
        String existingJavaagent = "\\\"-javaagent:$CATALINA_HOME/lib/openejb-javaagent.jar\\\"";
        StringBuilder javaagentString = new StringBuilder("\\\"-javaagent:$CATALINA_HOME/lib/openejb-javaagent.jar\\\"");
        for (String rawJavaagent : this.javaagents) {
            String args;
            String javaagent;
            int argsIdx = rawJavaagent.indexOf(61);
            if (argsIdx < 0) {
                argsIdx = rawJavaagent.indexOf(63);
            }
            if (argsIdx > 0) {
                javaagent = rawJavaagent.substring(0, argsIdx);
                args = rawJavaagent.substring(argsIdx);
            } else {
                javaagent = rawJavaagent;
                args = "";
            }
            Object path = javaagent;
            if (!new File(javaagent).isFile()) {
                try {
                    FileWithMavenMeta jar = this.mvnToFile(javaagent, "jar");
                    if (this.persistJavaagents) {
                        File javaagentFolder = new File(this.catalinaBase, "javaagent");
                        Files.mkdirs((File)javaagentFolder);
                        String name = jar.resolved.getName();
                        if (this.stripVersion) {
                            name = jar.stripVersion(true);
                        }
                        path = "$CATALINA_HOME/javaagent/" + name;
                        IO.copy((File)jar.resolved, (File)new File(javaagentFolder, name));
                    }
                    strings.add("-javaagent:" + jar.resolved.getAbsolutePath() + args);
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Can't find " + javaagent));
                    strings.add("-javaagent:" + javaagent + args);
                }
            } else {
                strings.add("-javaagent:" + javaagent + args);
            }
            if (!this.persistJavaagents) continue;
            javaagentString.append(" -javaagent:").append((String)path).append(args);
        }
        if (this.persistJavaagents) {
            try {
                File catalinaSh = new File(this.catalinaBase, "bin/catalina.sh");
                String content = IO.slurp((File)catalinaSh).replace("\\\"-javaagent:$CATALINA_HOME/lib/openejb-javaagent.jar\\\"", javaagentString.toString());
                AbstractTomEEMojo.doWrite(catalinaSh, content);
                File catalinaBat = new File(this.catalinaBase, "bin/catalina.bat");
                content = IO.slurp((File)catalinaBat).replace("\"-javaagent:%CATALINA_HOME%\\lib\\openejb-javaagent.jar\"", javaagentString.toString().replace('\'', '\"').replace('/', '\\').replace("$CATALINA_HOME", "%CATALINA_HOME%"));
                AbstractTomEEMojo.doWrite(catalinaBat, content);
            }
            catch (IOException ioe) {
                throw new OpenEJBRuntimeException((Exception)ioe);
            }
        }
    }

    private void forceDefaultForNiceWebAppDevelopment() {
        if (!this.deployOpenEjbApplication) {
            this.getLog().info((CharSequence)"Forcing deployOpenEjbApplication=true to be able to type 'reload[ENTER]' when classes are updated");
            this.deployOpenEjbApplication = true;
        }
        if (!this.forceReloadable) {
            this.getLog().info((CharSequence)"Forcing forceReloadable=true to be able to type 'reload[ENTER]' when classes are updated");
            this.forceReloadable = true;
        }
        if (this.docBases == null) {
            this.docBases = new ArrayList<File>();
        }
        if (this.docBases.isEmpty() && this.webappResources.exists()) {
            this.getLog().info((CharSequence)("adding " + this.webappResources.toString() + " docBase"));
            this.docBases.add(this.webappResources);
        }
        if (this.externalRepositories == null) {
            this.externalRepositories = new ArrayList<File>();
        }
        if (this.externalRepositories.isEmpty() && this.webappClasses.exists()) {
            this.getLog().info((CharSequence)("adding " + this.webappClasses.toString() + " externalRepository"));
            this.externalRepositories.add(this.webappClasses);
        }
        if (this.systemVariables == null) {
            this.systemVariables = new HashMap<String, String>();
        }
        if (!this.systemVariables.containsKey("openejb.classloader.resources.deeper-first")) {
            this.systemVariables.put("openejb.classloader.force-maven", "true");
        }
    }

    private static String filesToString(Collection<File> files) {
        ArrayList<String> paths = new ArrayList<String>(files.size());
        for (File path : files) {
            paths.add(path.getAbsolutePath());
        }
        return Join.join((String)",", paths);
    }

    protected Collection<String> availableCommands() {
        return Arrays.asList(QUIT_CMD, EXIT_CMD);
    }

    protected synchronized void stopServer(CountDownLatch stopCondition) {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.server.getServer().waitFor();
            this.getLog().info((CharSequence)(this.container + " stopped"));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Can't stop " + this.container), (Throwable)e);
        }
        this.server = null;
        stopCondition.countDown();
    }

    private static boolean isQuit(String line) {
        if (QUIT_CMD.equalsIgnoreCase(line) || EXIT_CMD.equalsIgnoreCase(line)) {
            return true;
        }
        return QUIT_CMD.equalsIgnoreCase(line = new StringBuilder(line).reverse().toString()) || EXIT_CMD.equalsIgnoreCase(line);
    }

    protected boolean handleLine(String line) {
        return false;
    }

    protected void serverCmd(RemoteServer server, List<String> strings) {
        try {
            server.start(strings, this.getCmd(), this.checkStarted);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Failed to check or track server startup on port: " + this.tomeeHttpPort));
        }
    }

    protected void addShutdownHooks(RemoteServer server) {
    }

    protected int getConnectAttempts() {
        return this.tomeeShutdownAttempts == 0 ? 60 : this.tomeeShutdownAttempts;
    }

    protected boolean getWaitTomEE() {
        return true;
    }

    private File resolve() {
        block11: {
            if (!this.settings.isOffline()) {
                try {
                    if ("snapshots".equals(this.apacheRepos) || "true".equals(this.apacheRepos)) {
                        this.remoteRepos.add((ArtifactRepository)new DefaultArtifactRepository("apache", "https://repository.apache.org/content/repositories/snapshots/", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(true, "daily", "warn"), new ArtifactRepositoryPolicy(false, "never", "warn")));
                        break block11;
                    }
                    try {
                        new URI(this.apacheRepos);
                        this.remoteRepos.add((ArtifactRepository)new DefaultArtifactRepository("additional-repo-tomee-mvn-plugin", this.apacheRepos, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(true, "daily", "warn"), new ArtifactRepositoryPolicy(true, "never", "warn")));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            } else if (this.remoteRepos != null && this.remoteRepos.isEmpty()) {
                this.remoteRepos = new ArrayList<ArtifactRepository>();
            }
        }
        if (this.tomeeClassifier != null && (this.tomeeClassifier.isEmpty() || this.tomeeClassifier.equals("ignore")) || "org.apache.tomee".equals(this.tomeeGroupId) && "openejb-standalone".equals(this.tomeeArtifactId)) {
            this.tomeeClassifier = null;
        }
        try {
            Artifact artifact = this.factory.createDependencyArtifact(this.tomeeGroupId, this.tomeeArtifactId, VersionRange.createFromVersion((String)this.tomeeVersion), this.tomeeType, this.tomeeClassifier, "compile");
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
            return artifact.getFile();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new TomEEException(e.getMessage(), e);
        }
    }

    private void unzip(File mvnTomEE) {
        ZipFile in = null;
        try {
            in = new ZipFile(mvnTomEE);
            Enumeration<? extends ZipEntry> entries = in.entries();
            while (entries.hasMoreElements()) {
                File dest;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (this.skipRootFolderOnUnzip) {
                    int idx = name.indexOf("/");
                    if (idx < 0) {
                        idx = name.indexOf(File.separator);
                    }
                    if (idx < 0) continue;
                    name = name.substring(idx + 1);
                }
                if (!(dest = new File(this.catalinaBase.getAbsolutePath(), name)).exists()) {
                    File parent = dest.getParentFile();
                    if (!parent.exists() && !parent.mkdirs() || !parent.canWrite() && !parent.setWritable(true) || !parent.canRead() && !parent.setReadable(true)) {
                        throw new RuntimeException("Failed to create or set permissions on: " + String.valueOf(parent));
                    }
                } else if (!this.overrideOnUnzip) continue;
                if (entry.isDirectory()) {
                    if (dest.exists() || dest.mkdir()) continue;
                    throw new RuntimeException("Failed to create: " + String.valueOf(dest));
                }
                FileOutputStream fos = new FileOutputStream(dest);
                try {
                    IOUtil.copy((InputStream)in.getInputStream(entry), (OutputStream)fos);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                IOUtil.close((OutputStream)fos);
                if (!dest.canRead() && !dest.setReadable(true)) {
                    throw new RuntimeException("Failed to set readable on: " + String.valueOf(dest));
                }
                if (!dest.getName().endsWith(".sh") || dest.canExecute() || dest.setExecutable(true)) continue;
                throw new RuntimeException("Failed to set executable on: " + String.valueOf(dest));
            }
            File file = new File(this.catalinaBase, "conf/tomee.xml");
            if (file.exists()) {
                this.container = TOM_EE;
            } else {
                this.container = "OpenEJB";
                file = new File(this.catalinaBase, "conf/openejb.xml");
                if (file.exists()) {
                    this.webappDir = "apps";
                }
            }
            this.ensureAppsFolderExistAndIsConfiguredByDefault(file);
            this.getLog().info((CharSequence)(this.container + " was unzipped in '" + this.catalinaBase.getAbsolutePath() + "'"));
        }
        catch (Exception e) {
            throw new TomEEException(e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void ensureAppsFolderExistAndIsConfiguredByDefault(File file) throws IOException {
        if ("openejb".equals(this.container.toLowerCase(Locale.ENGLISH)) || file.exists() && (this.apps != null && !this.apps.isEmpty() || !"pom".equals(this.packaging) && !"war".equals(this.packaging))) {
            rootTag = this.container.toLowerCase(Locale.ENGLISH);
            if (file.isFile()) {
                try {
                    jaxb = JaxbOpenejb.readConfig((String)file.getAbsolutePath());
                    needAdd = true;
                    for (Deployments d : jaxb.getDeployments()) {
                        if (!"apps".equals(d.getDir())) continue;
                        needAdd = false;
                        break;
                    }
                    if (!needAdd) ** GOTO lbl23
                    content = IO.slurp((File)file);
                    writer = new FileWriter(file);
                    end = "</" + rootTag + ">";
                    writer.write(content.replace(end, "  <Deployments dir=\"apps\" />\n" + end));
                    writer.close();
                }
                catch (OpenEJBException e) {
                    throw new IllegalStateException("illegal tomee.xml:\n" + IO.slurp((File)file), e);
                }
            } else {
                writer = new FileWriter(file);
                writer.write("<?xml version=\"1.0\"?>\n<" + rootTag + ">\n  <Deployments dir=\"apps\" />\n</" + rootTag + ">\n");
                writer.close();
            }
lbl23:
            // 3 sources

            appsFolder = new File(this.catalinaBase, "apps");
            if (!appsFolder.exists() && !appsFolder.mkdirs()) {
                throw new RuntimeException("Failed to create: " + String.valueOf(appsFolder));
            }
        }
    }

    private static void doWrite(File file, String content) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(content);
        }
        finally {
            IO.close((Closeable)writer);
        }
    }

    public abstract String getCmd();

    private static class FileWithMavenMeta {
        private final String group;
        private final String artifact;
        private final String version;
        private final String classifier;
        private final String type;
        private final File resolved;

        private FileWithMavenMeta(String group, String artifact, String version, String classifier, String type, File resolved) {
            this.group = group;
            this.artifact = artifact;
            this.version = version;
            this.classifier = classifier;
            this.type = type;
            this.resolved = resolved;
        }

        String stripVersion(boolean keepExtension) {
            return this.artifact + (String)(this.classifier != null && !this.classifier.isEmpty() ? "-" + this.classifier : "") + (String)(keepExtension ? "." + this.type : "");
        }
    }

    public static interface Resolver {
        public File resolve(String var1, String var2, String var3, String var4, String var5);

        public File resolve(String var1, String var2, String var3, String var4);

        public File resolve(String var1, String var2, String var3);
    }
}

