/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin.customizer.monkey.classloader;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class ClassLoaderFactory {
    public ClassLoader create(File libFolder) {
        ArrayList<URL> urls = new ArrayList<URL>();
        File[] children = libFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        if (children == null) {
            throw new IllegalArgumentException("No library found in " + String.valueOf(libFolder));
        }
        for (File c : children) {
            try {
                urls.add(c.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), new ClassLoader(){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.startsWith("java.")) {
                    return 2.getSystemClassLoader().loadClass(name);
                }
                throw new ClassNotFoundException(name);
            }

            @Override
            public URL getResource(String name) {
                return null;
            }
        });
    }

    public void release(ClassLoader loader) {
        if (Closeable.class.isInstance(loader)) {
            try {
                ((Closeable)Closeable.class.cast(loader)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

