/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.applicationcomposer.mojo;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.openejb.applicationcomposer.mojo.ApplicationComposerMojo;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.testing.ApplicationComposers;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ApplicationComposerRunMojo
extends ApplicationComposerMojo {
    @Parameter
    private String[] args;
    @Parameter
    private String[] acceptScopes;
    @Parameter
    private String[] excludedArtifacts;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.application == null) {
            this.getLog().error((CharSequence)"You should specify <application>org.superbiz.MyApp</application>");
            return;
        }
        this.setupLogs();
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        Collection<URL> depUrls = this.findDeps();
        if (!depUrls.isEmpty()) {
            try {
                URLClassLoader loader = new URLClassLoader(new URL[]{this.binaries.toURI().toURL()}, old);
                ApplicationComposerMojo.LazyClassLoaderFinder.loader = loader;
                thread.setContextClassLoader(loader);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            ApplicationComposerMojo.LazyClassLoaderFinder.loader = old;
        }
        System.setProperty(ParentClassLoaderFinder.class.getName(), ApplicationComposerMojo.LazyClassLoaderFinder.class.getName());
        try {
            ApplicationComposers.run(thread.getContextClassLoader().loadClass(this.application), (String[])this.args);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    private Collection<URL> findDeps() {
        ArrayList<URL> urls = new ArrayList<URL>();
        List<String> passingScoped = this.acceptScopes == null ? Arrays.asList("compile", "runtime") : Arrays.asList(this.acceptScopes);
        List excludedAnyway = this.excludedArtifacts == null ? Collections.emptyList() : Arrays.asList(this.excludedArtifacts);
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!passingScoped.contains(artifact.getScope()) || excludedAnyway.contains(artifact.getGroupId() + ":" + artifact.getArtifactId())) continue;
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)("can't use artifact " + artifact.toString()));
            }
        }
        if (this.binaries.exists()) {
            try {
                urls.add(this.binaries.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)("can't use artifact " + this.binaries.getAbsolutePath()));
            }
        }
        return urls;
    }
}

