/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.itest.util;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.tomee.itest.util.Duration;
import org.apache.tomee.itest.util.Timer;
import org.junit.Assert;

public class Runner {
    private final int threads;
    private final Executor executor;
    private final Duration timeout = new Duration(1L, TimeUnit.MINUTES);
    private Runnable before = null;

    public Runner(int threads) {
        this.threads = threads;
        this.executor = Executors.newFixedThreadPool(threads, new DaemonThreadFactory(Runner.class));
    }

    public static Runner threads(int threads) {
        return new Runner(threads);
    }

    public Runner pre(Runnable runnable) {
        this.before = runnable;
        return this;
    }

    public Run run(final Runnable runnable) {
        final Throwable[] failures = new Throwable[this.threads];
        final Timer.Time[] times = new Timer.Time[this.threads];
        final CountDownLatch ready = new CountDownLatch(this.threads);
        final CountDownLatch start = new CountDownLatch(1);
        final CountDownLatch completed = new CountDownLatch(this.threads);
        int submitted = 0;
        while (submitted < this.threads) {
            final int id = submitted++;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ready.countDown();
                    try {
                        start.await();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    if (Runner.this.before != null) {
                        Runner.this.before.run();
                    }
                    Timer timer = Timer.start();
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        failures[id] = t;
                    }
                    finally {
                        times[id] = timer.time();
                        completed.countDown();
                    }
                }
            });
        }
        this.await(ready, "ready");
        start.countDown();
        this.await(completed, "completed");
        return new Run(this.threads, failures, times);
    }

    private void await(CountDownLatch latch, String state) {
        try {
            if (!latch.await(this.timeout.getTime(), this.timeout.getUnit())) {
                Assert.fail((String)String.format("%s of %s threads not %s after %s", state, (long)this.threads - latch.getCount(), this.threads, this.timeout));
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)String.format("Interrupted while waiting %s state", "ready"));
        }
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        private final Class<?> aClass;

        public DaemonThreadFactory(Class<?> aClass) {
            this.aClass = aClass;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName(this.aClass.getSimpleName());
            return thread;
        }
    }

    public static class Run {
        final int threads;
        final Throwable[] exceptions;
        final Timer.Time[] times;

        public Run(int threads, Throwable[] exceptions, Timer.Time[] times) {
            this.threads = threads;
            this.exceptions = exceptions;
            this.times = times;
        }

        public Run assertNoExceptions() {
            long failed = Stream.of(this.exceptions).filter(Objects::nonNull).peek(Throwable::printStackTrace).count();
            if (failed > 0L) {
                long succeeded = (long)this.threads - failed;
                Assert.fail((String)String.format("Succeeded: %s, Failed: %s", succeeded, failed));
            }
            return this;
        }

        public Run assertExceptions(Class<? extends Throwable> expected) {
            for (Throwable actual : this.exceptions) {
                Assert.assertNotNull((Object)actual);
                try {
                    Assert.assertEquals(expected, actual.getClass());
                }
                catch (AssertionError e) {
                    actual.printStackTrace();
                    throw e;
                }
            }
            return this;
        }

        public Run assertTimesLessThan(long time, TimeUnit unit) {
            for (Timer.Time t : this.times) {
                t.assertLessThan(time, unit);
            }
            return this;
        }

        public Run assertTimesGreaterThan(long time, TimeUnit unit) {
            for (Timer.Time t : this.times) {
                t.assertGreaterThan(time, unit);
            }
            return this;
        }
    }
}

