/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.gradle.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tomee.gradle.embedded.TomEEEmbeddedExtension;
import org.apache.tomee.gradle.embedded.TomEEEmbeddedTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class TomEEEmbeddedPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        final List<String> extensions = Arrays.asList("tomee-embedded", "tomeeembedded");
        for (String name : extensions) {
            project.getExtensions().create(name, TomEEEmbeddedExtension.class, new Object[0]);
        }
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project actionProject) {
                for (String name : extensions) {
                    TomEEEmbeddedExtension extension = (TomEEEmbeddedExtension)TomEEEmbeddedExtension.class.cast(actionProject.getExtensions().findByName(name));
                    if (extension == null) {
                        return;
                    }
                    if (extension.isSkipDefaultRepository() == null || extension.isSkipDefaultRepository().booleanValue()) continue;
                    actionProject.getRepositories().mavenCentral();
                    return;
                }
                actionProject.getRepositories().mavenCentral();
            }
        });
        String configName = "tomeeembedded";
        try {
            project.getConfigurations().getByName(configName);
        }
        catch (UnknownConfigurationException uce) {
            configName = "tomee-embedded";
        }
        final Configuration configuration = (Configuration)project.getConfigurations().maybeCreate(configName);
        configuration.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(){

            public void execute(ResolvableDependencies resolvableDependencies) {
                String tomeeVersion = null;
                for (String name : extensions) {
                    TomEEEmbeddedExtension extension = (TomEEEmbeddedExtension)TomEEEmbeddedExtension.class.cast(project.getExtensions().findByName(name));
                    if (extension == null) {
                        return;
                    }
                    tomeeVersion = extension.getTomeeVersion();
                    if (tomeeVersion == null) continue;
                    break;
                }
                if (tomeeVersion == null) {
                    try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/maven/org.apache.tomee.gradle/tomee-embedded/pom.properties");){
                        Properties p = new Properties();
                        p.load(is);
                        tomeeVersion = p.getProperty("version");
                    }
                    catch (IOException e) {
                        tomeeVersion = "7.0.2";
                    }
                }
                DependencyHandler dependencyHandler = project.getDependencies();
                DependencySet dependencies = configuration.getDependencies();
                dependencies.add((Object)dependencyHandler.create((Object)("org.apache.tomee:tomee-embedded:" + tomeeVersion)));
            }
        });
        project.task((Map)new HashMap<String, Object>(){
            {
                this.put("type", TomEEEmbeddedTask.class);
                this.put("group", "Embedded Application Server");
                this.put("description", "Start an embedded Apache TomEE server deploying application classpath");
            }
        }, "tomee-embedded");
    }
}

