/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.QName;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.spring.AbstractSpringComponentScanServer;
import org.apache.cxf.jaxrs.spring.SpringResourceFactory;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class JAXRSServerFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSServerFactoryBeanDefinitionParser.class);

    public JAXRSServerFactoryBeanDefinitionParser() {
        this.setBeanClass(SpringJAXRSServerFactoryBean.class);
    }

    @Override
    protected void mapAttribute(BeanDefinitionBuilder bean, Element e, String name, String val) {
        if ("beanNames".equals(name)) {
            String[] values = val.split(" ");
            ArrayList<SpringResourceFactory> tempFactories = new ArrayList<SpringResourceFactory>(values.length);
            for (String v : values) {
                String theValue = v.trim();
                if (theValue.length() <= 0) continue;
                tempFactories.add(new SpringResourceFactory(theValue));
            }
            bean.addPropertyValue("tempResourceProviders", tempFactories);
        } else if ("serviceName".equals(name)) {
            QName q = this.parseQName(e, val);
            bean.addPropertyValue(name, (Object)q);
        } else if ("basePackages".equals(name)) {
            bean.addPropertyValue("basePackages", ClasspathScanner.parsePackages(val));
        } else if ("serviceAnnotation".equals(name)) {
            bean.addPropertyValue("serviceAnnotation", (Object)val);
        } else if ("publish".equals(name)) {
            this.mapToProperty(bean, "start", val);
        } else {
            this.mapToProperty(bean, name, val);
        }
    }

    @Override
    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element el, String name) {
        if ("properties".equals(name) || "extensionMappings".equals(name) || "languageMappings".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)map);
        } else if ("executor".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.executor");
        } else if ("invoker".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.invoker");
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("features".equals(name) || "schemaLocations".equals(name) || "providers".equals(name) || "serviceBeans".equals(name) || "modelBeans".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("serviceFactories".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue("resourceProviders", (Object)list);
        } else if ("model".equals(name)) {
            List<UserResource> resources = ResourceUtils.getResourcesFromElement(el);
            bean.addPropertyValue("modelBeans", resources);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }

    @Override
    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        super.doParse(element, ctx, bean);
        bean.setInitMethodName("create");
        bean.setDestroyMethodName("destroy");
        bean.setLazyInit(false);
    }

    @Override
    protected String resolveId(Element elem, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id = super.resolveId(elem, definition, ctx);
        if (StringUtils.isEmpty(id)) {
            id = this.getBeanClass().getName() + "--" + definition.hashCode();
        }
        return id;
    }

    @Override
    protected boolean hasBusProperty() {
        return true;
    }

    static List<Object> createBeansFromDiscoveredClasses(ApplicationContext context, Collection<Class<?>> classes, Class<? extends Annotation> serviceClassAnnotation) {
        AutowireCapableBeanFactory beanFactory = context.getAutowireCapableBeanFactory();
        ArrayList<Object> providers = new ArrayList<Object>();
        for (Class<?> clazz : classes) {
            Object bean;
            if (serviceClassAnnotation != null && clazz.getAnnotation(serviceClassAnnotation) == null) continue;
            try {
                bean = beanFactory.createBean(clazz, 2, true);
            }
            catch (Exception ex) {
                String stackTrace = ExceptionUtils.getStackTrace(ex);
                LOG.fine("Autowire failure for a " + clazz.getName() + " bean: " + stackTrace);
                bean = beanFactory.createBean(clazz);
            }
            providers.add(bean);
        }
        return providers;
    }

    public static class SpringJAXRSServerFactoryBean
    extends JAXRSServerFactoryBean
    implements ApplicationContextAware {
        private List<SpringResourceFactory> tempFactories;
        private List<String> basePackages;
        private String serviceAnnotation;
        private ApplicationContext context;
        private boolean serviceBeansAvailable;
        private boolean providerBeansAvailable;
        private boolean resourceProvidersAvailable;

        public SpringJAXRSServerFactoryBean() {
        }

        public SpringJAXRSServerFactoryBean(JAXRSServiceFactoryBean sf) {
            super(sf);
        }

        public void destroy() {
            Server server = super.getServer();
            if (server != null && server.isStarted()) {
                server.destroy();
            }
        }

        @Override
        public void setServiceBeans(List<Object> beans) {
            super.setServiceBeans(beans);
            this.serviceBeansAvailable = true;
        }

        @Override
        public void setProviders(List<? extends Object> beans) {
            super.setProviders(beans);
            this.providerBeansAvailable = true;
        }

        @Override
        public void setResourceProviders(List<ResourceProvider> rps) {
            super.setResourceProviders(rps);
            this.resourceProvidersAvailable = true;
        }

        public void setBasePackages(List<String> basePackages) {
            this.basePackages = basePackages;
        }

        public void setServiceAnnotation(String serviceAnnotation) {
            this.serviceAnnotation = serviceAnnotation;
        }

        public void setTempResourceProviders(List<SpringResourceFactory> providers) {
            this.tempFactories = providers;
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            this.context = ctx;
            if (this.tempFactories != null) {
                ArrayList<ResourceProvider> factories = new ArrayList<ResourceProvider>(this.tempFactories.size());
                for (int i = 0; i < this.tempFactories.size(); ++i) {
                    SpringResourceFactory factory = this.tempFactories.get(i);
                    factory.setApplicationContext(ctx);
                    factories.add(factory);
                }
                this.tempFactories.clear();
                this.setResourceProviders(factories);
            }
            Class<? extends Annotation> serviceAnnotationClass = this.loadServiceAnnotationClass();
            if (this.basePackages != null) {
                try {
                    Map<Class<Annotation>, Collection<Class<?>>> classes = ClasspathScanner.findClasses(this.basePackages, Provider.class, Path.class);
                    this.setServiceBeans(JAXRSServerFactoryBeanDefinitionParser.createBeansFromDiscoveredClasses(this.context, classes.get(Path.class), serviceAnnotationClass));
                    this.setProviders(JAXRSServerFactoryBeanDefinitionParser.createBeansFromDiscoveredClasses(this.context, classes.get(Provider.class), serviceAnnotationClass));
                }
                catch (IOException ex) {
                    throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new BeanCreationException("Failed to create bean from classfile", (Throwable)ex);
                }
            } else if (!(serviceAnnotationClass == null || this.serviceBeansAvailable || this.providerBeansAvailable || this.resourceProvidersAvailable)) {
                this.discoverContextResources(serviceAnnotationClass);
            }
            if (this.bus == null) {
                this.setBus(BusWiringBeanFactoryPostProcessor.addDefaultBus(ctx));
            }
        }

        private void discoverContextResources(Class<? extends Annotation> serviceAnnotationClass) {
            AbstractSpringComponentScanServer scanServer = new AbstractSpringComponentScanServer(serviceAnnotationClass){};
            scanServer.setApplicationContext(this.context);
            scanServer.setJaxrsResources(this);
        }

        private Class<? extends Annotation> loadServiceAnnotationClass() {
            if (this.serviceAnnotation != null) {
                try {
                    return ClassLoaderUtils.loadClass(this.serviceAnnotation, this.getClass());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return null;
        }
    }
}

