/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;

public class LocalClientState
implements ClientState {
    private static final String HTTP_SCHEME = "http";
    private static final String WS_SCHEME = "ws";
    private MultivaluedMap<String, String> requestHeaders = new MetadataMap<String, String>(false, true);
    private MultivaluedMap<String, String> templates;
    private Response response;
    private URI baseURI;
    private UriBuilder currentBuilder;
    private Map<String, Object> properties;

    public LocalClientState() {
    }

    public LocalClientState(URI baseURI) {
        this(baseURI, Collections.emptyMap());
    }

    public LocalClientState(URI baseURI, Map<String, Object> properties) {
        this.baseURI = baseURI;
        if (properties != null) {
            this.properties = new HashMap<String, Object>(properties);
        }
        this.resetCurrentUri(properties);
    }

    public LocalClientState(URI baseURI, URI currentURI) {
        this(baseURI, currentURI, Collections.emptyMap());
    }

    public LocalClientState(URI baseURI, URI currentURI, Map<String, Object> properties) {
        this.baseURI = baseURI;
        if (properties != null) {
            this.properties = new HashMap<String, Object>(properties);
        }
        this.currentBuilder = new UriBuilderImpl(properties).uri(currentURI);
    }

    public LocalClientState(LocalClientState cs) {
        this.requestHeaders = new MetadataMap<String, String>((Map<String, List<String>>)cs.requestHeaders);
        this.templates = cs.templates == null ? null : new MetadataMap(cs.templates);
        this.response = cs.response;
        this.baseURI = cs.baseURI;
        this.currentBuilder = cs.currentBuilder != null ? cs.currentBuilder.clone() : null;
        this.properties = cs.properties;
    }

    private void resetCurrentUri(Map<String, Object> props) {
        this.currentBuilder = LocalClientState.isSupportedScheme(this.baseURI) ? new UriBuilderImpl(props).uri(this.baseURI) : new UriBuilderImpl(props).uri("/");
    }

    @Override
    public void setCurrentBuilder(UriBuilder currentBuilder) {
        this.currentBuilder = currentBuilder;
    }

    @Override
    public UriBuilder getCurrentBuilder() {
        return this.currentBuilder;
    }

    @Override
    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
        this.resetCurrentUri(Collections.emptyMap());
    }

    @Override
    public URI getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setResponse(Response r) {
        this.response = r;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public void setRequestHeaders(MultivaluedMap<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public MultivaluedMap<String, String> getTemplates() {
        return this.templates;
    }

    @Override
    public void setTemplates(MultivaluedMap<String, String> map) {
        if (this.templates == null) {
            this.templates = map;
        } else if (map != null) {
            this.templates.putAll(map);
        } else {
            this.templates = null;
        }
    }

    @Override
    public void reset() {
        this.requestHeaders.clear();
        this.response = null;
        this.currentBuilder = new UriBuilderImpl(this.properties).uri(this.baseURI);
        this.templates = null;
    }

    @Override
    public ClientState newState(URI currentURI, MultivaluedMap<String, String> headers, MultivaluedMap<String, String> templatesMap, Map<String, Object> props) {
        MultivaluedMap<String, String> newTemplateParams;
        LocalClientState state = LocalClientState.isSupportedScheme(currentURI) ? new LocalClientState(currentURI, props) : new LocalClientState(this.baseURI, currentURI, props);
        if (headers != null) {
            state.setRequestHeaders(headers);
        }
        if ((newTemplateParams = this.templates) != null && templatesMap != null) {
            newTemplateParams.putAll(templatesMap);
        } else {
            newTemplateParams = templatesMap;
        }
        state.setTemplates(newTemplateParams);
        return state;
    }

    @Override
    public ClientState newState(URI currentURI, MultivaluedMap<String, String> headers, MultivaluedMap<String, String> templatesMap) {
        return this.newState(currentURI, headers, templatesMap, this.properties);
    }

    private static boolean isSupportedScheme(URI uri) {
        return !StringUtils.isEmpty(uri.getScheme()) && (uri.getScheme().startsWith(HTTP_SCHEME) || uri.getScheme().startsWith(WS_SCHEME));
    }
}

