/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.jaxrs.provider.AbstractCachingMessageProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;

@Provider
public class CachingMessageBodyWriter<T>
extends AbstractCachingMessageProvider<T>
implements MessageBodyWriter<T> {
    private List<MessageBodyWriter<T>> delegatingWriters;

    public long getSize(T t, Class<?> type, Type gType, Annotation[] anns, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type gType, Annotation[] anns, MediaType mt) {
        if (this.delegatingWriters != null) {
            return this.getDelegatingWriter(type, gType, anns, mt) != null;
        }
        return this.isProviderKeyNotSet();
    }

    private MessageBodyWriter<T> getDelegatingWriter(Class<?> type, Type gType, Annotation[] anns, MediaType mt) {
        for (MessageBodyWriter<T> writer : this.delegatingWriters) {
            if (!writer.isWriteable(type, gType, anns, mt)) continue;
            return writer;
        }
        return null;
    }

    public void writeTo(T obj, Class<?> type, Type gType, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> theheaders, OutputStream os) throws IOException, WebApplicationException {
        this.setObject(obj);
        this.getWriter(type, gType, anns, mt).writeTo(this.getObject(), type, gType, anns, mt, theheaders, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageBodyWriter<T> getWriter(Class<?> type, Type gType, Annotation[] anns, MediaType mt) {
        MessageBodyWriter w;
        if (this.delegatingWriters != null) {
            return this.getDelegatingWriter(type, gType, anns, mt);
        }
        this.mc.put("active.jaxrs.provider", this);
        try {
            Class<?> actualType = type;
            w = this.mc.getProviders().getMessageBodyWriter(actualType, gType, anns, mt);
        }
        finally {
            this.mc.put("active.jaxrs.provider", null);
        }
        if (w == null) {
            Message message = new Message("NO_MSG_WRITER", BUNDLE, type);
            LOG.severe(message.toString());
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        return w;
    }

    public void setDelegatingWriter(MessageBodyWriter<T> writer) {
        this.delegatingWriters = Collections.singletonList(writer);
    }

    public void setDelegatingWriters(List<MessageBodyWriter<T>> writers) {
        this.delegatingWriters = writers;
    }
}

