/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.webapp;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.application.Application;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.webapp.UIComponentClassicTagBase;
import jakarta.servlet.jsp.JspException;

public abstract class UIComponentELTag
extends UIComponentClassicTagBase {
    private ValueExpression _binding = null;
    private ValueExpression _rendered = null;

    @Override
    protected ELContext getELContext() {
        FacesContext facesContext = this.getFacesContext();
        ELContext elContext = null;
        if (facesContext != null) {
            elContext = facesContext.getELContext();
        }
        return elContext;
    }

    @Override
    public void release() {
        super.release();
        this._binding = null;
        this._rendered = null;
    }

    @Override
    protected void setProperties(UIComponent component) {
        if (this.getRendererType() != null) {
            component.setRendererType(this.getRendererType());
        }
        if (this._rendered != null) {
            if (this._rendered.isLiteralText()) {
                boolean b = Boolean.valueOf(this._rendered.getExpressionString());
                component.setRendered(b);
            } else {
                component.setValueExpression("rendered", this._rendered);
            }
        }
    }

    @Override
    protected UIComponent createComponent(FacesContext context, String newId) throws JspException {
        UIComponent component;
        Application application = context.getApplication();
        if (this._binding != null) {
            component = application.createComponent(this._binding, context, this.getComponentType());
            component.setValueExpression("binding", this._binding);
        } else {
            component = application.createComponent(this.getComponentType());
        }
        component.setId(newId);
        this.setProperties(component);
        return component;
    }

    public void setBinding(ValueExpression binding) throws JspException {
        this._binding = binding;
    }

    @Override
    protected boolean hasBinding() {
        return this._binding != null;
    }

    public void setRendered(ValueExpression rendered) {
        this._rendered = rendered;
    }
}

