/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonPatch;
import jakarta.json.JsonPointer;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

class JsonPatchImpl
implements JsonPatch {
    private final JsonProvider provider;
    private final List<PatchValue> patches;
    private volatile JsonArray json;

    JsonPatchImpl(JsonProvider provider, PatchValue ... patches) {
        this(provider, Arrays.asList(patches));
    }

    JsonPatchImpl(JsonProvider provider, List<PatchValue> patches) {
        this.provider = provider;
        this.patches = patches == null ? Collections.emptyList() : Collections.unmodifiableList(patches);
    }

    public <T extends JsonStructure> T apply(T target) {
        Object patched = target;
        block8: for (PatchValue patch : this.patches) {
            switch (patch.operation) {
                case ADD: {
                    patched = patch.pathPointer.add(patched, patch.value);
                    continue block8;
                }
                case REMOVE: {
                    patched = patch.pathPointer.remove(patched);
                    continue block8;
                }
                case REPLACE: {
                    patched = patch.pathPointer.add(patch.pathPointer.remove(patched), patch.value);
                    continue block8;
                }
                case MOVE: {
                    JsonValue valueToMove = patch.fromPointer.getValue(patched);
                    patched = patch.pathPointer.add(patch.fromPointer.remove(patched), valueToMove);
                    continue block8;
                }
                case COPY: {
                    JsonValue toCopy = patch.fromPointer.getValue(patched);
                    patched = patch.pathPointer.add(patched, toCopy);
                    continue block8;
                }
                case TEST: {
                    JsonValue toTest = patch.pathPointer.getValue(patched);
                    if (toTest.equals(patch.value)) continue block8;
                    throw new JsonException("JsonPatch.Operation.TEST fails! Values are not equal");
                }
            }
            throw new IllegalStateException("unsupported operation: " + patch.operation);
        }
        return patched;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPatchImpl jsonPatch = (JsonPatchImpl)o;
        return this.patches.equals(jsonPatch.patches);
    }

    public int hashCode() {
        return this.patches.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonArray toJsonArray() {
        if (this.patches.isEmpty()) {
            return JsonValue.EMPTY_JSON_ARRAY;
        }
        if (this.json == null) {
            JsonPatchImpl jsonPatchImpl = this;
            synchronized (jsonPatchImpl) {
                if (this.json == null) {
                    JsonArrayBuilder builder = this.provider.createArrayBuilder();
                    for (PatchValue patch : this.patches) {
                        builder.add((JsonValue)patch.toJson());
                    }
                    this.json = builder.build();
                }
            }
        }
        return this.json;
    }

    public String toString() {
        if (this.patches.isEmpty()) {
            return "[]";
        }
        return this.toJsonArray().toString();
    }

    static class PatchValue {
        private final JsonProvider provider;
        private final JsonPatch.Operation operation;
        private String path;
        private String from;
        private final JsonPointer pathPointer;
        private final JsonPointer fromPointer;
        private final JsonValue value;
        private volatile String str;
        private volatile JsonObject json;
        private volatile Integer hash;

        PatchValue(JsonProvider provider, JsonPatch.Operation operation, String path, String from, JsonValue value) {
            this.provider = provider;
            this.operation = operation;
            this.path = path;
            this.from = from;
            this.pathPointer = provider.createPointer(path);
            this.fromPointer = operation == JsonPatch.Operation.MOVE || operation == JsonPatch.Operation.COPY ? provider.createPointer(from) : null;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatchValue that = (PatchValue)o;
            if (this.operation != that.operation) {
                return false;
            }
            if (!this.path.equals(that.path)) {
                return false;
            }
            if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
                return false;
            }
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            if (this.hash == null) {
                PatchValue patchValue = this;
                synchronized (patchValue) {
                    if (this.hash == null) {
                        int result = this.operation.hashCode();
                        result = 31 * result + this.path.hashCode();
                        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
                        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                        this.hash = result;
                    }
                }
            }
            return this.hash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            if (this.str == null) {
                PatchValue patchValue = this;
                synchronized (patchValue) {
                    if (this.str == null) {
                        this.str = "{op: " + this.operation + ", path: " + this.path + ", from: " + this.from + ", value: " + this.value + "}";
                    }
                }
            }
            return this.str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JsonObject toJson() {
            if (this.json == null) {
                PatchValue patchValue = this;
                synchronized (patchValue) {
                    if (this.json == null) {
                        JsonObjectBuilder builder = this.provider.createObjectBuilder().add("op", this.operation.name().toLowerCase(Locale.ROOT)).add("path", this.path);
                        if (this.fromPointer != null) {
                            builder.add("from", this.from);
                        }
                        if (this.value != null) {
                            builder.add("value", this.value);
                        }
                        this.json = builder.build();
                    }
                }
            }
            return this.json;
        }
    }
}

