/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class FileHandler
extends Handler {
    private volatile String date = "";
    private String directory = null;
    private String prefix = null;
    private String suffix = null;
    private volatile PrintWriter writer = null;
    private int bufferSize = 0;

    public FileHandler() {
        this(null, null, null);
    }

    public FileHandler(String directory, String prefix, String suffix) {
        this.directory = directory;
        this.prefix = prefix;
        this.suffix = suffix;
        this.configure();
        this.openWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        String tsString = ts.toString().substring(0, 19);
        String tsDate = tsString.substring(0, 10);
        if (!this.date.equals(tsDate)) {
            FileHandler fileHandler = this;
            synchronized (fileHandler) {
                if (!this.date.equals(tsDate)) {
                    this.closeWriter();
                    this.date = tsDate;
                    this.openWriter();
                }
            }
        }
        String result = null;
        try {
            result = this.getFormatter().format(record);
        }
        catch (Exception e) {
            this.reportError(null, e, 5);
            return;
        }
        try {
            PrintWriter writer = this.writer;
            if (writer != null) {
                writer.write(result);
                if (this.bufferSize < 0) {
                    writer.flush();
                }
            } else {
                this.reportError("FileHandler is closed or not yet initialized, unable to log [" + result + "]", null, 1);
            }
        }
        catch (Exception e) {
            this.reportError(null, e, 1);
            return;
        }
    }

    public void close() {
        this.closeWriter();
    }

    protected void closeWriter() {
        try {
            PrintWriter writer = this.writer;
            this.writer = null;
            if (writer == null) {
                return;
            }
            writer.write(this.getFormatter().getTail(this));
            writer.flush();
            writer.close();
            writer = null;
            this.date = "";
        }
        catch (Exception e) {
            this.reportError(null, e, 3);
        }
    }

    public void flush() {
        try {
            PrintWriter writer = this.writer;
            if (writer == null) {
                return;
            }
            writer.flush();
        }
        catch (Exception e) {
            this.reportError(null, e, 2);
        }
    }

    private void configure() {
        String formatterName;
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        String tsString = ts.toString().substring(0, 19);
        this.date = tsString.substring(0, 10);
        String className = this.getClass().getName();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (this.directory == null) {
            this.directory = this.getProperty(className + ".directory", "logs");
        }
        if (this.prefix == null) {
            this.prefix = this.getProperty(className + ".prefix", "juli.");
        }
        if (this.suffix == null) {
            this.suffix = this.getProperty(className + ".suffix", ".log");
        }
        String sBufferSize = this.getProperty(className + ".bufferSize", "8192");
        try {
            this.bufferSize = Integer.parseInt(sBufferSize);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        String encoding = this.getProperty(className + ".encoding", null);
        if (encoding != null && encoding.length() > 0) {
            try {
                this.setEncoding(encoding);
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        this.setLevel(Level.parse(this.getProperty(className + ".level", "" + Level.ALL)));
        String filterName = this.getProperty(className + ".filter", null);
        if (filterName != null) {
            try {
                this.setFilter((Filter)cl.loadClass(filterName).newInstance());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((formatterName = this.getProperty(className + ".formatter", null)) != null) {
            try {
                this.setFormatter((Formatter)cl.loadClass(formatterName).newInstance());
            }
            catch (Exception e) {}
        } else {
            this.setFormatter(new SimpleFormatter());
        }
        this.setErrorManager(new ErrorManager());
    }

    private String getProperty(String name, String defaultValue) {
        String value = LogManager.getLogManager().getProperty(name);
        value = value == null ? defaultValue : value.trim();
        return value;
    }

    protected void open() {
        this.openWriter();
    }

    protected void openWriter() {
        File dir = new File(this.directory);
        dir.mkdirs();
        try {
            String pathname = dir.getAbsolutePath() + File.separator + this.prefix + this.date + this.suffix;
            String encoding = this.getEncoding();
            FileOutputStream fos = new FileOutputStream(pathname, true);
            OutputStream os = this.bufferSize > 0 ? new BufferedOutputStream(fos, this.bufferSize) : fos;
            this.writer = new PrintWriter((Writer)(encoding != null ? new OutputStreamWriter(os, encoding) : new OutputStreamWriter(os)), false);
            this.writer.write(this.getFormatter().getHead(this));
        }
        catch (Exception e) {
            this.reportError(null, e, 4);
            this.writer = null;
        }
    }
}

