/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.IOException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsFrameBase;
import org.apache.tomcat.websocket.WsSession;

public class WsFrameServer
extends WsFrameBase {
    private static final Log log = LogFactory.getLog(WsFrameServer.class);
    private static final StringManager sm = StringManager.getManager(WsFrameServer.class);
    private final SocketWrapperBase<?> socketWrapper;

    public WsFrameServer(SocketWrapperBase<?> socketWrapper, WsSession wsSession, Transformation transformation) {
        super(wsSession, transformation);
        this.socketWrapper = socketWrapper;
    }

    public void onDataAvailable() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"wsFrameServer.onDataAvailable");
        }
        while (this.isOpen() && this.socketWrapper.isReadyForRead()) {
            int read = this.socketWrapper.read(false, this.inputBuffer, this.writePos, this.inputBuffer.length - this.writePos);
            if (read <= 0) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("wsFrameServer.bytesRead", new Object[]{Integer.toString(read)}));
            }
            this.writePos += read;
            this.processInputBuffer();
        }
    }

    @Override
    protected boolean isMasked() {
        return true;
    }

    @Override
    protected Transformation getTransformation() {
        return super.getTransformation();
    }

    @Override
    protected boolean isOpen() {
        return super.isOpen();
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

