/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIndexHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerProperty;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerTransactionGraph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TinkerEdge
extends TinkerElement
implements Edge {
    protected Map<String, Property> properties;
    protected Vertex inVertex = null;
    protected Object inVertexId = null;
    protected Vertex outVertex = null;
    protected Object outVertexId = null;
    private final AbstractTinkerGraph graph;
    private final boolean allowNullPropertyValues;
    private final boolean isTxMode;

    protected TinkerEdge(Object id, Vertex outVertex, String label, Vertex inVertex) {
        this(id, outVertex, label, inVertex, 0L);
    }

    protected TinkerEdge(Object id, Vertex outVertex, String label, Vertex inVertex, long currentVersion) {
        this(id, (AbstractTinkerGraph)outVertex.graph(), outVertex.id(), label, inVertex.id(), currentVersion, false);
        if (!this.isTxMode) {
            this.inVertex = inVertex;
            this.outVertex = outVertex;
        }
    }

    private TinkerEdge(Object id, AbstractTinkerGraph graph, Object outVertexId, String label, Object inVertexId, long currentVersion, Boolean skipIndexUpdate) {
        super(id, label, currentVersion);
        this.isTxMode = graph instanceof TinkerTransactionGraph;
        this.graph = graph;
        if (this.isTxMode) {
            this.outVertexId = outVertexId;
            this.inVertexId = inVertexId;
        }
        this.allowNullPropertyValues = graph.features().edge().supportsNullPropertyValues();
        if (!skipIndexUpdate.booleanValue()) {
            TinkerIndexHelper.autoUpdateIndex(this, T.label.getAccessor(), (Object)this.label, null);
        }
    }

    public <V> Property<V> property(String key, V value) {
        this.graph.touch(this);
        if (this.removed) {
            throw TinkerEdge.elementAlreadyRemoved(Edge.class, this.id);
        }
        ElementHelper.validateProperty((String)key, value);
        if (!this.allowNullPropertyValues && null == value) {
            this.properties(key).forEachRemaining(Property::remove);
            return Property.empty();
        }
        Property oldProperty = super.property(key);
        TinkerProperty<V> newProperty = new TinkerProperty<V>(this, key, value);
        if (null == this.properties) {
            this.properties = new ConcurrentHashMap<String, Property>();
        }
        this.properties.put(key, newProperty);
        TinkerIndexHelper.autoUpdateIndex(this, key, value, oldProperty.isPresent() ? oldProperty.value() : null);
        return newProperty;
    }

    public <V> Property<V> property(String key) {
        return null == this.properties ? Property.empty() : this.properties.getOrDefault(key, Property.empty());
    }

    public Set<String> keys() {
        return null == this.properties ? Collections.emptySet() : this.properties.keySet();
    }

    public void remove() {
        this.graph.touch(this);
        TinkerIndexHelper.removeElementIndex(this);
        this.graph.removeEdge(this.id());
        this.properties = null;
        this.removed = true;
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    @Override
    public Object clone() {
        if (!this.isTxMode) {
            TinkerEdge edge = new TinkerEdge(this.id, this.outVertex, this.label, this.inVertex, this.currentVersion);
            edge.properties = this.properties;
            return edge;
        }
        TinkerEdge edge = new TinkerEdge(this.id, this.graph, this.outVertexId, this.label, this.inVertexId, this.currentVersion, true);
        if (this.properties != null) {
            ConcurrentHashMap<String, Property> cloned = new ConcurrentHashMap<String, Property>(this.properties.size());
            this.properties.entrySet().stream().forEach(p -> cloned.put((String)p.getKey(), ((TinkerProperty)p.getValue()).copy(edge)));
            edge.properties = cloned;
        }
        return edge;
    }

    public Vertex outVertex() {
        return this.isTxMode ? this.graph.vertex(this.outVertexId) : this.outVertex;
    }

    public Vertex inVertex() {
        return this.isTxMode ? this.graph.vertex(this.inVertexId) : this.inVertex;
    }

    public Iterator<Vertex> vertices(Direction direction) {
        if (this.removed) {
            return Collections.emptyIterator();
        }
        switch (direction) {
            case OUT: {
                return IteratorUtils.of((Object)this.outVertex());
            }
            case IN: {
                return IteratorUtils.of((Object)this.inVertex());
            }
        }
        return IteratorUtils.of((Object)this.outVertex(), (Object)this.inVertex());
    }

    public Graph graph() {
        return this.graph;
    }

    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        if (null == this.properties) {
            return Collections.emptyIterator();
        }
        if (propertyKeys.length == 1) {
            if (null == propertyKeys[0]) {
                return Collections.emptyIterator();
            }
            Property property = this.properties.get(propertyKeys[0]);
            return null == property ? Collections.emptyIterator() : IteratorUtils.of((Object)property);
        }
        return this.properties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)((String)entry.getKey()), (String[])propertyKeys)).map(entry -> (Property)entry.getValue()).collect(Collectors.toList()).iterator();
    }
}

