/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.computer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.ComputerGraph;
import org.apache.tinkerpop.gremlin.process.computer.util.DefaultComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.util.GraphComputerHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputerView;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerMapEmitter;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerMemory;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerMessageBoard;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerMessenger;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerReduceEmitter;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerWorkerPool;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;

public final class TinkerGraphComputer
implements GraphComputer {
    private GraphComputer.ResultGraph resultGraph = null;
    private GraphComputer.Persist persist = null;
    private VertexProgram<?> vertexProgram;
    private final TinkerGraph graph;
    private TinkerMemory memory;
    private final TinkerMessageBoard messageBoard = new TinkerMessageBoard();
    private boolean executed = false;
    private final Set<MapReduce> mapReducers = new HashSet<MapReduce>();
    private int workers = Runtime.getRuntime().availableProcessors();
    private final GraphFilter graphFilter = new GraphFilter();

    public TinkerGraphComputer(TinkerGraph graph) {
        this.graph = graph;
    }

    public GraphComputer result(GraphComputer.ResultGraph resultGraph) {
        this.resultGraph = resultGraph;
        return this;
    }

    public GraphComputer persist(GraphComputer.Persist persist) {
        this.persist = persist;
        return this;
    }

    public GraphComputer program(VertexProgram vertexProgram) {
        this.vertexProgram = vertexProgram;
        return this;
    }

    public GraphComputer mapReduce(MapReduce mapReduce) {
        this.mapReducers.add(mapReduce);
        return this;
    }

    public GraphComputer workers(int workers) {
        this.workers = workers;
        return this;
    }

    public GraphComputer vertices(Traversal<Vertex, Vertex> vertexFilter) {
        this.graphFilter.setVertexFilter(vertexFilter);
        return this;
    }

    public GraphComputer edges(Traversal<Vertex, Edge> edgeFilter) {
        this.graphFilter.setEdgeFilter(edgeFilter);
        return this;
    }

    public Future<ComputerResult> submit() {
        if (this.executed) {
            throw GraphComputer.Exceptions.computerHasAlreadyBeenSubmittedAVertexProgram();
        }
        this.executed = true;
        if (null == this.vertexProgram && this.mapReducers.isEmpty()) {
            throw GraphComputer.Exceptions.computerHasNoVertexProgramNorMapReducers();
        }
        if (null != this.vertexProgram) {
            GraphComputerHelper.validateProgramOnComputer((GraphComputer)this, this.vertexProgram);
            this.mapReducers.addAll(this.vertexProgram.getMapReducers());
        }
        this.resultGraph = GraphComputerHelper.getResultGraphState(Optional.ofNullable(this.vertexProgram), Optional.ofNullable(this.resultGraph));
        this.persist = GraphComputerHelper.getPersistState(Optional.ofNullable(this.vertexProgram), Optional.ofNullable(this.persist));
        if (!this.features().supportsResultGraphPersistCombination(this.resultGraph, this.persist)) {
            throw GraphComputer.Exceptions.resultGraphPersistCombinationNotSupported((GraphComputer.ResultGraph)this.resultGraph, (GraphComputer.Persist)this.persist);
        }
        if (this.workers > this.features().getMaxWorkers()) {
            throw GraphComputer.Exceptions.computerRequiresMoreWorkersThanSupported((int)this.workers, (int)this.features().getMaxWorkers());
        }
        this.memory = new TinkerMemory(this.vertexProgram, this.mapReducers);
        return CompletableFuture.supplyAsync(() -> {
            long time = System.currentTimeMillis();
            try (TinkerWorkerPool workers = new TinkerWorkerPool(this.workers);){
                TinkerGraphComputerView view;
                if (null == this.vertexProgram) {
                    view = TinkerHelper.createGraphComputerView(this.graph, this.graphFilter, Collections.emptySet());
                } else {
                    view = TinkerHelper.createGraphComputerView(this.graph, this.graphFilter, this.vertexProgram.getVertexComputeKeys());
                    this.vertexProgram.setup((Memory)this.memory);
                    while (true) {
                        this.memory.completeSubRound();
                        workers.setVertexProgram(this.vertexProgram);
                        SynchronizedIterator<Vertex> vertices = new SynchronizedIterator<Vertex>(this.graph.vertices(new Object[0]));
                        workers.executeVertexProgram(vertexProgram -> {
                            Vertex vertex;
                            vertexProgram.workerIterationStart(this.memory.asImmutable());
                            while (null != (vertex = (Vertex)vertices.next())) {
                                vertexProgram.execute((Vertex)ComputerGraph.vertexProgram((Vertex)vertex, (VertexProgram)vertexProgram), new TinkerMessenger(vertex, this.messageBoard, vertexProgram.getMessageCombiner()), (Memory)this.memory);
                            }
                            vertexProgram.workerIterationEnd(this.memory.asImmutable());
                        });
                        this.messageBoard.completeIteration();
                        this.memory.completeSubRound();
                        if (this.vertexProgram.terminate((Memory)this.memory)) {
                            this.memory.incrIteration();
                            view.complete();
                            break;
                        }
                        this.memory.incrIteration();
                    }
                }
                for (MapReduce mapReduce : this.mapReducers) {
                    TinkerMapEmitter mapEmitter = new TinkerMapEmitter(mapReduce.doStage(MapReduce.Stage.REDUCE));
                    SynchronizedIterator<Vertex> vertices = new SynchronizedIterator<Vertex>(this.graph.vertices(new Object[0]));
                    workers.setMapReduce(mapReduce);
                    workers.executeMapReduce(workerMapReduce -> {
                        Vertex vertex;
                        workerMapReduce.workerStart(MapReduce.Stage.MAP);
                        while (null != (vertex = (Vertex)vertices.next())) {
                            workerMapReduce.map((Vertex)ComputerGraph.mapReduce((Vertex)vertex), (MapReduce.MapEmitter)mapEmitter);
                        }
                        workerMapReduce.workerEnd(MapReduce.Stage.MAP);
                    });
                    mapEmitter.complete(mapReduce);
                    if (mapReduce.doStage(MapReduce.Stage.REDUCE)) {
                        TinkerReduceEmitter reduceEmitter = new TinkerReduceEmitter();
                        SynchronizedIterator keyValues = new SynchronizedIterator(mapEmitter.reduceMap.entrySet().iterator());
                        workers.executeMapReduce(workerMapReduce -> {
                            Map.Entry entry;
                            workerMapReduce.workerStart(MapReduce.Stage.REDUCE);
                            while (null != (entry = (Map.Entry)keyValues.next())) {
                                workerMapReduce.reduce(entry.getKey(), ((Queue)entry.getValue()).iterator(), (MapReduce.ReduceEmitter)reduceEmitter);
                            }
                            workerMapReduce.workerEnd(MapReduce.Stage.REDUCE);
                        });
                        reduceEmitter.complete(mapReduce);
                        mapReduce.addResultToMemory((Memory.Admin)this.memory, reduceEmitter.reduceQueue.iterator());
                        continue;
                    }
                    mapReduce.addResultToMemory((Memory.Admin)this.memory, mapEmitter.mapQueue.iterator());
                }
                this.memory.setRuntime(System.currentTimeMillis() - time);
                this.memory.complete();
                Graph resultGraph = view.processResultGraphPersist(this.resultGraph, this.persist);
                TinkerHelper.dropGraphComputerView(this.graph);
                DefaultComputerResult defaultComputerResult = new DefaultComputerResult(resultGraph, this.memory.asImmutable());
                return defaultComputerResult;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public String toString() {
        return StringFactory.graphComputerString((GraphComputer)this);
    }

    public GraphComputer.Features features() {
        return new GraphComputer.Features(){

            public int getMaxWorkers() {
                return Runtime.getRuntime().availableProcessors();
            }

            public boolean supportsVertexAddition() {
                return false;
            }

            public boolean supportsVertexRemoval() {
                return false;
            }

            public boolean supportsVertexPropertyRemoval() {
                return false;
            }

            public boolean supportsEdgeAddition() {
                return false;
            }

            public boolean supportsEdgeRemoval() {
                return false;
            }

            public boolean supportsEdgePropertyAddition() {
                return false;
            }

            public boolean supportsEdgePropertyRemoval() {
                return false;
            }
        };
    }

    private static class SynchronizedIterator<V> {
        private final Iterator<V> iterator;

        public SynchronizedIterator(Iterator<V> iterator) {
            this.iterator = iterator;
        }

        public synchronized V next() {
            return this.iterator.hasNext() ? (V)this.iterator.next() : null;
        }
    }
}

