/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputer;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputerView;
import org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.strategy.optimization.TinkerGraphStepStrategy;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraphVariables;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIndex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureIntegrateSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructurePerformanceSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessComputerSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessPerformanceSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.GroovyProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.GroovyProcessComputerSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.groovy.GroovyEnvironmentSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.groovy.GroovyEnvironmentIntegrateSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.groovy.GroovyEnvironmentPerformanceSuite")})
public final class TinkerGraph
implements Graph {
    private static final Configuration EMPTY_CONFIGURATION;
    public static final String CONFIG_VERTEX_ID = "gremlin.tinkergraph.vertexIdManager";
    public static final String CONFIG_EDGE_ID = "gremlin.tinkergraph.edgeIdManager";
    public static final String CONFIG_VERTEX_PROPERTY_ID = "gremlin.tinkergraph.vertexPropertyIdManager";
    public static final String CONFIG_DEFAULT_VERTEX_PROPERTY_CARDINALITY = "gremlin.tinkergraph.defaultVertexPropertyCardinality";
    public static final String CONFIG_GRAPH_LOCATION = "gremlin.tinkergraph.graphLocation";
    public static final String CONFIG_GRAPH_FORMAT = "gremlin.tinkergraph.graphFormat";
    private final TinkerGraphFeatures features = new TinkerGraphFeatures();
    protected AtomicLong currentId = new AtomicLong(-1L);
    protected Map<Object, Vertex> vertices = new ConcurrentHashMap<Object, Vertex>();
    protected Map<Object, Edge> edges = new ConcurrentHashMap<Object, Edge>();
    protected TinkerGraphVariables variables = null;
    protected TinkerGraphComputerView graphComputerView = null;
    protected TinkerIndex<TinkerVertex> vertexIndex = null;
    protected TinkerIndex<TinkerEdge> edgeIndex = null;
    protected final IdManager<?> vertexIdManager;
    protected final IdManager<?> edgeIdManager;
    protected final IdManager<?> vertexPropertyIdManager;
    protected final VertexProperty.Cardinality defaultVertexPropertyCardinality;
    private final Configuration configuration;
    private final String graphLocation;
    private final String graphFormat;

    private TinkerGraph(Configuration configuration) {
        this.configuration = configuration;
        this.vertexIdManager = TinkerGraph.selectIdManager(configuration, CONFIG_VERTEX_ID, Vertex.class);
        this.edgeIdManager = TinkerGraph.selectIdManager(configuration, CONFIG_EDGE_ID, Edge.class);
        this.vertexPropertyIdManager = TinkerGraph.selectIdManager(configuration, CONFIG_VERTEX_PROPERTY_ID, VertexProperty.class);
        this.defaultVertexPropertyCardinality = VertexProperty.Cardinality.valueOf((String)configuration.getString(CONFIG_DEFAULT_VERTEX_PROPERTY_CARDINALITY, VertexProperty.Cardinality.single.name()));
        this.graphLocation = configuration.getString(CONFIG_GRAPH_LOCATION, null);
        this.graphFormat = configuration.getString(CONFIG_GRAPH_FORMAT, null);
        if (this.graphLocation != null && null == this.graphFormat || null == this.graphLocation && this.graphFormat != null) {
            throw new IllegalStateException(String.format("The %s and %s must both be specified if either is present", CONFIG_GRAPH_LOCATION, CONFIG_GRAPH_FORMAT));
        }
        if (this.graphLocation != null) {
            this.loadGraph();
        }
    }

    public static TinkerGraph open() {
        return TinkerGraph.open(EMPTY_CONFIGURATION);
    }

    public static TinkerGraph open(Configuration configuration) {
        return new TinkerGraph(configuration);
    }

    public Vertex addVertex(Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        Object idValue = this.vertexIdManager.convert(ElementHelper.getIdValue((Object[])keyValues).orElse(null));
        String label = ElementHelper.getLabelValue((Object[])keyValues).orElse("vertex");
        if (null != idValue) {
            if (this.vertices.containsKey(idValue)) {
                throw Graph.Exceptions.vertexWithIdAlreadyExists(idValue);
            }
        } else {
            idValue = this.vertexIdManager.getNextId(this);
        }
        TinkerVertex vertex = new TinkerVertex(idValue, label, this);
        this.vertices.put(vertex.id(), vertex);
        ElementHelper.attachProperties((Vertex)vertex, (VertexProperty.Cardinality)VertexProperty.Cardinality.list, (Object[])keyValues);
        return vertex;
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) {
        if (!graphComputerClass.equals(TinkerGraphComputer.class)) {
            throw Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer(graphComputerClass);
        }
        return (C)new TinkerGraphComputer(this);
    }

    public GraphComputer compute() {
        return new TinkerGraphComputer(this);
    }

    public Graph.Variables variables() {
        if (null == this.variables) {
            this.variables = new TinkerGraphVariables();
        }
        return this.variables;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)("vertices:" + this.vertices.size() + " edges:" + this.edges.size()));
    }

    public void clear() {
        this.vertices.clear();
        this.edges.clear();
        this.variables = null;
        this.currentId.set(-1L);
        this.vertexIndex = null;
        this.edgeIndex = null;
        this.graphComputerView = null;
    }

    public void close() {
        if (this.graphLocation != null) {
            this.saveGraph();
        }
    }

    public Transaction tx() {
        throw Graph.Exceptions.transactionsNotSupported();
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Iterator<Vertex> vertices(Object ... vertexIds) {
        return this.createElementIterator(Vertex.class, this.vertices, this.vertexIdManager, vertexIds);
    }

    public Iterator<Edge> edges(Object ... edgeIds) {
        return this.createElementIterator(Edge.class, this.edges, this.edgeIdManager, edgeIds);
    }

    private void loadGraph() {
        File f = new File(this.graphLocation);
        if (f.exists() && f.isFile()) {
            try {
                if (this.graphFormat.equals("graphml")) {
                    ((GraphMLIo)this.io(IoCore.graphml())).readGraph(this.graphLocation);
                } else if (this.graphFormat.equals("graphson")) {
                    ((GraphSONIo)this.io(IoCore.graphson())).readGraph(this.graphLocation);
                } else if (this.graphFormat.equals("gryo")) {
                    ((GryoIo)this.io(IoCore.gryo())).readGraph(this.graphLocation);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(String.format("Could not load graph at %s with %s", this.graphLocation, this.graphFormat));
            }
        }
    }

    private void saveGraph() {
        File f = new File(this.graphLocation);
        if (f.exists()) {
            f.delete();
        } else {
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }
        try {
            if (this.graphFormat.equals("graphml")) {
                ((GraphMLIo)this.io(IoCore.graphml())).writeGraph(this.graphLocation);
            } else if (this.graphFormat.equals("graphson")) {
                ((GraphSONIo)this.io(IoCore.graphson())).writeGraph(this.graphLocation);
            } else if (this.graphFormat.equals("gryo")) {
                ((GryoIo)this.io(IoCore.gryo())).writeGraph(this.graphLocation);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Could not save graph at %s with %s", this.graphLocation, this.graphFormat));
        }
    }

    private <T extends Element> Iterator<T> createElementIterator(Class<T> clazz, Map<Object, T> elements, IdManager idManager, Object ... ids) {
        if (0 == ids.length) {
            return elements.values().iterator();
        }
        if (1 == ids.length) {
            if (clazz.isAssignableFrom(ids[0].getClass())) {
                return IteratorUtils.of((Object)((Element)ids[0]));
            }
            Element element = (Element)elements.get(idManager.convert(ids[0]));
            return null == element ? Collections.emptyIterator() : IteratorUtils.of((Object)element);
        }
        if (clazz.isAssignableFrom(ids[0].getClass())) {
            if (!Stream.of(ids).allMatch(id -> clazz.isAssignableFrom(id.getClass()))) {
                throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
            }
            return Stream.of(ids).map(id -> (Element)id).iterator();
        }
        Class<?> firstClass = ids[0].getClass();
        if (!Stream.of(ids).map(Object::getClass).allMatch(firstClass::equals)) {
            throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
        }
        return Stream.of(ids).map(id -> idManager.convert(id)).map(elements::get).filter(Objects::nonNull).iterator();
    }

    public Graph.Features features() {
        return this.features;
    }

    public <E extends Element> void createIndex(String key, Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            if (null == this.vertexIndex) {
                this.vertexIndex = new TinkerIndex<TinkerVertex>(this, TinkerVertex.class);
            }
            this.vertexIndex.createKeyIndex(key);
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            if (null == this.edgeIndex) {
                this.edgeIndex = new TinkerIndex<TinkerEdge>(this, TinkerEdge.class);
            }
            this.edgeIndex.createKeyIndex(key);
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    public <E extends Element> void dropIndex(String key, Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            if (null != this.vertexIndex) {
                this.vertexIndex.dropKeyIndex(key);
            }
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            if (null != this.edgeIndex) {
                this.edgeIndex.dropKeyIndex(key);
            }
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    public <E extends Element> Set<String> getIndexedKeys(Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return null == this.vertexIndex ? Collections.emptySet() : this.vertexIndex.getIndexedKeys();
        }
        if (Edge.class.isAssignableFrom(elementClass)) {
            return null == this.edgeIndex ? Collections.emptySet() : this.edgeIndex.getIndexedKeys();
        }
        throw new IllegalArgumentException("Class is not indexable: " + elementClass);
    }

    private static IdManager<?> selectIdManager(Configuration config, String configKey, Class<? extends Element> clazz) {
        String vertexIdManagerConfigValue = config.getString(configKey, DefaultIdManager.ANY.name());
        try {
            return DefaultIdManager.valueOf(vertexIdManagerConfigValue);
        }
        catch (IllegalArgumentException iae) {
            try {
                return (IdManager)Class.forName(vertexIdManagerConfigValue).newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException(String.format("Could not configure TinkerGraph %s id manager with %s", clazz.getSimpleName(), vertexIdManagerConfigValue));
            }
        }
    }

    static {
        TraversalStrategies.GlobalCache.registerStrategies(TinkerGraph.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{TinkerGraphStepStrategy.instance()}));
        EMPTY_CONFIGURATION = new BaseConfiguration(){
            {
                this.setProperty("gremlin.graph", TinkerGraph.class.getName());
            }
        };
    }

    public static enum DefaultIdManager implements IdManager
    {
        LONG{

            public Long getNextId(TinkerGraph graph) {
                return Stream.generate(() -> graph.currentId.incrementAndGet()).filter(id -> !graph.vertices.containsKey(id) && !graph.edges.containsKey(id)).findAny().get();
            }

            public Object convert(Object id) {
                if (null == id) {
                    return null;
                }
                if (id instanceof Long) {
                    return id;
                }
                if (id instanceof Number) {
                    return ((Number)id).longValue();
                }
                if (id instanceof String) {
                    return Long.parseLong((String)id);
                }
                throw new IllegalArgumentException(String.format("Expected an id that is convertible to Long but received %s", id.getClass()));
            }

            @Override
            public boolean allow(Object id) {
                return id instanceof Number || id instanceof String;
            }
        }
        ,
        INTEGER{

            public Integer getNextId(TinkerGraph graph) {
                return Stream.generate(() -> graph.currentId.incrementAndGet()).map(Long::intValue).filter(id -> !graph.vertices.containsKey(id) && !graph.edges.containsKey(id)).findAny().get();
            }

            public Object convert(Object id) {
                if (null == id) {
                    return null;
                }
                if (id instanceof Integer) {
                    return id;
                }
                if (id instanceof Number) {
                    return ((Number)id).intValue();
                }
                if (id instanceof String) {
                    return Integer.parseInt((String)id);
                }
                throw new IllegalArgumentException(String.format("Expected an id that is convertible to Integer but received %s", id.getClass()));
            }

            @Override
            public boolean allow(Object id) {
                return id instanceof Number || id instanceof String;
            }
        }
        ,
        UUID{

            public UUID getNextId(TinkerGraph graph) {
                return java.util.UUID.randomUUID();
            }

            public Object convert(Object id) {
                if (null == id) {
                    return null;
                }
                if (id instanceof UUID) {
                    return id;
                }
                if (id instanceof String) {
                    return java.util.UUID.fromString((String)id);
                }
                throw new IllegalArgumentException(String.format("Expected an id that is convertible to UUID but received %s", id.getClass()));
            }

            @Override
            public boolean allow(Object id) {
                return id instanceof UUID || id instanceof String;
            }
        }
        ,
        ANY{

            public Long getNextId(TinkerGraph graph) {
                return Stream.generate(() -> graph.currentId.incrementAndGet()).filter(id -> !graph.vertices.containsKey(id) && !graph.edges.containsKey(id)).findAny().get();
            }

            public Object convert(Object id) {
                return id;
            }

            @Override
            public boolean allow(Object id) {
                return true;
            }
        };

    }

    public static interface IdManager<T> {
        public T getNextId(TinkerGraph var1);

        public T convert(Object var1);

        public boolean allow(Object var1);
    }

    public class TinkerGraphVertexPropertyFeatures
    implements Graph.Features.VertexPropertyFeatures {
        private TinkerGraphVertexPropertyFeatures() {
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object id) {
            return TinkerGraph.this.vertexIdManager.allow(id);
        }
    }

    public class TinkerGraphGraphFeatures
    implements Graph.Features.GraphFeatures {
        private TinkerGraphGraphFeatures() {
        }

        public boolean supportsConcurrentAccess() {
            return false;
        }

        public boolean supportsTransactions() {
            return false;
        }

        public boolean supportsThreadedTransactions() {
            return false;
        }
    }

    public class TinkerGraphEdgeFeatures
    implements Graph.Features.EdgeFeatures {
        private TinkerGraphEdgeFeatures() {
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object id) {
            return TinkerGraph.this.edgeIdManager.allow(id);
        }
    }

    public class TinkerGraphVertexFeatures
    implements Graph.Features.VertexFeatures {
        private final TinkerGraphVertexPropertyFeatures vertexPropertyFeatures;

        private TinkerGraphVertexFeatures() {
            this.vertexPropertyFeatures = new TinkerGraphVertexPropertyFeatures();
        }

        public Graph.Features.VertexPropertyFeatures properties() {
            return this.vertexPropertyFeatures;
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object id) {
            return TinkerGraph.this.vertexIdManager.allow(id);
        }

        public VertexProperty.Cardinality getCardinality(String key) {
            return TinkerGraph.this.defaultVertexPropertyCardinality;
        }
    }

    public class TinkerGraphFeatures
    implements Graph.Features {
        private final TinkerGraphGraphFeatures graphFeatures;
        private final TinkerGraphEdgeFeatures edgeFeatures;
        private final TinkerGraphVertexFeatures vertexFeatures;

        private TinkerGraphFeatures() {
            this.graphFeatures = new TinkerGraphGraphFeatures();
            this.edgeFeatures = new TinkerGraphEdgeFeatures();
            this.vertexFeatures = new TinkerGraphVertexFeatures();
        }

        public Graph.Features.GraphFeatures graph() {
            return this.graphFeatures;
        }

        public Graph.Features.EdgeFeatures edge() {
            return this.edgeFeatures;
        }

        public Graph.Features.VertexFeatures vertex() {
            return this.vertexFeatures;
        }

        public String toString() {
            return StringFactory.featureString((Graph.Features)this);
        }
    }
}

