/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.sparql.process.traversal.strategy;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.remote.traversal.strategy.decoration.RemoteStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.InjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.sparql.SparqlToGremlinCompiler;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class SparqlStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private static final SparqlStrategy INSTANCE = new SparqlStrategy();
    private static final Set<Class<? extends TraversalStrategy.DecorationStrategy>> PRIORS = Collections.singleton(RemoteStrategy.class);

    private SparqlStrategy() {
    }

    public static SparqlStrategy instance() {
        return INSTANCE;
    }

    public Set<Class<? extends TraversalStrategy.DecorationStrategy>> applyPrior() {
        return PRIORS;
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        InjectStep stepWithSparql;
        Object[] injections;
        if (!traversal.isRoot()) {
            return;
        }
        if (traversal.getStartStep() instanceof InjectStep && (injections = (stepWithSparql = (InjectStep)traversal.getStartStep()).getInjections()).length == 1 && injections[0] instanceof String) {
            String sparql = (String)injections[0];
            GraphTraversal<Vertex, ?> sparqlTraversal = SparqlToGremlinCompiler.compile((GraphTraversalSource)traversal.getTraversalSource().orElseGet(() -> (TraversalSource)traversal.getGraph().map(Graph::traversal).get()), sparql);
            TraversalHelper.insertTraversal((Step)stepWithSparql, (Traversal.Admin)sparqlTraversal.asAdmin(), traversal);
            traversal.removeStep((Step)stepWithSparql);
        }
    }
}

