/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.sparql;

import java.util.List;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_GreaterThan;
import org.apache.jena.sparql.expr.E_GreaterThanOrEqual;
import org.apache.jena.sparql.expr.E_LessThan;
import org.apache.jena.sparql.expr.E_LessThanOrEqual;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_NotEquals;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.Expr;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.sparql.TraversalBuilder;

class WhereTraversalBuilder {
    WhereTraversalBuilder() {
    }

    static GraphTraversal<?, ?> transform(Expr expression) {
        if (expression instanceof E_Equals) {
            return WhereTraversalBuilder.transform((E_Equals)expression);
        }
        if (expression instanceof E_NotEquals) {
            return WhereTraversalBuilder.transform((E_NotEquals)expression);
        }
        if (expression instanceof E_LessThan) {
            return WhereTraversalBuilder.transform((E_LessThan)expression);
        }
        if (expression instanceof E_LessThanOrEqual) {
            return WhereTraversalBuilder.transform((E_LessThanOrEqual)expression);
        }
        if (expression instanceof E_GreaterThan) {
            return WhereTraversalBuilder.transform((E_GreaterThan)expression);
        }
        if (expression instanceof E_GreaterThanOrEqual) {
            return WhereTraversalBuilder.transform((E_GreaterThanOrEqual)expression);
        }
        if (expression instanceof E_LogicalAnd) {
            return WhereTraversalBuilder.transform((E_LogicalAnd)expression);
        }
        if (expression instanceof E_LogicalOr) {
            return WhereTraversalBuilder.transform((E_LogicalOr)expression);
        }
        if (expression instanceof E_Exists) {
            return WhereTraversalBuilder.transform((E_Exists)expression);
        }
        if (expression instanceof E_NotExists) {
            return WhereTraversalBuilder.transform((E_NotExists)expression);
        }
        throw new IllegalStateException(String.format("Unhandled expression: %s", expression));
    }

    private static GraphTraversal<?, ?> transform(E_Equals expression) {
        Object value = expression.getArg2().getConstant().getNode().getLiteralValue();
        return __.as((String)expression.getArg1().getVarName(), (String[])new String[0]).is(P.eq((Object)value));
    }

    private static GraphTraversal<?, ?> transform(E_NotEquals expression) {
        Object value = expression.getArg2().getConstant().getNode().getLiteralValue();
        return __.as((String)expression.getArg1().getVarName(), (String[])new String[0]).is(P.neq((Object)value));
    }

    private static GraphTraversal<?, ?> transform(E_LessThan expression) {
        Object value = expression.getArg2().getConstant().getNode().getLiteralValue();
        return __.as((String)expression.getArg1().getVarName(), (String[])new String[0]).is(P.lt((Object)value));
    }

    private static GraphTraversal<?, ?> transform(E_LessThanOrEqual expression) {
        Object value = expression.getArg2().getConstant().getNode().getLiteralValue();
        return __.as((String)expression.getArg1().getVarName(), (String[])new String[0]).is(P.lte((Object)value));
    }

    private static GraphTraversal<?, ?> transform(E_GreaterThan expression) {
        Object value = expression.getArg2().getConstant().getNode().getLiteralValue();
        return __.as((String)expression.getArg1().getVarName(), (String[])new String[0]).is(P.gt((Object)value));
    }

    private static GraphTraversal<?, ?> transform(E_GreaterThanOrEqual expression) {
        Object value = expression.getArg2().getConstant().getNode().getLiteralValue();
        return __.as((String)expression.getArg1().getVarName(), (String[])new String[0]).is(P.gte((Object)value));
    }

    private static GraphTraversal<?, ?> transform(E_LogicalAnd expression) {
        return __.and((Traversal[])new Traversal[]{WhereTraversalBuilder.transform(expression.getArg1()), WhereTraversalBuilder.transform(expression.getArg2())});
    }

    private static GraphTraversal<?, ?> transform(E_LogicalOr expression) {
        return __.or((Traversal[])new Traversal[]{WhereTraversalBuilder.transform(expression.getArg1()), WhereTraversalBuilder.transform(expression.getArg2())});
    }

    private static GraphTraversal<?, ?> transform(E_Exists expression) {
        OpBGP opBGP = (OpBGP)expression.getGraphPattern();
        List triples = opBGP.getPattern().getList();
        if (triples.size() != 1) {
            throw new IllegalStateException("Unhandled EXISTS pattern");
        }
        GraphTraversal<?, ?> traversal = TraversalBuilder.transform((Triple)triples.get(0));
        Step endStep = traversal.asAdmin().getEndStep();
        String label = (String)endStep.getLabels().iterator().next();
        endStep.removeLabel(label);
        return traversal;
    }

    private static GraphTraversal<?, ?> transform(E_NotExists expression) {
        OpBGP opBGP = (OpBGP)expression.getGraphPattern();
        List triples = opBGP.getPattern().getList();
        if (triples.size() != 1) {
            throw new IllegalStateException("Unhandled NOT EXISTS pattern");
        }
        GraphTraversal<?, ?> traversal = TraversalBuilder.transform((Triple)triples.get(0));
        Step endStep = traversal.asAdmin().getEndStep();
        String label = (String)endStep.getLabels().iterator().next();
        endStep.removeLabel(label);
        return __.not(traversal);
    }
}

