/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.sparql;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.sparql.Prefixes;
import org.apache.tinkerpop.gremlin.structure.PropertyType;

class TraversalBuilder {
    TraversalBuilder() {
    }

    static GraphTraversal<?, ?> transform(Triple triple) {
        String prefix;
        GraphTraversal matchTraversal = __.as((String)triple.getSubject().getName(), (String[])new String[0]);
        Node predicate = triple.getPredicate();
        String uri = predicate.getURI();
        String uriValue = Prefixes.getURIValue(uri);
        switch (prefix = Prefixes.getPrefix(uri)) {
            case "edge": {
                return matchTraversal.out(new String[]{uriValue}).as(triple.getObject().getName(), new String[0]);
            }
            case "property": {
                return TraversalBuilder.matchProperty(matchTraversal, uriValue, PropertyType.PROPERTY, triple.getObject());
            }
            case "value": {
                return TraversalBuilder.matchProperty(matchTraversal, uriValue, PropertyType.VALUE, triple.getObject());
            }
        }
        throw new IllegalStateException(String.format("Unexpected predicate: %s", predicate));
    }

    private static GraphTraversal<?, ?> matchProperty(GraphTraversal<?, ?> traversal, String propertyName, PropertyType type, Node object) {
        switch (propertyName) {
            case "id": {
                return object.isConcrete() ? traversal.hasId(object.getLiteralValue(), new Object[0]) : traversal.id().as(object.getName(), new String[0]);
            }
            case "label": {
                return object.isConcrete() ? traversal.hasLabel(object.getLiteralValue().toString(), new String[0]) : traversal.label().as(object.getName(), new String[0]);
            }
            case "key": {
                return object.isConcrete() ? traversal.hasKey(object.getLiteralValue().toString(), new String[0]) : traversal.key().as(object.getName(), new String[0]);
            }
            case "value": {
                return object.isConcrete() ? traversal.hasValue((Object)object.getLiteralValue().toString(), new Object[0]) : traversal.value().as(object.getName(), new String[0]);
            }
        }
        if (type.equals((Object)PropertyType.PROPERTY)) {
            return traversal.properties(new String[]{propertyName}).as(object.getName(), new String[0]);
        }
        return object.isConcrete() ? traversal.has(propertyName, object.getLiteralValue()) : traversal.values(new String[]{propertyName}).as(object.getName(), new String[0]);
    }
}

