/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.sparql.process.traversal.dsl.sparql;

import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.traversal.strategy.decoration.RemoteStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.InjectStep;
import org.apache.tinkerpop.gremlin.sparql.process.traversal.dsl.sparql.DefaultSparqlTraversal;
import org.apache.tinkerpop.gremlin.sparql.process.traversal.dsl.sparql.SparqlTraversal;
import org.apache.tinkerpop.gremlin.sparql.process.traversal.strategy.SparqlStrategy;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class SparqlTraversalSource
implements TraversalSource {
    protected transient RemoteConnection connection;
    protected final Graph graph;
    protected TraversalStrategies strategies;
    protected Bytecode bytecode = new Bytecode();

    public SparqlTraversalSource(Graph graph, TraversalStrategies traversalStrategies) {
        this.graph = graph;
        this.strategies = traversalStrategies;
    }

    public SparqlTraversalSource(Graph graph) {
        this(graph, TraversalStrategies.GlobalCache.getStrategies(graph.getClass()));
    }

    public TraversalStrategies getStrategies() {
        return this.strategies;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Bytecode getBytecode() {
        return this.bytecode;
    }

    public SparqlTraversalSource clone() {
        try {
            SparqlTraversalSource clone = (SparqlTraversalSource)super.clone();
            clone.strategies = this.strategies.clone();
            clone.bytecode = this.bytecode.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public SparqlTraversalSource withStrategies(TraversalStrategy ... traversalStrategies) {
        return (SparqlTraversalSource)super.withStrategies(traversalStrategies);
    }

    public SparqlTraversalSource withoutStrategies(Class<? extends TraversalStrategy> ... traversalStrategyClasses) {
        return (SparqlTraversalSource)super.withoutStrategies((Class[])traversalStrategyClasses);
    }

    public SparqlTraversalSource withRemote(Configuration conf) {
        return (SparqlTraversalSource)super.withRemote(conf);
    }

    public SparqlTraversalSource withRemote(String configFile) throws Exception {
        return (SparqlTraversalSource)super.withRemote(configFile);
    }

    public SparqlTraversalSource withRemote(RemoteConnection connection) {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection = connection;
        SparqlTraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(new TraversalStrategy[]{new RemoteStrategy(connection)});
        return clone;
    }

    public <S> SparqlTraversal<S, ?> sparql(String query) {
        SparqlTraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(new TraversalStrategy[]{SparqlStrategy.instance()});
        clone.bytecode.addStep("inject", new Object[]{query});
        DefaultSparqlTraversal traversal = new DefaultSparqlTraversal(clone);
        return traversal.addStep((Step)new InjectStep(traversal, (Object[])new String[]{query}));
    }

    public Transaction tx() {
        return this.graph.tx();
    }

    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public String toString() {
        return StringFactory.traversalSourceString((TraversalSource)this);
    }
}

