/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io.gryo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.python.PythonBroadcast;
import org.apache.spark.broadcast.TorrentBroadcast;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.scheduler.CompressedMapStatus;
import org.apache.spark.scheduler.HighlyCompressedMapStatus;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.collection.CompactBuffer;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HadoopPools;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.MessagePayload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.ViewIncomingPayload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.ViewOutgoingPayload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.ViewPayload;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.CompactBufferSerializer;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.GryoSerializerInstance;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.ObjectWritableSerializer;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.Tuple2Serializer;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.Tuple3Serializer;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.VertexWritableSerializer;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.WrappedArraySerializer;
import org.apache.tinkerpop.gremlin.structure.io.AbstractIoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoPool;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.apache.tinkerpop.shaded.kryo.serializers.ExternalizableSerializer;
import org.apache.tinkerpop.shaded.kryo.serializers.JavaSerializer;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.mutable.WrappedArray;
import scala.runtime.BoxedUnit;

public final class GryoSerializer
extends Serializer
implements Serializable {
    private final int bufferSize;
    private final int maxBufferSize;
    private final boolean referenceTracking;
    private final boolean registrationRequired;

    public GryoSerializer(SparkConf sparkConfiguration) {
        long bufferSizeKb = sparkConfiguration.getSizeAsKb("spark.kryoserializer.buffer", "64k");
        long maxBufferSizeMb = sparkConfiguration.getSizeAsMb("spark.kryoserializer.buffer.max", "64m");
        this.referenceTracking = sparkConfiguration.getBoolean("spark.kryo.referenceTracking", true);
        this.registrationRequired = sparkConfiguration.getBoolean("spark.kryo.registrationRequired", false);
        if (bufferSizeKb >= ByteUnit.GiB.toKiB(2L)) {
            throw new IllegalArgumentException("spark.kryoserializer.buffer must be less than 2048 mb, got: " + bufferSizeKb + " mb.");
        }
        this.bufferSize = (int)ByteUnit.KiB.toBytes(bufferSizeKb);
        if (maxBufferSizeMb >= ByteUnit.GiB.toMiB(2L)) {
            throw new IllegalArgumentException("spark.kryoserializer.buffer.max must be less than 2048 mb, got: " + maxBufferSizeMb + " mb.");
        }
        this.maxBufferSize = (int)ByteUnit.MiB.toBytes(maxBufferSizeMb);
        ArrayList<String> ioRegistries = new ArrayList<String>();
        ioRegistries.addAll(GryoSerializer.makeApacheConfiguration(sparkConfiguration).getList("gremlin.io.registry", Collections.emptyList()));
        ioRegistries.add(SparkIoRegistry.class.getCanonicalName().replace("." + SparkIoRegistry.class.getSimpleName(), "$" + SparkIoRegistry.class.getSimpleName()));
        HadoopPools.initialize((GryoPool)GryoPool.build().version(GryoVersion.valueOf((String)sparkConfiguration.get("gremlin.io.gryo.version", GryoPool.CONFIG_IO_GRYO_POOL_VERSION_DEFAULT.name()))).poolSize(sparkConfiguration.getInt("gremlin.io.gryo.poolSize", 256)).ioRegistries(ioRegistries).initializeMapper(builder -> builder.referenceTracking(this.referenceTracking).registrationRequired(this.registrationRequired)).create());
    }

    public Output newOutput() {
        return new Output(this.bufferSize, this.maxBufferSize);
    }

    public GryoPool getGryoPool() {
        return HadoopPools.getGryoPool();
    }

    public SerializerInstance newInstance() {
        return new GryoSerializerInstance(this);
    }

    private static Configuration makeApacheConfiguration(SparkConf sparkConfiguration) {
        BaseConfiguration apacheConfiguration = new BaseConfiguration();
        for (Tuple2 tuple : sparkConfiguration.getAll()) {
            apacheConfiguration.setProperty((String)tuple._1(), tuple._2());
        }
        return apacheConfiguration;
    }

    public static class SparkIoRegistry
    extends AbstractIoRegistry {
        private static final SparkIoRegistry INSTANCE = new SparkIoRegistry();

        private SparkIoRegistry() {
            try {
                super.register(GryoIo.class, Tuple2.class, new Tuple2Serializer());
                super.register(GryoIo.class, Tuple2[].class, null);
                super.register(GryoIo.class, Tuple3.class, new Tuple3Serializer());
                super.register(GryoIo.class, Tuple3[].class, null);
                super.register(GryoIo.class, CompactBuffer.class, new CompactBufferSerializer());
                super.register(GryoIo.class, CompactBuffer[].class, null);
                super.register(GryoIo.class, CompressedMapStatus.class, null);
                super.register(GryoIo.class, BlockManagerId.class, null);
                super.register(GryoIo.class, HighlyCompressedMapStatus.class, (Object)new ExternalizableSerializer());
                super.register(GryoIo.class, TorrentBroadcast.class, null);
                super.register(GryoIo.class, PythonBroadcast.class, null);
                super.register(GryoIo.class, BoxedUnit.class, null);
                super.register(GryoIo.class, Class.forName("scala.reflect.ManifestFactory$AnyManifest"), (Object)new JavaSerializer());
                super.register(GryoIo.class, Class.forName("scala.reflect.ClassTag$GenericClassTag"), (Object)new JavaSerializer());
                super.register(GryoIo.class, Class.forName("org.apache.spark.internal.io.FileCommitProtocol$TaskCommitMessage"), (Object)new JavaSerializer());
                super.register(GryoIo.class, Class.forName("org.apache.spark.internal.io.FileCommitProtocol$EmptyTaskCommitMessage$"), (Object)new JavaSerializer());
                super.register(GryoIo.class, Class.forName("scala.collection.immutable.Map$EmptyMap$"), (Object)new JavaSerializer());
                super.register(GryoIo.class, Class.forName("scala.collection.immutable.Map"), (Object)new JavaSerializer());
                super.register(GryoIo.class, Class.forName("scala.None$"), (Object)new JavaSerializer());
                super.register(GryoIo.class, Class.forName("scala.Some$"), (Object)new JavaSerializer());
                super.register(GryoIo.class, Class.forName("scala.Some"), (Object)new JavaSerializer());
                super.register(GryoIo.class, WrappedArray.ofRef.class, new WrappedArraySerializer());
                super.register(GryoIo.class, MessagePayload.class, null);
                super.register(GryoIo.class, ViewIncomingPayload.class, null);
                super.register(GryoIo.class, ViewOutgoingPayload.class, null);
                super.register(GryoIo.class, ViewPayload.class, null);
                super.register(GryoIo.class, SerializableConfiguration.class, (Object)new JavaSerializer());
                super.register(GryoIo.class, VertexWritable.class, (Object)new VertexWritableSerializer());
                super.register(GryoIo.class, ObjectWritable.class, new ObjectWritableSerializer());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public static SparkIoRegistry instance() {
            return INSTANCE;
        }
    }
}

