/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io.gryo;

import java.io.OutputStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.GryoSerializerInstance;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import scala.reflect.ClassTag;

public final class GryoSerializationStream
extends SerializationStream {
    private final Output output;
    private final GryoSerializerInstance gryoSerializer;

    public GryoSerializationStream(GryoSerializerInstance gryoSerializer, OutputStream outputStream) {
        this.output = new Output(outputStream);
        this.gryoSerializer = gryoSerializer;
    }

    public <T> SerializationStream writeObject(T t, ClassTag<T> classTag) {
        this.gryoSerializer.getGryoPool().writeWithKryo(kryo -> kryo.writeClassAndObject(this.output, t));
        return this;
    }

    public void flush() {
        this.output.flush();
    }

    public void close() {
        this.output.close();
    }
}

