/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class Spark {
    private static SparkContext CONTEXT;
    private static final Map<String, RDD<?>> NAME_TO_RDD;

    private Spark() {
    }

    public static SparkContext create(SparkConf sparkConf) {
        if (null == CONTEXT || CONTEXT.isStopped()) {
            sparkConf.setAppName("Apache TinkerPop's Spark-Gremlin");
            CONTEXT = SparkContext.getOrCreate((SparkConf)sparkConf);
        }
        return CONTEXT;
    }

    public static SparkContext create(org.apache.hadoop.conf.Configuration hadoopConfiguration) {
        SparkConf sparkConfiguration = new SparkConf();
        hadoopConfiguration.forEach(entry -> sparkConfiguration.set((String)entry.getKey(), (String)entry.getValue()));
        return Spark.create(sparkConfiguration);
    }

    public static SparkContext create(Configuration configuration) {
        SparkConf sparkConf = new SparkConf();
        configuration.getKeys().forEachRemaining(key -> sparkConf.set(key, configuration.getProperty(key).toString()));
        return Spark.create(sparkConf);
    }

    public static SparkContext create(String master) {
        SparkConf sparkConf = new SparkConf();
        sparkConf.setMaster(master);
        return Spark.create(sparkConf);
    }

    public static SparkContext create(SparkContext sparkContext) {
        if (null != CONTEXT && !CONTEXT.isStopped() && sparkContext != CONTEXT && !sparkContext.getConf().getBoolean("spark.driver.allowMultipleContexts", false)) {
            throw new IllegalStateException("Active Spark context exists. Call Spark.close() to close it before creating a new one");
        }
        CONTEXT = sparkContext;
        return CONTEXT;
    }

    public static SparkContext recreateStopped() {
        if (null == CONTEXT) {
            throw new IllegalStateException("The Spark context has not been created.");
        }
        if (!CONTEXT.isStopped()) {
            throw new IllegalStateException("The Spark context is not stopped.");
        }
        CONTEXT = SparkContext.getOrCreate((SparkConf)CONTEXT.getConf());
        return CONTEXT;
    }

    public static SparkContext getContext() {
        if (null != CONTEXT && CONTEXT.isStopped()) {
            Spark.recreateStopped();
        }
        return CONTEXT;
    }

    public static void refresh() {
        if (null == CONTEXT) {
            throw new IllegalStateException("The Spark context has not been created.");
        }
        if (CONTEXT.isStopped()) {
            Spark.recreateStopped();
        }
        HashSet<String> keepNames = new HashSet<String>();
        for (RDD rdd : JavaConversions.asJavaIterable((Iterable)CONTEXT.persistentRdds().values())) {
            if (null == rdd.name()) continue;
            keepNames.add(rdd.name());
            NAME_TO_RDD.put(rdd.name(), rdd);
        }
        NAME_TO_RDD.keySet().stream().filter(key -> !keepNames.contains(key)).collect(Collectors.toList()).forEach(NAME_TO_RDD::remove);
    }

    public static RDD<?> getRDD(String name) {
        Spark.refresh();
        if (!NAME_TO_RDD.containsKey(name)) {
            throw new IllegalArgumentException("The named RDD does not exist in the Spark context: " + name);
        }
        return NAME_TO_RDD.get(name);
    }

    public static boolean hasRDD(String name) {
        Spark.refresh();
        return NAME_TO_RDD.containsKey(name);
    }

    public static List<RDD<?>> getRDDs() {
        Spark.refresh();
        return new ArrayList(NAME_TO_RDD.values());
    }

    public static void removeRDD(String name) {
        if (null == name) {
            return;
        }
        Spark.refresh();
        RDD<?> rdd = NAME_TO_RDD.remove(name);
        if (null != rdd) {
            rdd.unpersist(true);
        }
    }

    public static void close() {
        NAME_TO_RDD.clear();
        if (null != CONTEXT) {
            CONTEXT.stop();
        }
        CONTEXT = null;
    }

    static {
        NAME_TO_RDD = new ConcurrentHashMap();
    }
}

