/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io.gryo;

import java.util.Collections;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.spark.SerializableWritable;
import org.apache.spark.SparkConf;
import org.apache.spark.api.python.PythonBroadcast;
import org.apache.spark.broadcast.HttpBroadcast;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.scheduler.CompressedMapStatus;
import org.apache.spark.scheduler.HighlyCompressedMapStatus;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.collection.CompactBuffer;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.MessagePayload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.ViewIncomingPayload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.ViewOutgoingPayload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.ViewPayload;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.GryoSerializerInstance;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.WrappedArraySerializer;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoPool;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.apache.tinkerpop.shaded.kryo.serializers.JavaSerializer;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.mutable.WrappedArray;
import scala.runtime.BoxedUnit;

public final class GryoSerializer
extends org.apache.spark.serializer.Serializer {
    private final int bufferSize;
    private final int maxBufferSize;
    private final GryoPool gryoPool;

    public GryoSerializer(SparkConf sparkConfiguration) {
        long bufferSizeKb = sparkConfiguration.getSizeAsKb("spark.kryoserializer.buffer", "64k");
        long maxBufferSizeMb = sparkConfiguration.getSizeAsMb("spark.kryoserializer.buffer.max", "64m");
        boolean referenceTracking = sparkConfiguration.getBoolean("spark.kryo.referenceTracking", true);
        boolean registrationRequired = sparkConfiguration.getBoolean("spark.kryo.registrationRequired", false);
        if (bufferSizeKb >= ByteUnit.GiB.toKiB(2L)) {
            throw new IllegalArgumentException("spark.kryoserializer.buffer must be less than 2048 mb, got: " + bufferSizeKb + " mb.");
        }
        this.bufferSize = (int)ByteUnit.KiB.toBytes(bufferSizeKb);
        if (maxBufferSizeMb >= ByteUnit.GiB.toMiB(2L)) {
            throw new IllegalArgumentException("spark.kryoserializer.buffer.max must be less than 2048 mb, got: " + maxBufferSizeMb + " mb.");
        }
        this.maxBufferSize = (int)ByteUnit.MiB.toBytes(maxBufferSizeMb);
        this.gryoPool = GryoPool.build().poolSize(sparkConfiguration.getInt("gremlin.io.gryo.poolSize", 256)).ioRegistries(GryoSerializer.makeApacheConfiguration(sparkConfiguration).getList("gremlin.io.registry", Collections.emptyList())).initializeMapper(builder -> {
            try {
                builder.addCustom(SerializableWritable.class, (Serializer)new JavaSerializer()).addCustom(Tuple2.class, (Serializer)new JavaSerializer()).addCustom(Tuple2[].class, (Serializer)new JavaSerializer()).addCustom(Tuple3.class, (Serializer)new JavaSerializer()).addCustom(Tuple3[].class, (Serializer)new JavaSerializer()).addCustom(CompactBuffer.class, (Serializer)new JavaSerializer()).addCustom(CompactBuffer[].class, (Serializer)new JavaSerializer()).addCustom(CompressedMapStatus.class, (Serializer)new JavaSerializer()).addCustom(HighlyCompressedMapStatus.class, (Serializer)new JavaSerializer()).addCustom(HttpBroadcast.class, (Serializer)new JavaSerializer()).addCustom(PythonBroadcast.class, (Serializer)new JavaSerializer()).addCustom(BoxedUnit.class, (Serializer)new JavaSerializer()).addCustom(Class.forName("scala.reflect.ClassTag$$anon$1"), (Serializer)new JavaSerializer()).addCustom(WrappedArray.ofRef.class, new WrappedArraySerializer()).addCustom(new Class[]{MessagePayload.class}).addCustom(new Class[]{ViewIncomingPayload.class}).addCustom(new Class[]{ViewOutgoingPayload.class}).addCustom(new Class[]{ViewPayload.class}).addCustom(SerializableConfiguration.class, (Serializer)new JavaSerializer()).addCustom(VertexWritable.class, (Serializer)new JavaSerializer()).addCustom(ObjectWritable.class, (Serializer)new JavaSerializer()).referenceTracking(referenceTracking).registrationRequired(registrationRequired);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }).create();
    }

    public Output newOutput() {
        return new Output(this.bufferSize, this.maxBufferSize);
    }

    public GryoPool getGryoPool() {
        return this.gryoPool;
    }

    public SerializerInstance newInstance() {
        return new GryoSerializerInstance(this);
    }

    private static Configuration makeApacheConfiguration(SparkConf sparkConfiguration) {
        BaseConfiguration apacheConfiguration = new BaseConfiguration();
        apacheConfiguration.setDelimiterParsingDisabled(true);
        for (Tuple2 tuple : sparkConfiguration.getAll()) {
            apacheConfiguration.setProperty((String)tuple._1(), tuple._2());
        }
        return apacheConfiguration;
    }
}

