/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.structure.trait;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.neo4j.process.traversal.LabelP;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraph;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jHelper;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jProperty;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jVertex;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jVertexProperty;
import org.apache.tinkerpop.gremlin.neo4j.structure.trait.Neo4jTrait;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedGraph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.neo4j.tinkerpop.api.Neo4jDirection;
import org.neo4j.tinkerpop.api.Neo4jEntity;
import org.neo4j.tinkerpop.api.Neo4jGraphAPI;
import org.neo4j.tinkerpop.api.Neo4jNode;
import org.neo4j.tinkerpop.api.Neo4jRelationship;

@Deprecated
public final class MultiMetaNeo4jTrait
implements Neo4jTrait {
    private static final MultiMetaNeo4jTrait INSTANCE = new MultiMetaNeo4jTrait();
    public static final String VERTEX_PROPERTY_LABEL = "vertexProperty";
    public static final String VERTEX_PROPERTY_TOKEN = Graph.Hidden.hide((String)"vertexProperty");
    private static final Predicate<Neo4jNode> NODE_PREDICATE = node -> !node.hasLabel(VERTEX_PROPERTY_LABEL);
    private static final Predicate<Neo4jRelationship> RELATIONSHIP_PREDICATE = relationship -> !Graph.Hidden.isHidden((String)relationship.type());

    private MultiMetaNeo4jTrait() {
    }

    public static MultiMetaNeo4jTrait instance() {
        return INSTANCE;
    }

    @Override
    public Predicate<Neo4jNode> getNodePredicate() {
        return NODE_PREDICATE;
    }

    @Override
    public Predicate<Neo4jRelationship> getRelationshipPredicate() {
        return RELATIONSHIP_PREDICATE;
    }

    @Override
    public void removeVertex(Neo4jVertex vertex) {
        block5: {
            try {
                Neo4jNode node = vertex.getBaseVertex();
                for (Neo4jRelationship relationship : node.relationships(Neo4jDirection.BOTH, new String[0])) {
                    Neo4jNode otherNode = relationship.other(node);
                    if (otherNode.hasLabel(VERTEX_PROPERTY_LABEL)) {
                        otherNode.delete();
                    }
                    relationship.delete();
                }
                node.delete();
            }
            catch (IllegalStateException node) {
            }
            catch (RuntimeException ex) {
                if (Neo4jHelper.isNotFound(ex)) break block5;
                throw ex;
            }
        }
    }

    @Override
    public <V> VertexProperty<V> getVertexProperty(Neo4jVertex vertex, String key) {
        Neo4jNode node = vertex.getBaseVertex();
        if (node.hasProperty(key)) {
            if (node.getProperty(key).equals(VERTEX_PROPERTY_TOKEN)) {
                if (node.degree(Neo4jDirection.OUTGOING, Graph.Hidden.hide((String)key)) > 1) {
                    throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)key);
                }
                return new Neo4jVertexProperty(vertex, ((Neo4jRelationship)node.relationships(Neo4jDirection.OUTGOING, new String[]{Graph.Hidden.hide((String)key)}).iterator().next()).end());
            }
            return new Neo4jVertexProperty<Object>(vertex, key, node.getProperty(key));
        }
        return VertexProperty.empty();
    }

    @Override
    public <V> Iterator<VertexProperty<V>> getVertexProperties(Neo4jVertex vertex, String ... keys) {
        if (Neo4jHelper.isDeleted(vertex.getBaseVertex())) {
            return Collections.emptyIterator();
        }
        return IteratorUtils.stream((Iterable)vertex.getBaseVertex().getKeys()).filter(key -> ElementHelper.keyExists((String)key, (String[])keys)).flatMap(key -> {
            if (vertex.getBaseVertex().getProperty(key).equals(VERTEX_PROPERTY_TOKEN)) {
                return IteratorUtils.stream((Iterable)vertex.getBaseVertex().relationships(Neo4jDirection.OUTGOING, new String[]{Graph.Hidden.hide((String)key)})).map(relationship -> new Neo4jVertexProperty(vertex, relationship.end()));
            }
            return Stream.of(new Neo4jVertexProperty<Object>(vertex, (String)key, vertex.getBaseVertex().getProperty(key)));
        }).iterator();
    }

    @Override
    public <V> VertexProperty<V> setVertexProperty(Neo4jVertex vertex, VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        try {
            Optional optionalVertexProperty = ElementHelper.stageVertexProperty((Vertex)vertex, (VertexProperty.Cardinality)cardinality, (String)key, value, (Object[])keyValues);
            if (optionalVertexProperty.isPresent()) {
                return (VertexProperty)optionalVertexProperty.get();
            }
            Neo4jNode node = vertex.getBaseVertex();
            Neo4jGraphAPI graph = ((Neo4jGraph)vertex.graph()).getBaseGraph();
            String prefixedKey = Graph.Hidden.hide((String)key);
            if (node.hasProperty(key)) {
                if (node.getProperty(key).equals(VERTEX_PROPERTY_TOKEN)) {
                    Neo4jNode vertexPropertyNode = graph.createNode(new String[]{VERTEX_PROPERTY_LABEL, key});
                    vertexPropertyNode.setProperty(T.key.getAccessor(), (Object)key);
                    vertexPropertyNode.setProperty(T.value.getAccessor(), value);
                    vertexPropertyNode.setProperty(key, value);
                    node.connectTo(vertexPropertyNode, prefixedKey);
                    Neo4jVertexProperty<V> property = new Neo4jVertexProperty<V>(vertex, key, value, vertexPropertyNode);
                    ElementHelper.attachProperties(property, (Object[])keyValues);
                    return property;
                }
                Neo4jNode vertexPropertyNode = graph.createNode(new String[]{VERTEX_PROPERTY_LABEL, key});
                Object tempValue = node.removeProperty(key);
                vertexPropertyNode.setProperty(T.key.getAccessor(), (Object)key);
                vertexPropertyNode.setProperty(T.value.getAccessor(), tempValue);
                vertexPropertyNode.setProperty(key, tempValue);
                node.connectTo(vertexPropertyNode, prefixedKey);
                node.setProperty(key, (Object)VERTEX_PROPERTY_TOKEN);
                vertexPropertyNode = graph.createNode(new String[]{VERTEX_PROPERTY_LABEL, key});
                vertexPropertyNode.setProperty(T.key.getAccessor(), (Object)key);
                vertexPropertyNode.setProperty(T.value.getAccessor(), value);
                vertexPropertyNode.setProperty(key, value);
                node.connectTo(vertexPropertyNode, prefixedKey);
                Neo4jVertexProperty<V> property = new Neo4jVertexProperty<V>(vertex, key, value, vertexPropertyNode);
                ElementHelper.attachProperties(property, (Object[])keyValues);
                return property;
            }
            node.setProperty(key, value);
            Neo4jVertexProperty<V> property = new Neo4jVertexProperty<V>(vertex, key, value);
            ElementHelper.attachProperties(property, (Object[])keyValues);
            return property;
        }
        catch (IllegalArgumentException iae) {
            throw Property.Exceptions.dataTypeOfPropertyValueNotSupported(value, (Exception)iae);
        }
    }

    @Override
    public VertexProperty.Cardinality getCardinality(String key) {
        return VertexProperty.Cardinality.list;
    }

    @Override
    public boolean supportsMultiProperties() {
        return true;
    }

    @Override
    public boolean supportsMetaProperties() {
        return true;
    }

    @Override
    public void removeVertexProperty(Neo4jVertexProperty vertexProperty) {
        Neo4jNode vertexPropertyNode = Neo4jHelper.getVertexPropertyNode(vertexProperty);
        Neo4jNode vertexNode = ((Neo4jVertex)vertexProperty.element()).getBaseVertex();
        if (null == vertexPropertyNode) {
            if (vertexNode.degree(Neo4jDirection.OUTGOING, Graph.Hidden.hide((String)vertexProperty.key())) == 0 && vertexNode.hasProperty(vertexProperty.key())) {
                vertexNode.removeProperty(vertexProperty.key());
            }
        } else {
            vertexPropertyNode.relationships(Neo4jDirection.BOTH, new String[0]).forEach(Neo4jEntity::delete);
            vertexPropertyNode.delete();
            if (vertexNode.degree(Neo4jDirection.OUTGOING, Graph.Hidden.hide((String)vertexProperty.key())) == 0 && vertexNode.hasProperty(vertexProperty.key())) {
                vertexNode.removeProperty(vertexProperty.key());
            }
        }
    }

    @Override
    public <V> Property<V> setProperty(Neo4jVertexProperty vertexProperty, String key, V value) {
        Neo4jNode vertexPropertyNode = Neo4jHelper.getVertexPropertyNode(vertexProperty);
        if (null != vertexPropertyNode) {
            vertexPropertyNode.setProperty(key, value);
            return new Neo4jProperty<V>((Element)vertexProperty, key, value);
        }
        Neo4jNode vertexNode = ((Neo4jVertex)vertexProperty.element()).getBaseVertex();
        Neo4jNode newVertexPropertyNode = ((Neo4jGraphAPI)((WrappedGraph)vertexProperty.element().graph()).getBaseGraph()).createNode(new String[]{VERTEX_PROPERTY_LABEL, vertexProperty.label()});
        newVertexPropertyNode.setProperty(T.key.getAccessor(), (Object)vertexProperty.key());
        newVertexPropertyNode.setProperty(T.value.getAccessor(), vertexProperty.value());
        newVertexPropertyNode.setProperty(vertexProperty.key(), vertexProperty.value());
        newVertexPropertyNode.setProperty(key, value);
        vertexNode.connectTo(newVertexPropertyNode, Graph.Hidden.hide((String)vertexProperty.key()));
        vertexNode.setProperty(vertexProperty.key(), (Object)VERTEX_PROPERTY_TOKEN);
        Neo4jHelper.setVertexPropertyNode(vertexProperty, newVertexPropertyNode);
        return new Neo4jProperty<V>((Element)vertexProperty, key, value);
    }

    @Override
    public <V> Property<V> getProperty(Neo4jVertexProperty vertexProperty, String key) {
        Neo4jNode vertexPropertyNode = Neo4jHelper.getVertexPropertyNode(vertexProperty);
        if (null != vertexPropertyNode && vertexPropertyNode.hasProperty(key)) {
            return new Neo4jProperty<Object>((Element)vertexProperty, key, vertexPropertyNode.getProperty(key));
        }
        return Property.empty();
    }

    @Override
    public <V> Iterator<Property<V>> getProperties(Neo4jVertexProperty vertexProperty, String ... keys) {
        Neo4jNode vertexPropertyNode = Neo4jHelper.getVertexPropertyNode(vertexProperty);
        if (null == vertexPropertyNode) {
            return Collections.emptyIterator();
        }
        return IteratorUtils.stream((Iterable)vertexPropertyNode.getKeys()).filter(key -> ElementHelper.keyExists((String)key, (String[])keys)).filter(key -> !key.equals(vertexProperty.key())).map(key -> new Neo4jProperty<Object>((Element)vertexProperty, (String)key, vertexPropertyNode.getProperty(key))).iterator();
    }

    @Override
    public Iterator<Vertex> lookupVertices(Neo4jGraph graph, List<HasContainer> hasContainers, Object ... ids) {
        if (ids.length > 0) {
            return IteratorUtils.filter(graph.vertices(ids), vertex -> HasContainer.testAll((Object)vertex, (List)hasContainers));
        }
        graph.tx().readWrite();
        Optional<String> label = hasContainers.stream().filter(hasContainer -> hasContainer.getKey().equals(T.label.getAccessor())).filter(hasContainer -> Compare.eq == hasContainer.getBiPredicate()).map(hasContainer -> (String)hasContainer.getValue()).findAny();
        if (!label.isPresent()) {
            label = hasContainers.stream().filter(hasContainer -> hasContainer.getKey().equals(T.label.getAccessor())).filter(hasContainer -> hasContainer.getPredicate() instanceof LabelP).map(hasContainer -> (String)hasContainer.getValue()).findAny();
        }
        if (label.isPresent()) {
            for (HasContainer hasContainer2 : hasContainers) {
                if (Compare.eq != hasContainer2.getBiPredicate() || !graph.getBaseGraph().hasSchemaIndex(label.get(), hasContainer2.getKey())) continue;
                return Stream.concat(IteratorUtils.stream((Iterable)graph.getBaseGraph().findNodes(label.get(), hasContainer2.getKey(), hasContainer2.getValue())).filter(this.getNodePredicate()).map(node -> new Neo4jVertex((Neo4jNode)node, graph)).filter(vertex -> HasContainer.testAll((Object)vertex, (List)hasContainers)), IteratorUtils.stream((Iterable)graph.getBaseGraph().findNodes(VERTEX_PROPERTY_LABEL, hasContainer2.getKey(), hasContainer2.getValue())).map(node -> ((Neo4jRelationship)node.relationships(Neo4jDirection.INCOMING, new String[0]).iterator().next()).start()).map(node -> new Neo4jVertex((Neo4jNode)node, graph)).filter(vertex -> HasContainer.testAll((Object)vertex, (List)hasContainers))).iterator();
            }
            return IteratorUtils.stream((Iterable)graph.getBaseGraph().findNodes(label.get())).filter(this.getNodePredicate()).map(node -> new Neo4jVertex((Neo4jNode)node, graph)).filter(vertex -> HasContainer.testAll((Object)vertex, (List)hasContainers)).iterator();
        }
        return IteratorUtils.filter(graph.vertices(new Object[0]), vertex -> HasContainer.testAll((Object)vertex, (List)hasContainers));
    }
}

