/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.structure;

import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jElement;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraph;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jVertex;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jVertexProperty;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.neo4j.tinkerpop.api.Neo4jNode;

public final class Neo4jProperty<V>
implements Property<V> {
    protected final Element element;
    protected final String key;
    protected final Neo4jGraph graph;
    protected V value;
    protected boolean removed = false;

    public Neo4jProperty(Element element, String key, V value) {
        this.element = element;
        this.key = key;
        this.value = value;
        this.graph = element instanceof Neo4jVertexProperty ? ((Neo4jVertex)((Neo4jVertexProperty)element).element()).graph : ((Neo4jElement)element).graph;
    }

    public Element element() {
        return this.element;
    }

    public void remove() {
        Neo4jNode entity;
        if (this.removed) {
            return;
        }
        this.removed = true;
        this.graph.tx().readWrite();
        Object object = entity = this.element instanceof Neo4jVertexProperty ? ((Neo4jVertexProperty)this.element).vertexPropertyNode : ((Neo4jElement)this.element).getBaseElement();
        if (entity.hasProperty(this.key)) {
            entity.removeProperty(this.key);
        }
    }

    public String key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public boolean isPresent() {
        return null != this.value;
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((Property)this, (Object)object);
    }

    public int hashCode() {
        return ElementHelper.hashCode((Property)this);
    }
}

