/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.structure;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.tinkerpop.gremlin.neo4j.process.traversal.step.sideEffect.CypherStartStep;
import org.apache.tinkerpop.gremlin.neo4j.process.traversal.strategy.optimization.Neo4jGraphStepStrategy;
import org.apache.tinkerpop.gremlin.neo4j.process.util.Neo4jCypherIterator;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jEdge;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraphVariables;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jHelper;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jVertex;
import org.apache.tinkerpop.gremlin.neo4j.structure.trait.MultiMetaNeo4jTrait;
import org.apache.tinkerpop.gremlin.neo4j.structure.trait.Neo4jTrait;
import org.apache.tinkerpop.gremlin.neo4j.structure.trait.NoMultiNoMetaNeo4jTrait;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.AbstractThreadLocalTransaction;
import org.apache.tinkerpop.gremlin.structure.util.AbstractTransaction;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedGraph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.neo4j.tinkerpop.api.Neo4jFactory;
import org.neo4j.tinkerpop.api.Neo4jGraphAPI;
import org.neo4j.tinkerpop.api.Neo4jNode;
import org.neo4j.tinkerpop.api.Neo4jRelationship;
import org.neo4j.tinkerpop.api.Neo4jTx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureIntegrateSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructurePerformanceSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessPerformanceSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.GroovyProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.groovy.GroovyEnvironmentSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.groovy.GroovyEnvironmentIntegrateSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.groovy.GroovyEnvironmentPerformanceSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.neo4j.NativeNeo4jSuite")})
public final class Neo4jGraph
implements Graph,
WrappedGraph<Neo4jGraphAPI> {
    public static final Logger LOGGER = LoggerFactory.getLogger(Neo4jGraph.class);
    private static final Configuration EMPTY_CONFIGURATION;
    protected Graph.Features features = new Neo4jGraphFeatures();
    protected Neo4jGraphAPI baseGraph;
    protected BaseConfiguration configuration = new BaseConfiguration();
    public static final String CONFIG_DIRECTORY = "gremlin.neo4j.directory";
    public static final String CONFIG_CONF = "gremlin.neo4j.conf";
    public static final String CONFIG_META_PROPERTIES = "gremlin.neo4j.metaProperties";
    public static final String CONFIG_MULTI_PROPERTIES = "gremlin.neo4j.multiProperties";
    private final Neo4jTransaction neo4jTransaction = new Neo4jTransaction();
    private Neo4jGraphVariables neo4jGraphVariables;
    protected Neo4jTrait trait;

    private void initialize(Neo4jGraphAPI baseGraph, Configuration configuration) {
        this.configuration.copy(configuration);
        this.baseGraph = baseGraph;
        this.neo4jGraphVariables = new Neo4jGraphVariables(this);
        this.tx().readWrite();
        Optional hasMultiProperties = this.neo4jGraphVariables.get(Graph.Hidden.hide((String)CONFIG_MULTI_PROPERTIES));
        Optional hasMetaProperties = this.neo4jGraphVariables.get(Graph.Hidden.hide((String)CONFIG_META_PROPERTIES));
        boolean supportsMetaProperties = hasMetaProperties.orElse(this.configuration.getBoolean(CONFIG_META_PROPERTIES, false));
        boolean supportsMultiProperties = hasMultiProperties.orElse(this.configuration.getBoolean(CONFIG_MULTI_PROPERTIES, false));
        if (supportsMultiProperties != supportsMetaProperties) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " currently supports either both meta-properties and multi-properties or neither");
        }
        if (!hasMultiProperties.isPresent()) {
            this.neo4jGraphVariables.set(Graph.Hidden.hide((String)CONFIG_MULTI_PROPERTIES), supportsMultiProperties);
        }
        if (!hasMetaProperties.isPresent()) {
            this.neo4jGraphVariables.set(Graph.Hidden.hide((String)CONFIG_META_PROPERTIES), supportsMetaProperties);
        }
        Neo4jTrait neo4jTrait = this.trait = supportsMultiProperties ? MultiMetaNeo4jTrait.instance() : NoMultiNoMetaNeo4jTrait.instance();
        if (supportsMultiProperties) {
            LOGGER.warn(this.getClass().getSimpleName() + " multi/meta-properties feature is considered experimental and should not be used in a production setting until this warning is removed");
        }
        this.tx().commit();
    }

    protected Neo4jGraph(Neo4jGraphAPI baseGraph, Configuration configuration) {
        this.initialize(baseGraph, configuration);
    }

    protected Neo4jGraph(Configuration configuration) {
        this.configuration.copy(configuration);
        String directory = this.configuration.getString(CONFIG_DIRECTORY);
        Map neo4jSpecificConfig = ConfigurationConverter.getMap((Configuration)this.configuration.subset(CONFIG_CONF));
        this.baseGraph = Neo4jFactory.Builder.open((String)directory, (Map)neo4jSpecificConfig);
        this.initialize(this.baseGraph, configuration);
    }

    public static Neo4jGraph open(Configuration configuration) {
        if (null == configuration) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"configuration");
        }
        if (!configuration.containsKey(CONFIG_DIRECTORY)) {
            throw new IllegalArgumentException(String.format("Neo4j configuration requires that the %s be set", CONFIG_DIRECTORY));
        }
        return new Neo4jGraph(configuration);
    }

    public static Neo4jGraph open(String directory) {
        BaseConfiguration config = new BaseConfiguration();
        config.setProperty(CONFIG_DIRECTORY, (Object)directory);
        return Neo4jGraph.open((Configuration)config);
    }

    public static Neo4jGraph open(Neo4jGraphAPI baseGraph) {
        return new Neo4jGraph(baseGraph, EMPTY_CONFIGURATION);
    }

    public Vertex addVertex(Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Vertex.Exceptions.userSuppliedIdsNotSupported();
        }
        this.tx().readWrite();
        Neo4jVertex vertex = new Neo4jVertex(this.baseGraph.createNode(ElementHelper.getLabelValue((Object[])keyValues).orElse("vertex").split("::")), this);
        ElementHelper.attachProperties((Vertex)vertex, (Object[])keyValues);
        return vertex;
    }

    public Iterator<Vertex> vertices(Object ... vertexIds) {
        this.tx().readWrite();
        Predicate<Neo4jNode> nodePredicate = this.trait.getNodePredicate();
        if (0 == vertexIds.length) {
            return IteratorUtils.stream((Iterable)this.getBaseGraph().allNodes()).filter(nodePredicate).map(node -> new Neo4jVertex((Neo4jNode)node, this)).iterator();
        }
        ElementHelper.validateMixedElementIds(Vertex.class, (Object[])vertexIds);
        return Stream.of(vertexIds).map(id -> {
            if (id instanceof Number) {
                return ((Number)id).longValue();
            }
            if (id instanceof String) {
                return Long.valueOf(id.toString());
            }
            if (id instanceof Vertex) {
                return (Long)((Vertex)id).id();
            }
            throw new IllegalArgumentException("Unknown vertex id type: " + id);
        }).flatMap(id -> {
            try {
                return Stream.of(this.baseGraph.getNodeById(id.longValue()));
            }
            catch (RuntimeException e) {
                if (Neo4jHelper.isNotFound(e)) {
                    return Stream.empty();
                }
                throw e;
            }
        }).filter(nodePredicate).map(node -> new Neo4jVertex((Neo4jNode)node, this)).iterator();
    }

    public Iterator<Edge> edges(Object ... edgeIds) {
        this.tx().readWrite();
        Predicate<Neo4jRelationship> relationshipPredicate = this.trait.getRelationshipPredicate();
        if (0 == edgeIds.length) {
            return IteratorUtils.stream((Iterable)this.getBaseGraph().allRelationships()).filter(relationshipPredicate).map(relationship -> new Neo4jEdge((Neo4jRelationship)relationship, this)).iterator();
        }
        ElementHelper.validateMixedElementIds(Edge.class, (Object[])edgeIds);
        return Stream.of(edgeIds).map(id -> {
            if (id instanceof Number) {
                return ((Number)id).longValue();
            }
            if (id instanceof String) {
                return Long.valueOf(id.toString());
            }
            if (id instanceof Edge) {
                return (Long)((Edge)id).id();
            }
            throw new IllegalArgumentException("Unknown edge id type: " + id);
        }).flatMap(id -> {
            try {
                return Stream.of(this.baseGraph.getRelationshipById(id.longValue()));
            }
            catch (RuntimeException e) {
                if (Neo4jHelper.isNotFound(e)) {
                    return Stream.empty();
                }
                throw e;
            }
        }).filter(relationshipPredicate).map(relationship -> new Neo4jEdge((Neo4jRelationship)relationship, this)).iterator();
    }

    public Neo4jTrait getTrait() {
        return this.trait;
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    public GraphComputer compute() {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    public Transaction tx() {
        return this.neo4jTransaction;
    }

    public Graph.Variables variables() {
        return this.neo4jGraphVariables;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public void close() throws Exception {
        this.tx().close();
        if (this.baseGraph != null) {
            this.baseGraph.shutdown();
        }
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.baseGraph.toString());
    }

    public Graph.Features features() {
        return this.features;
    }

    public Neo4jGraphAPI getBaseGraph() {
        return this.baseGraph;
    }

    public <S, E> GraphTraversal<S, E> cypher(String query) {
        return this.cypher(query, Collections.emptyMap());
    }

    public <S, E> GraphTraversal<S, E> cypher(String query, Map<String, Object> parameters) {
        this.tx().readWrite();
        DefaultGraphTraversal traversal = new DefaultGraphTraversal((Graph)this);
        traversal.addStep((Step)new CypherStartStep((Traversal.Admin)traversal, query, new Neo4jCypherIterator(this.baseGraph.execute(query, parameters), this)));
        return traversal;
    }

    static {
        TraversalStrategies.GlobalCache.registerStrategies(Neo4jGraph.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{Neo4jGraphStepStrategy.instance()}));
        EMPTY_CONFIGURATION = new BaseConfiguration(){
            {
                this.setProperty("gremlin.graph", Neo4jGraph.class.getName());
            }
        };
    }

    public class Neo4jGraphFeatures
    implements Graph.Features {
        protected Graph.Features.GraphFeatures graphFeatures = new Neo4jGraphGraphFeatures();
        protected Graph.Features.VertexFeatures vertexFeatures = new Neo4jVertexFeatures();
        protected Graph.Features.EdgeFeatures edgeFeatures = new Neo4jEdgeFeatures();

        public Graph.Features.GraphFeatures graph() {
            return this.graphFeatures;
        }

        public Graph.Features.VertexFeatures vertex() {
            return this.vertexFeatures;
        }

        public Graph.Features.EdgeFeatures edge() {
            return this.edgeFeatures;
        }

        public String toString() {
            return StringFactory.featureString((Graph.Features)this);
        }

        public class Neo4jEdgePropertyFeatures
        implements Graph.Features.EdgePropertyFeatures {
            Neo4jEdgePropertyFeatures() {
            }

            public boolean supportsMapValues() {
                return false;
            }

            public boolean supportsMixedListValues() {
                return false;
            }

            public boolean supportsSerializableValues() {
                return false;
            }

            public boolean supportsUniformListValues() {
                return false;
            }
        }

        public class Neo4jVertexPropertyFeatures
        implements Graph.Features.VertexPropertyFeatures {
            Neo4jVertexPropertyFeatures() {
            }

            public boolean supportsMapValues() {
                return false;
            }

            public boolean supportsMixedListValues() {
                return false;
            }

            public boolean supportsSerializableValues() {
                return false;
            }

            public boolean supportsUniformListValues() {
                return false;
            }

            public boolean supportsUserSuppliedIds() {
                return false;
            }

            public boolean supportsAnyIds() {
                return false;
            }
        }

        public class Neo4jElementFeatures
        implements Graph.Features.ElementFeatures {
            Neo4jElementFeatures() {
            }

            public boolean supportsUserSuppliedIds() {
                return false;
            }

            public boolean supportsStringIds() {
                return false;
            }

            public boolean supportsUuidIds() {
                return false;
            }

            public boolean supportsAnyIds() {
                return false;
            }

            public boolean supportsCustomIds() {
                return false;
            }
        }

        public class Neo4jEdgeFeatures
        extends Neo4jElementFeatures
        implements Graph.Features.EdgeFeatures {
            private final Graph.Features.EdgePropertyFeatures edgePropertyFeatures;

            Neo4jEdgeFeatures() {
                this.edgePropertyFeatures = new Neo4jEdgePropertyFeatures();
            }

            public Graph.Features.EdgePropertyFeatures properties() {
                return this.edgePropertyFeatures;
            }
        }

        public class Neo4jVertexFeatures
        extends Neo4jElementFeatures
        implements Graph.Features.VertexFeatures {
            private final Graph.Features.VertexPropertyFeatures vertexPropertyFeatures;

            protected Neo4jVertexFeatures() {
                this.vertexPropertyFeatures = new Neo4jVertexPropertyFeatures();
            }

            public Graph.Features.VertexPropertyFeatures properties() {
                return this.vertexPropertyFeatures;
            }

            public boolean supportsMetaProperties() {
                return Neo4jGraph.this.trait.supportsMetaProperties();
            }

            public boolean supportsMultiProperties() {
                return Neo4jGraph.this.trait.supportsMultiProperties();
            }

            @Override
            public boolean supportsUserSuppliedIds() {
                return false;
            }

            public VertexProperty.Cardinality getCardinality(String key) {
                return Neo4jGraph.this.trait.getCardinality(key);
            }
        }

        public class Neo4jGraphGraphFeatures
        implements Graph.Features.GraphFeatures {
            private Graph.Features.VariableFeatures variableFeatures = new Neo4jGraphVariables.Neo4jVariableFeatures();

            Neo4jGraphGraphFeatures() {
            }

            public boolean supportsConcurrentAccess() {
                return false;
            }

            public boolean supportsComputer() {
                return false;
            }

            public Graph.Features.VariableFeatures variables() {
                return this.variableFeatures;
            }

            public boolean supportsThreadedTransactions() {
                return false;
            }
        }
    }

    class Neo4jTransaction
    extends AbstractThreadLocalTransaction {
        protected final ThreadLocal<Neo4jTx> threadLocalTx;

        public Neo4jTransaction() {
            super((Graph)Neo4jGraph.this);
            this.threadLocalTx = ThreadLocal.withInitial(() -> null);
        }

        public void doOpen() {
            this.threadLocalTx.set(Neo4jGraph.this.getBaseGraph().tx());
        }

        public void doCommit() throws AbstractTransaction.TransactionException {
            try (Neo4jTx tx = this.threadLocalTx.get();){
                tx.success();
            }
            catch (Exception ex) {
                throw new AbstractTransaction.TransactionException((Throwable)ex);
            }
            finally {
                this.threadLocalTx.remove();
            }
        }

        public void doRollback() throws AbstractTransaction.TransactionException {
            try (Neo4jTx tx = this.threadLocalTx.get();){
                tx.failure();
            }
            catch (Exception e) {
                throw new AbstractTransaction.TransactionException((Throwable)e);
            }
            finally {
                this.threadLocalTx.remove();
            }
        }

        public boolean isOpen() {
            return this.threadLocalTx.get() != null;
        }
    }
}

