/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.process.traversal.step.sideEffect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraph;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class Neo4jGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements HasContainerHolder {
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();

    public Neo4jGraphStep(GraphStep<S, E> originalGraphStep) {
        super(originalGraphStep.getTraversal(), originalGraphStep.getReturnClass(), originalGraphStep.isStartStep(), originalGraphStep.getIds());
        originalGraphStep.getLabels().forEach(arg_0 -> ((Neo4jGraphStep)this).addLabel(arg_0));
        this.setIteratorSupplier(() -> Vertex.class.isAssignableFrom(this.returnClass) ? this.vertices() : this.edges());
    }

    private Iterator<? extends Edge> edges() {
        return IteratorUtils.filter((Iterator)((Graph)this.getTraversal().getGraph().get()).edges(this.ids), edge -> HasContainer.testAll((Element)edge, this.hasContainers));
    }

    private Iterator<? extends Vertex> vertices() {
        Neo4jGraph graph = (Neo4jGraph)this.getTraversal().getGraph().get();
        return graph.getTrait().lookupVertices(graph, this.hasContainers, this.ids);
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return 0 == this.ids.length ? StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), this.hasContainers}) : StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids), this.hasContainers});
    }

    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    public void addHasContainer(HasContainer hasContainer) {
        if (hasContainer.getPredicate() instanceof AndP) {
            for (P predicate : ((AndP)hasContainer.getPredicate()).getPredicates()) {
                this.addHasContainer(new HasContainer(hasContainer.getKey(), predicate));
            }
        } else {
            this.hasContainers.add(hasContainer);
        }
    }

    public int hashCode() {
        return super.hashCode() ^ this.hasContainers.hashCode();
    }
}

