/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.javatuples.Pair;

public final class HadoopConfiguration
extends AbstractConfiguration
implements Serializable,
Iterable {
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public HadoopConfiguration() {
        super.setDelimiterParsingDisabled(true);
    }

    public HadoopConfiguration(Configuration configuration) {
        this();
        this.copy(configuration);
    }

    protected void addPropertyDirect(String key, Object value) {
        this.properties.put(key, value);
    }

    protected void clearPropertyDirect(String key) {
        this.properties.remove(key);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Iterator<String> getKeys() {
        return this.properties.keySet().iterator();
    }

    public <A> Class<A> getGraphReader() {
        try {
            return Class.forName(this.getString("gremlin.hadoop.graphReader"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <A> Class<A> getGraphWriter() {
        try {
            return Class.forName(this.getString("gremlin.hadoop.graphWriter"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getInputLocation() {
        return this.getString("gremlin.hadoop.inputLocation");
    }

    public void setInputLocation(String inputLocation) {
        this.setProperty("gremlin.hadoop.inputLocation", inputLocation);
    }

    public String getOutputLocation() {
        return this.getString("gremlin.hadoop.outputLocation");
    }

    public void setOutputLocation(String outputLocation) {
        this.setProperty("gremlin.hadoop.outputLocation", outputLocation);
    }

    public Iterator iterator() {
        return IteratorUtils.map(this.getKeys(), k -> new Pair(k, this.getProperty((String)k)));
    }
}

