/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.process.computer.traversal.step.sideEffect;

import java.util.List;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONOutputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo.GryoInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo.GryoOutputFormat;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.clone.CloneVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.IO;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.ReadWriting;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class HadoopIoStep
extends VertexProgramStep
implements ReadWriting {
    private Parameters parameters = new Parameters();
    private ReadWriting.Mode mode = ReadWriting.Mode.UNSET;
    private String file;

    public HadoopIoStep(Traversal.Admin traversal, String file) {
        super(traversal);
        this.file = file;
    }

    public void setMode(ReadWriting.Mode mode) {
        this.mode = mode;
    }

    public ReadWriting.Mode getMode() {
        return this.mode;
    }

    public String getFile() {
        return this.file;
    }

    public void configure(Object ... keyValues) {
        this.parameters.set(null, keyValues);
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public String toString() {
        return StringFactory.stepString((Step)this, (Object[])new Object[]{new GraphFilter(this.computer)});
    }

    public CloneVertexProgram generateProgram(Graph graph, Memory memory) {
        if (this.mode == ReadWriting.Mode.UNSET) {
            throw new IllegalStateException("IO mode was not set to read() or write()");
        }
        if (this.mode == ReadWriting.Mode.READING) {
            this.configureForRead(graph);
        } else if (this.mode == ReadWriting.Mode.WRITING) {
            this.configureForWrite(graph);
        } else {
            throw new IllegalStateException("Invalid ReadWriting.Mode configured in IoStep: " + this.mode.name());
        }
        return CloneVertexProgram.build().create(graph);
    }

    public HadoopIoStep clone() {
        return (HadoopIoStep)super.clone();
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void configureForRead(Graph graph) {
        String inputFormatClassName;
        String inputFormatClassNameOrKeyword = (String)this.parameters.get((Object)IO.reader, this::detectReader).get(0);
        if (inputFormatClassNameOrKeyword.equals("graphson")) {
            inputFormatClassName = GraphSONInputFormat.class.getName();
        } else if (inputFormatClassNameOrKeyword.equals("gryo")) {
            inputFormatClassName = GryoInputFormat.class.getName();
        } else {
            if (inputFormatClassNameOrKeyword.equals("graphml")) {
                throw new IllegalStateException("GraphML is not a supported file format for OLAP");
            }
            inputFormatClassName = inputFormatClassNameOrKeyword;
        }
        graph.configuration().setProperty("gremlin.hadoop.graphReader", (Object)inputFormatClassName);
        graph.configuration().setProperty("gremlin.hadoop.inputLocation", (Object)this.file);
        this.addParametersToConfiguration(graph);
    }

    private void configureForWrite(Graph graph) {
        String outputFormatClassName;
        String outputFormatClassNameOrKeyword = (String)this.parameters.get((Object)IO.writer, this::detectWriter).get(0);
        if (outputFormatClassNameOrKeyword.equals("graphson")) {
            outputFormatClassName = GraphSONOutputFormat.class.getName();
        } else if (outputFormatClassNameOrKeyword.equals("gryo")) {
            outputFormatClassName = GryoOutputFormat.class.getName();
        } else {
            if (outputFormatClassNameOrKeyword.equals("graphml")) {
                throw new IllegalStateException("GraphML is not a supported file format for OLAP");
            }
            outputFormatClassName = outputFormatClassNameOrKeyword;
        }
        graph.configuration().setProperty("gremlin.hadoop.graphWriter", (Object)outputFormatClassName);
        graph.configuration().setProperty("gremlin.hadoop.outputLocation", (Object)this.file);
        this.addParametersToConfiguration(graph);
    }

    private void addParametersToConfiguration(Graph graph) {
        this.parameters.getRaw(new Object[]{IO.writer, IO.writer, IO.registry}).entrySet().forEach(kv -> {
            if (((List)kv.getValue()).size() == 1) {
                graph.configuration().setProperty(kv.getKey().toString(), ((List)kv.getValue()).get(0));
            } else {
                for (int ix = 0; ix < ((List)kv.getValue()).size(); ++ix) {
                    if (ix == 0) {
                        graph.configuration().setProperty(kv.getKey().toString(), ((List)kv.getValue()).get(ix));
                        continue;
                    }
                    graph.configuration().addProperty(kv.getKey().toString(), ((List)kv.getValue()).get(ix));
                }
            }
        });
    }

    private String detectReader() {
        if (this.file.endsWith(".kryo")) {
            return GryoInputFormat.class.getName();
        }
        if (this.file.endsWith(".json")) {
            return GraphSONInputFormat.class.getName();
        }
        if (this.file.endsWith(".xml")) {
            throw new IllegalStateException("GraphML is not a supported file format for OLAP");
        }
        throw new IllegalStateException("Could not detect the file format - specify the reader explicitly or rename file with a standard extension");
    }

    private String detectWriter() {
        if (this.file.endsWith(".kryo")) {
            return GryoOutputFormat.class.getName();
        }
        if (this.file.endsWith(".json")) {
            return GraphSONOutputFormat.class.getName();
        }
        if (this.file.endsWith(".xml")) {
            throw new IllegalStateException("GraphML is not a supported file format for OLAP");
        }
        throw new IllegalStateException("Could not detect the file format - specify the reader explicitly or rename file with a standard extension");
    }
}

