/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.util.Collections;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoPool;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.gremlin.util.SystemUtil;

public final class HadoopPools {
    private static GryoPool GRYO_POOL = null;
    private static boolean INITIALIZED = false;

    private HadoopPools() {
    }

    public static synchronized void initialize(Configuration configuration) {
        if (!INITIALIZED) {
            INITIALIZED = true;
            GRYO_POOL = GryoPool.build().poolSize(configuration.getInt("gremlin.io.gryo.poolSize", 256)).version(GryoVersion.valueOf((String)configuration.getString("gremlin.io.gryo.version", GryoPool.CONFIG_IO_GRYO_POOL_VERSION_DEFAULT.name()))).ioRegistries(configuration.getList("gremlin.io.registry", Collections.emptyList())).initializeMapper(m -> m.registrationRequired(false)).create();
        }
    }

    public static synchronized void initialize(org.apache.hadoop.conf.Configuration configuration) {
        HadoopPools.initialize(ConfUtil.makeApacheConfiguration(configuration));
    }

    public static synchronized void initialize(GryoPool gryoPool) {
        GRYO_POOL = gryoPool;
        INITIALIZED = true;
    }

    public static GryoPool getGryoPool() {
        if (!INITIALIZED) {
            Configuration configuration = SystemUtil.getSystemPropertiesConfiguration((String)"tinkerpop", (boolean)true);
            HadoopGraph.LOGGER.warn("The " + HadoopPools.class.getSimpleName() + " has not been initialized, using system properties configuration: " + ConfigurationUtils.toString((Configuration)configuration));
            HadoopPools.initialize(configuration);
        }
        return GRYO_POOL;
    }

    public static void close() {
        INITIALIZED = false;
        GRYO_POOL = null;
    }
}

