/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HadoopPools;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimServiceLoader;

public final class GryoRecordWriter
extends RecordWriter<NullWritable, VertexWritable> {
    private final DataOutputStream outputStream;
    private final boolean hasEdges;
    private GryoWriter gryoWriter;

    public GryoRecordWriter(DataOutputStream outputStream, org.apache.hadoop.conf.Configuration configuration) {
        this.outputStream = outputStream;
        this.hasEdges = configuration.getBoolean("gremlin.hadoop.graphWriter.hasEdges", true);
        KryoShimServiceLoader.applyConfiguration((Configuration)ConfUtil.makeApacheConfiguration(configuration));
        this.gryoWriter = HadoopPools.getGryoPool().takeWriter();
    }

    public void write(NullWritable key, VertexWritable vertex) throws IOException {
        if (null != vertex) {
            if (this.hasEdges) {
                this.gryoWriter.writeVertex((OutputStream)this.outputStream, (Vertex)vertex.get(), Direction.BOTH);
            } else {
                this.gryoWriter.writeVertex((OutputStream)this.outputStream, (Vertex)vertex.get());
            }
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.outputStream.close();
        if (null != this.gryoWriter) {
            HadoopPools.getGryoPool().offerWriter(this.gryoWriter);
            this.gryoWriter = null;
        }
    }
}

