/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopElement;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopProperty;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedEdge;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class HadoopEdge
extends HadoopElement
implements Edge,
WrappedEdge<Edge> {
    protected HadoopEdge() {
    }

    public HadoopEdge(Edge edge, HadoopGraph graph) {
        super((Element)edge, graph);
    }

    public Edge getBaseEdge() {
        return (Edge)this.baseElement;
    }

    public Iterator<Vertex> vertices(Direction direction) {
        switch (direction) {
            case OUT: {
                return (Iterator)IteratorUtils.of(this.graph.vertices(((Vertex)this.getBaseEdge().vertices(Direction.OUT).next()).id())).next();
            }
            case IN: {
                return (Iterator)IteratorUtils.of(this.graph.vertices(((Vertex)this.getBaseEdge().vertices(Direction.IN).next()).id())).next();
            }
        }
        Iterator iterator = this.getBaseEdge().vertices(Direction.BOTH);
        return IteratorUtils.of((Object)this.graph.vertices(((Vertex)iterator.next()).id()).next(), (Object)this.graph.vertices(((Vertex)iterator.next()).id()).next());
    }

    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        return IteratorUtils.map((Iterator)this.getBaseEdge().properties(propertyKeys), property -> new HadoopProperty(property, this));
    }
}

