/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.process.computer;

import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimServiceLoader;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HadoopReduce
extends Reducer<ObjectWritable, ObjectWritable, ObjectWritable, ObjectWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopReduce.class);
    private MapReduce mapReduce;
    private final HadoopReduceEmitter<ObjectWritable, ObjectWritable> reduceEmitter = new HadoopReduceEmitter();

    private HadoopReduce() {
    }

    public void setup(Reducer.Context context) {
        Configuration apacheConfiguration = ConfUtil.makeApacheConfiguration(context.getConfiguration());
        KryoShimServiceLoader.applyConfiguration((Configuration)apacheConfiguration);
        this.mapReduce = MapReduce.createMapReduce((Graph)HadoopGraph.open(apacheConfiguration), (Configuration)apacheConfiguration);
        this.mapReduce.workerStart(MapReduce.Stage.REDUCE);
    }

    public void reduce(ObjectWritable key, Iterable<ObjectWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        this.reduceEmitter.setContext(context);
        this.mapReduce.reduce(key.get(), IteratorUtils.map(values.iterator(), ObjectWritable::get), this.reduceEmitter);
    }

    public void cleanup(Reducer.Context context) {
        this.mapReduce.workerEnd(MapReduce.Stage.REDUCE);
    }

    public class HadoopReduceEmitter<OK, OV>
    implements MapReduce.ReduceEmitter<OK, OV> {
        private Reducer.Context context;
        private final ObjectWritable<OK> keyWritable = new ObjectWritable();
        private final ObjectWritable<OV> valueWritable = new ObjectWritable();

        public void setContext(Reducer.Context context) {
            this.context = context;
        }

        public void emit(OK key, OV value) {
            this.keyWritable.set(key);
            this.valueWritable.set(value);
            try {
                this.context.write(this.keyWritable, this.valueWritable);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }
}

