/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.groovy.plugin;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.tinkerpop.gremlin.groovy.loaders.SugarLoader;
import org.apache.tinkerpop.gremlin.groovy.plugin.RemoteAcceptor;
import org.apache.tinkerpop.gremlin.groovy.plugin.RemoteException;
import org.apache.tinkerpop.gremlin.hadoop.groovy.plugin.HadoopGremlinPlugin;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ComputerResultStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.codehaus.groovy.tools.shell.Groovysh;

@Deprecated
public final class HadoopRemoteAcceptor
implements RemoteAcceptor {
    private static final String USE_SUGAR = "useSugar";
    private static final String USE_TRAVERSAL_SOURCE = "useTraversalSource";
    private static final String SPACE = " ";
    private HadoopGraph hadoopGraph;
    private Groovysh shell;
    private boolean useSugar = false;
    private TraversalSource traversalSource;

    public HadoopRemoteAcceptor(Groovysh shell) {
        this.shell = shell;
    }

    public Object connect(List<String> args) throws RemoteException {
        if (args.size() != 1 && args.size() != 2) {
            throw new IllegalArgumentException("Usage: :remote connect " + HadoopGremlinPlugin.NAME + " <variable name of graph> <optional variable name of traversal source>");
        }
        this.hadoopGraph = (HadoopGraph)this.shell.getInterp().getContext().getVariable(args.get(0));
        this.traversalSource = args.size() == 2 ? (TraversalSource)this.shell.getInterp().getContext().getVariable(args.get(1)) : this.hadoopGraph.traversal();
        HashMap<String, Boolean> configuration = new HashMap<String, Boolean>();
        configuration.put(USE_SUGAR, this.useSugar);
        configuration.put(USE_TRAVERSAL_SOURCE, (Boolean)this.traversalSource);
        return Collections.unmodifiableMap(configuration);
    }

    public Object configure(List<String> args) throws RemoteException {
        for (int i = 0; i < args.size(); i += 2) {
            if (args.get(i).equals(USE_SUGAR)) {
                this.useSugar = Boolean.valueOf(args.get(i + 1));
                continue;
            }
            if (args.get(i).equals(USE_TRAVERSAL_SOURCE)) {
                this.traversalSource = (TraversalSource)this.shell.getInterp().getContext().getVariable(args.get(i + 1));
                continue;
            }
            throw new IllegalArgumentException("The provided configuration is unknown: " + args.get(i) + ":" + args.get(i + 1));
        }
        HashMap<String, Boolean> configuration = new HashMap<String, Boolean>();
        configuration.put(USE_SUGAR, this.useSugar);
        configuration.put(USE_TRAVERSAL_SOURCE, (Boolean)this.traversalSource);
        return Collections.unmodifiableMap(configuration);
    }

    public Object submit(List<String> args) throws RemoteException {
        try {
            String script = RemoteAcceptor.getScript((String)String.join((CharSequence)SPACE, args), (Groovysh)this.shell);
            if (this.useSugar) {
                script = SugarLoader.class.getCanonicalName() + ".load()\n" + script;
            }
            TraversalVertexProgram program = (TraversalVertexProgram)TraversalVertexProgram.build().traversal(this.traversalSource, "gremlin-groovy", script, new Object[0]).create((Graph)this.hadoopGraph);
            ComputerResult computerResult = (ComputerResult)((Computer)VertexProgramStrategy.getComputer((TraversalStrategies)this.traversalSource.getStrategies()).get()).apply((Graph)this.hadoopGraph).program((VertexProgram)program).submit().get();
            this.shell.getInterp().getContext().setVariable("result", (Object)computerResult);
            DefaultTraversal traversal = new DefaultTraversal(computerResult.graph());
            traversal.addStep((Step)new ComputerResultStep((Traversal.Admin)traversal));
            traversal.addStart(traversal.getTraverserGenerator().generate((Object)computerResult, (Step)EmptyStep.instance(), 1L));
            return traversal;
        }
        catch (Exception e) {
            throw new RemoteException((Throwable)e);
        }
    }

    public boolean allowRemoteConsole() {
        return true;
    }

    public void close() throws IOException {
        this.hadoopGraph.close();
    }
}

