/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.message;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.util.message.ResponseResult;
import org.apache.tinkerpop.gremlin.util.message.ResponseStatus;

public final class ResponseMessage {
    private final ResponseStatus responseStatus;
    private final ResponseResult responseResult;

    private ResponseMessage(ResponseStatus responseStatus, ResponseResult responseResult) {
        this.responseResult = responseResult;
        this.responseStatus = responseStatus;
    }

    public ResponseStatus getStatus() {
        return this.responseStatus;
    }

    public ResponseResult getResult() {
        return this.responseResult;
    }

    public String toString() {
        return "ResponseMessage{, status=" + this.responseStatus + ", result=" + this.responseResult + '}';
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private HttpResponseStatus code = null;
        private List<Object> result = Collections.emptyList();
        private boolean bulked = false;
        private String statusMessage = null;
        private String exception = null;

        private Builder() {
        }

        public Builder code(HttpResponseStatus code) {
            this.code = code;
            return this;
        }

        public Builder statusMessage(String message) {
            this.statusMessage = message;
            return this;
        }

        public Builder exception(String exception) {
            this.exception = exception;
            return this;
        }

        public Builder result(List<Object> result) {
            this.result = result;
            return this;
        }

        public Builder bulked(boolean bulked) {
            this.bulked = bulked;
            return this;
        }

        public ResponseMessage create() {
            ResponseResult responseResult = new ResponseResult(this.result, this.bulked);
            if (this.code == null && this.statusMessage == null) {
                return new ResponseMessage(null, responseResult);
            }
            ResponseStatus responseStatus = new ResponseStatus(this.code, this.statusMessage, this.exception);
            return new ResponseMessage(responseStatus, responseResult);
        }
    }

    public static class ResponseMessageFooter {
        private final ResponseMessage responseMessage;
        private final boolean typed;

        public ResponseMessageFooter(ResponseMessage responseMessage, boolean typed) {
            this.responseMessage = responseMessage;
            this.typed = typed;
        }

        public ResponseMessage getResponseMessage() {
            return this.responseMessage;
        }

        public boolean getTyped() {
            return this.typed;
        }
    }

    public static class ResponseMessageHeader {
        private final ResponseMessage responseMessage;
        private final boolean typed;

        public ResponseMessageHeader(ResponseMessage responseMessage, boolean typed) {
            this.responseMessage = responseMessage;
            this.typed = typed;
        }

        public ResponseMessage getResponseMessage() {
            return this.responseMessage;
        }

        public boolean getTyped() {
            return this.typed;
        }
    }
}

