/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.List;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class MapTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, String> get_g_VX1X_mapXnameX(Object var1);

    public abstract Traversal<Vertex, Integer> get_g_VX1X_outE_label_mapXlengthX(Object var1);

    public abstract Traversal<Vertex, Integer> get_g_VX1X_out_mapXnameX_mapXlengthX(Object var1);

    public abstract Traversal<Vertex, String> get_g_withPath_V_asXaX_out_mapXa_nameX();

    public abstract Traversal<Vertex, String> get_g_withPath_V_asXaX_out_out_mapXa_name_it_nameX();

    public abstract Traversal<Vertex, Vertex> get_g_V_mapXselectXaXX();

    public abstract Traversal<Vertex, Vertex> get_g_V_mapXconstantXnullXX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_mapXnameX() {
        Traversal<Vertex, String> traversal = this.get_g_VX1X_mapXnameX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)traversal.next(), (Object)"marko");
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outE_label_mapXlengthX() {
        Traversal<Vertex, Integer> traversal = this.get_g_VX1X_outE_label_mapXlengthX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        List lengths = traversal.toList();
        Assert.assertTrue((boolean)lengths.contains("created".length()));
        Assert.assertTrue((boolean)lengths.contains("knows".length()));
        Assert.assertEquals((long)lengths.size(), (long)3L);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_mapXnameX_mapXlengthX() {
        Traversal<Vertex, Integer> traversal = this.get_g_VX1X_out_mapXnameX_mapXlengthX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        List lengths = traversal.toList();
        Assert.assertTrue((boolean)lengths.contains("josh".length()));
        Assert.assertTrue((boolean)lengths.contains("vadas".length()));
        Assert.assertTrue((boolean)lengths.contains("lop".length()));
        Assert.assertEquals((long)lengths.size(), (long)3L);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_withPath_V_asXaX_out_mapXa_nameX() {
        int marko = 0;
        int peter = 0;
        int josh = 0;
        int other = 0;
        Traversal<Vertex, String> traversal = this.get_g_withPath_V_asXaX_out_mapXa_nameX();
        this.printTraversalForm(traversal);
        while (traversal.hasNext()) {
            String name = (String)traversal.next();
            if (name.equals("marko")) {
                ++marko;
                continue;
            }
            if (name.equals("peter")) {
                ++peter;
                continue;
            }
            if (name.equals("josh")) {
                ++josh;
                continue;
            }
            ++other;
        }
        Assert.assertEquals((long)marko, (long)3L);
        Assert.assertEquals((long)josh, (long)2L);
        Assert.assertEquals((long)peter, (long)1L);
        Assert.assertEquals((long)other, (long)0L);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_withPath_V_asXaX_out_out_mapXa_name_it_nameX() {
        Traversal<Vertex, String> traversal = this.get_g_withPath_V_asXaX_out_out_mapXa_name_it_nameX();
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            String doubleName = (String)traversal.next();
            Assert.assertTrue(("markoripple".equals(doubleName) || "markolop".equals(doubleName) ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)counter);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_mapXselectXaXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_mapXselectXaXX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            traversal.next();
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_mapXconstantXnullXX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_mapXconstantXnullXX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertNull((Object)traversal.next());
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    public static class Traversals
    extends MapTest {
        @Override
        public Traversal<Vertex, String> get_g_VX1X_mapXnameX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).map(v -> (String)((Vertex)v.get()).value("name"));
        }

        @Override
        public Traversal<Vertex, Integer> get_g_VX1X_outE_label_mapXlengthX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE().label().map(l -> ((String)l.get()).length());
        }

        @Override
        public Traversal<Vertex, Integer> get_g_VX1X_out_mapXnameX_mapXlengthX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out().map(v -> ((Vertex)v.get()).value("name")).map(n -> n.get().toString().length());
        }

        @Override
        public Traversal<Vertex, String> get_g_withPath_V_asXaX_out_mapXa_nameX() {
            return this.g.withPath().V(new Object[0]).as("a", new String[0]).out().map(v -> (String)((Vertex)v.path("a")).value("name"));
        }

        @Override
        public Traversal<Vertex, String> get_g_withPath_V_asXaX_out_out_mapXa_name_it_nameX() {
            return this.g.withPath().V(new Object[0]).as("a", new String[0]).out().out().map(v -> (String)((Vertex)v.path("a")).value("name") + (String)((Vertex)v.get()).value("name"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_mapXselectXaXX() {
            return this.g.V(new Object[0]).as("a", new String[0]).map((Traversal)__.select((String)"a"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_mapXconstantXnullXX() {
            return this.g.V(new Object[0]).map((Traversal)__.constant(null));
        }
    }
}

