/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.features;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.structure.io.Storage;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONResourceAccess;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoResourceAccess;
import org.apache.tinkerpop.gremlin.structure.io.script.ScriptResourceAccess;

public class TestFiles {
    protected static final Random RANDOM = TestHelper.RANDOM;
    public static final Map<String, String> PATHS = new HashMap<String, String>();

    public static String getInputLocation(LoadGraphWith.GraphData graphData, boolean useGraphSON) {
        String type;
        String string = type = useGraphSON ? "-v3.json" : "-v3.kryo";
        if (graphData.equals((Object)LoadGraphWith.GraphData.GRATEFUL)) {
            return PATHS.get("grateful-dead" + type);
        }
        if (graphData.equals((Object)LoadGraphWith.GraphData.MODERN)) {
            return PATHS.get("tinkerpop-modern" + type);
        }
        if (graphData.equals((Object)LoadGraphWith.GraphData.CLASSIC)) {
            return PATHS.get("tinkerpop-classic" + type);
        }
        if (graphData.equals((Object)LoadGraphWith.GraphData.CREW)) {
            return PATHS.get("tinkerpop-crew" + type);
        }
        if (graphData.equals((Object)LoadGraphWith.GraphData.SINK)) {
            return PATHS.get("tinkerpop-sink" + type);
        }
        throw new RuntimeException("Could not load graph with " + (Object)((Object)graphData));
    }

    static {
        try {
            List<String> kryoResources = Arrays.asList("tinkerpop-modern-v3.kryo", "grateful-dead-v3.kryo", "tinkerpop-classic-v3.kryo", "tinkerpop-crew-v3.kryo", "tinkerpop-sink-v3.kryo");
            for (String string : kryoResources) {
                PATHS.put(string, Storage.toPath((File)TestHelper.generateTempFileFromResource(GryoResourceAccess.class, (String)string, (String)"")));
            }
            List<String> graphsonResources = Arrays.asList("tinkerpop-modern-typed-v2.json", "tinkerpop-modern-v3.json", "grateful-dead-typed-v2.json", "grateful-dead-v3.json", "tinkerpop-classic-typed-v2.json", "tinkerpop-classic-v3.json", "tinkerpop-classic-byteid-v3.json", "tinkerpop-classic-byteid-typed-v2.json", "tinkerpop-crew-typed-v2.json", "tinkerpop-crew-v3.json", "tinkerpop-sink-v3.json");
            for (String fileName : graphsonResources) {
                PATHS.put(fileName, Storage.toPath((File)TestHelper.generateTempFileFromResource(GraphSONResourceAccess.class, (String)fileName, (String)"")));
            }
            List<String> list = Arrays.asList("tinkerpop-classic.txt", "script-output.groovy", "grateful-dead.txt", "script-input-grateful-dead.groovy", "script-output-grateful-dead.groovy");
            for (String fileName : list) {
                PATHS.put(fileName, Storage.toPath((File)TestHelper.generateTempFileFromResource(ScriptResourceAccess.class, (String)fileName, (String)"")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

