/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;

public class TransactionMultiThreadedTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldCommit() throws InterruptedException {
        GraphTraversalSource gtx = (GraphTraversalSource)this.g.tx().begin();
        gtx.addV().next();
        gtx.addV().next();
        Assert.assertEquals((long)2L, (long)((Long)gtx.V(new Object[0]).count().next()));
        this.countElementsInNewThreadTx(this.g, 0L, 0L);
        gtx.tx().commit();
        GraphTraversalSource gtx3 = (GraphTraversalSource)this.g.tx().begin();
        Assert.assertEquals((long)2L, (long)((Long)gtx3.V(new Object[0]).count().next()));
        this.countElementsInNewThreadTx(this.g, 2L, 0L);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
    public void shouldDeleteVertexOnCommit() throws InterruptedException {
        GraphTraversalSource gtx = (GraphTraversalSource)this.g.tx().begin();
        Vertex v1 = (Vertex)gtx.addV().next();
        gtx.tx().commit();
        Assert.assertEquals((long)1L, (long)((Long)gtx.V(new Object[0]).count().next()));
        gtx.V(new Object[]{v1.id()}).drop().iterate();
        Assert.assertEquals((long)0L, (long)((Long)gtx.V(new Object[0]).count().next()));
        this.countElementsInNewThreadTx(this.g, 1L, 0L);
        gtx.tx().commit();
        Assert.assertEquals((long)0L, (long)((Long)gtx.V(new Object[0]).count().next()));
        GraphTraversalSource gtx3 = (GraphTraversalSource)this.g.tx().begin();
        Assert.assertEquals((long)0L, (long)((Long)gtx3.V(new Object[0]).count().next()));
        this.countElementsInNewThreadTx(this.g, 0L, 0L);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")})
    public void shouldDeleteRelatedEdgesOnVertexDelete() throws InterruptedException {
        GraphTraversalSource gtx = (GraphTraversalSource)this.g.tx().begin();
        Vertex v1 = (Vertex)gtx.addV().next();
        Vertex v2 = (Vertex)gtx.addV().next();
        gtx.addE("tests").from(v1).to(v2).next();
        gtx.tx().commit();
        Assert.assertEquals((long)2L, (long)((Long)gtx.V(new Object[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)gtx.E(new Object[0]).count().next()));
        gtx.V(new Object[]{v1.id()}).drop().iterate();
        gtx.tx().commit();
        GraphTraversalSource gtx3 = (GraphTraversalSource)this.g.tx().begin();
        Assert.assertEquals((long)1L, (long)((Long)gtx3.V(new Object[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)gtx3.E(new Object[0]).count().next()));
        this.countElementsInNewThreadTx(this.g, 1L, 0L);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty")})
    public void shouldChangeVertexProperty() {
        GraphTraversalSource gtx = (GraphTraversalSource)this.g.tx().begin();
        Vertex v1 = (Vertex)gtx.addV().property((Object)"test", (Object)1, new Object[0]).next();
        gtx.tx().commit();
        Assert.assertEquals((Object)1, (Object)gtx.V(new Object[]{v1.id()}).values(new String[]{"test"}).next());
        gtx.V(new Object[]{v1.id()}).property((Object)"test", (Object)2, new Object[0]).iterate();
        gtx.tx().commit();
        Assert.assertEquals((long)1L, (long)((Long)gtx.V(new Object[0]).count().next()));
        Assert.assertEquals((Object)2, (Object)gtx.V(new Object[]{v1.id()}).values(new String[]{"test"}).next());
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldRollbackAddedVertex() throws InterruptedException {
        GraphTraversalSource gtx = (GraphTraversalSource)this.g.tx().begin();
        gtx.addV().next();
        gtx.addV().next();
        Assert.assertEquals((long)2L, (long)((Long)gtx.V(new Object[0]).count().next()));
        this.countElementsInNewThreadTx(this.g, 0L, 0L);
        gtx.tx().rollback();
        GraphTraversalSource gtx3 = (GraphTraversalSource)this.g.tx().begin();
        Assert.assertEquals((long)0L, (long)((Long)gtx3.V(new Object[0]).count().next()));
        this.countElementsInNewThreadTx(this.g, 0L, 0L);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")})
    public void shouldCommitEdge() throws InterruptedException {
        GraphTraversalSource gtx = (GraphTraversalSource)this.g.tx().begin();
        Vertex v1 = (Vertex)gtx.addV().next();
        Vertex v2 = (Vertex)gtx.addV().next();
        gtx.addE("tests").from(v1).to(v2).next();
        Assert.assertEquals((long)2L, (long)((Long)gtx.V(new Object[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)gtx.E(new Object[0]).count().next()));
        this.countElementsInNewThreadTx(this.g, 0L, 0L);
        gtx.tx().commit();
        GraphTraversalSource gtx3 = (GraphTraversalSource)this.g.tx().begin();
        Assert.assertEquals((long)2L, (long)((Long)gtx3.V(new Object[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)gtx3.E(new Object[0]).count().next()));
        this.countElementsInNewThreadTx(this.g, 2L, 1L);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")})
    public void shouldRollbackAddedEdge() throws InterruptedException {
        GraphTraversalSource gtx = (GraphTraversalSource)this.g.tx().begin();
        Vertex v1 = (Vertex)gtx.addV().next();
        Vertex v2 = (Vertex)gtx.addV().next();
        gtx.addE("tests").from(v1).to(v2).next();
        Assert.assertEquals((long)2L, (long)((Long)gtx.V(new Object[0]).count().next()));
        Assert.assertEquals((long)1L, (long)((Long)gtx.E(new Object[0]).count().next()));
        Thread thread = new Thread(() -> {
            GraphTraversalSource gtx2 = (GraphTraversalSource)this.g.tx().begin();
            Assert.assertEquals((long)0L, (long)((Long)gtx2.V(new Object[0]).count().next()));
            Assert.assertEquals((long)0L, (long)((Long)gtx2.E(new Object[0]).count().next()));
        });
        thread.start();
        thread.join();
        gtx.tx().rollback();
        GraphTraversalSource gtx3 = (GraphTraversalSource)this.g.tx().begin();
        Assert.assertEquals((long)0L, (long)((Long)gtx3.V(new Object[0]).count().next()));
        Assert.assertEquals((long)0L, (long)((Long)gtx3.E(new Object[0]).count().next()));
        this.countElementsInNewThreadTx(this.g, 0L, 0L);
    }

    private void countElementsInNewThreadTx(GraphTraversalSource g, long verticesCount, long edgesCount) throws InterruptedException {
        AtomicLong vCount = new AtomicLong(-1L);
        AtomicLong eCount = new AtomicLong(-1L);
        Thread thread = new Thread(() -> {
            GraphTraversalSource gtx = (GraphTraversalSource)g.tx().begin();
            vCount.set((Long)gtx.V(new Object[0]).count().next());
            eCount.set((Long)gtx.E(new Object[0]).count().next());
        });
        thread.start();
        thread.join();
        Assert.assertEquals((long)verticesCount, (long)vCount.get());
        Assert.assertEquals((long)edgesCount, (long)eCount.get());
    }
}

