/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class PathTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Path> get_g_VX1X_name_path(Object var1);

    public abstract Traversal<Vertex, Path> get_g_VX1X_out_path_byXageX(Object var1);

    public abstract Traversal<Vertex, Path> get_g_VX1X_out_path_byXageX_byXnameX(Object var1);

    public abstract Traversal<Vertex, Path> get_g_V_repeatXoutX_timesX2X_path_by_byXnameX_byXlangX();

    public abstract Traversal<Vertex, Path> get_g_V_out_out_path_byXnameX_byXageX();

    public abstract Traversal<Vertex, Path> get_g_V_asXaX_hasXname_markoX_asXbX_hasXage_29X_asXcX_path();

    public abstract Traversal<Vertex, Path> get_g_VX1X_outEXcreatedX_inV_inE_outV_path(Object var1);

    public abstract Traversal<Vertex, Path> get_g_V_asXaX_out_asXbX_out_asXcX_path_fromXbX_toXcX_byXnameX();

    public abstract Traversal<Integer, Path> get_g_injectX1_null_nullX_path();

    public abstract Traversal<Integer, Path> get_g_injectX1_null_nullX_path_dedup();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_name_path() {
        Traversal<Vertex, Path> traversal = this.get_g_VX1X_name_path(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Path path = (Path)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)path.size());
        Assert.assertEquals((Object)this.convertToVertexId("marko"), (Object)((Vertex)path.get(0)).id());
        Assert.assertEquals((Object)"marko", (Object)path.get(1));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_path_byXageX() {
        Traversal<Vertex, Path> traversal = this.get_g_VX1X_out_path_byXageX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Object> ages = new HashSet<Object>();
        while (traversal.hasNext()) {
            ++counter;
            Path path = (Path)traversal.next();
            Assert.assertEquals((Object)29, (Object)path.get(0));
            Assert.assertTrue((path.get(1) == null || path.get(1).equals(27) || path.get(1).equals(32) ? 1 : 0) != 0);
            ages.add(path.get(1));
        }
        Assert.assertEquals((long)2L, (long)counter);
        Assert.assertEquals((long)2L, (long)ages.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_path_byXageX_byXnameX() {
        Traversal<Vertex, Path> traversal = this.get_g_VX1X_out_path_byXageX_byXnameX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<String> names = new HashSet<String>();
        while (traversal.hasNext()) {
            ++counter;
            Path path = (Path)traversal.next();
            Assert.assertEquals((Object)29, (Object)path.get(0));
            Assert.assertTrue((path.get(1).equals("josh") || path.get(1).equals("vadas") || path.get(1).equals("lop") ? 1 : 0) != 0);
            names.add((String)path.get(1));
        }
        Assert.assertEquals((long)3L, (long)counter);
        Assert.assertEquals((long)3L, (long)names.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_repeatXoutX_timesX2X_path_byXitX_byXnameX_byXlangX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_repeatXoutX_timesX2X_path_by_byXnameX_byXlangX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Path path = (Path)traversal.next();
            Assert.assertEquals((long)3L, (long)path.size());
            Assert.assertEquals((Object)this.convertToVertex("marko"), (Object)path.get(0));
            Assert.assertEquals((Object)"josh", (Object)path.get(1));
            Assert.assertEquals((Object)"java", (Object)path.get(2));
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_out_out_path_byXnameX_byXageX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_out_out_path_byXnameX_byXageX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Path path = (Path)traversal.next();
            Assert.assertEquals((long)3L, (long)path.size());
            Assert.assertEquals((Object)"marko", (Object)path.get(0));
            Assert.assertEquals((Object)32, (Object)path.get(1));
            Assert.assertTrue((path.get(2).equals("lop") || path.get(2).equals("ripple") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_asXaX_hasXname_markoX_asXbX_hasXage_29X_asXcX_path() {
        Traversal<Vertex, Path> traversal = this.get_g_V_asXaX_hasXname_markoX_asXbX_hasXage_29X_asXcX_path();
        this.printTraversalForm(traversal);
        Path path = (Path)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)1L, (long)path.size());
        Assert.assertTrue((boolean)path.hasLabel("a"));
        Assert.assertTrue((boolean)path.hasLabel("b"));
        Assert.assertTrue((boolean)path.hasLabel("c"));
        Assert.assertEquals((long)1L, (long)path.labels().size());
        Assert.assertEquals((long)3L, (long)((Set)path.labels().get(0)).size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_outEXcreatedX_inV_inE_outV_path() {
        Traversal<Vertex, Path> traversal = this.get_g_VX1X_outEXcreatedX_inV_inE_outV_path(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        List paths = traversal.toList();
        Assert.assertEquals((long)3L, (long)paths.size());
        for (Path path : paths) {
            Assert.assertEquals((long)5L, (long)path.size());
            Assert.assertEquals((Object)this.convertToVertexId("marko"), (Object)((Vertex)path.get(0)).id());
            Assert.assertEquals((Object)this.convertToEdgeId("marko", "created", "lop"), (Object)((Edge)path.get(1)).id());
            Assert.assertEquals((Object)this.convertToVertexId("lop"), (Object)((Vertex)path.get(2)).id());
            Assert.assertEquals((Object)"created", (Object)((Edge)path.get(3)).label());
            Assert.assertTrue((this.convertToVertexId("josh").equals(((Vertex)path.get(4)).id()) || this.convertToVertexId("peter").equals(((Vertex)path.get(4)).id()) || this.convertToVertexId("marko").equals(((Vertex)path.get(4)).id()) ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_asXaX_out_asXbX_out_asXcX_path_fromXbX_toXcX_byXnameX() {
        Traversal<Vertex, Path> traversal = this.get_g_V_asXaX_out_asXbX_out_asXcX_path_fromXbX_toXcX_byXnameX();
        this.printTraversalForm(traversal);
        PathTest.checkResults(Arrays.asList(MutablePath.make().extend((Object)"josh", Collections.singleton("b")).extend((Object)"lop", Collections.singleton("c")), MutablePath.make().extend((Object)"josh", Collections.singleton("b")).extend((Object)"ripple", Collections.singleton("c"))), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_injectX1_null_nullX_path() {
        Traversal<Integer, Path> traversal = this.get_g_injectX1_null_nullX_path();
        this.printTraversalForm(traversal);
        PathTest.checkResults(Arrays.asList(MutablePath.make().extend((Object)1, Collections.emptySet()), MutablePath.make().extend(null, Collections.emptySet()), MutablePath.make().extend(null, Collections.emptySet())), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_injectX1_null_nullX_path_dedup() {
        Traversal<Integer, Path> traversal = this.get_g_injectX1_null_nullX_path_dedup();
        this.printTraversalForm(traversal);
        PathTest.checkResults(Arrays.asList(MutablePath.make().extend((Object)1, Collections.emptySet()), MutablePath.make().extend(null, Collections.emptySet())), traversal);
    }

    public static class Traversals
    extends PathTest {
        @Override
        public Traversal<Vertex, Path> get_g_VX1X_name_path(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).values(new String[]{"name"}).path();
        }

        @Override
        public Traversal<Vertex, Path> get_g_VX1X_out_path_byXageX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]).path().by("age");
        }

        @Override
        public Traversal<Vertex, Path> get_g_VX1X_out_path_byXageX_byXnameX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]).path().by("age").by("name");
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_repeatXoutX_timesX2X_path_by_byXnameX_byXlangX() {
            return this.g.V(new Object[0]).repeat((Traversal)__.out((String[])new String[0])).times(2).path().by().by("name").by("lang");
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_out_out_path_byXnameX_byXageX() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).path().by("name").by("age");
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_asXaX_hasXname_markoX_asXbX_hasXage_29X_asXcX_path() {
            return this.g.V(new Object[0]).as("a", new String[0]).has("name", (Object)"marko").as("b", new String[0]).has("age", (Object)29).as("c", new String[0]).path();
        }

        @Override
        public Traversal<Vertex, Path> get_g_VX1X_outEXcreatedX_inV_inE_outV_path(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).outE(new String[]{"created"}).inV().inE(new String[0]).outV().path();
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_asXaX_out_asXbX_out_asXcX_path_fromXbX_toXcX_byXnameX() {
            return this.g.V(new Object[0]).as("a", new String[0]).out(new String[0]).as("b", new String[0]).out(new String[0]).as("c", new String[0]).path().from("b").to("c").by("name");
        }

        @Override
        public Traversal<Integer, Path> get_g_injectX1_null_nullX_path() {
            return this.g.inject((Object[])new Integer[]{1, null, null}).path();
        }

        @Override
        public Traversal<Integer, Path> get_g_injectX1_null_nullX_path_dedup() {
            return this.g.inject((Object[])new Integer[]{1, null, null}).path().dedup(new String[0]);
        }
    }
}

