/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Iterator;
import java.util.Map;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.tools.CollectionFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringEndsWith;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class MergeEdgeTest
extends AbstractGremlinTest {
    public abstract Traversal<Vertex, Edge> get_g_V_mergeEXlabel_self_weight_05X();

    public abstract Traversal<Edge, Edge> get_g_mergeEXlabel_knows_out_marko_in_vadasX();

    public abstract Traversal<Edge, Edge> get_g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X_exists();

    public abstract Traversal<Edge, Edge> get_g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX();

    public abstract Traversal<Edge, Edge> get_g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists();

    public abstract Traversal<Edge, Edge> get_g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated();

    public abstract Traversal<Vertex, Edge> get_g_V_hasXperson_name_marko_X_mergeEXlabel_knowsX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated();

    public abstract Traversal<Map<Object, Object>, Edge> get_g_injectXlabel_knows_out_marko_in_vadasX_mergeE();

    public abstract Traversal<Edge, Edge> get_g_mergeE_with_outV_inV_options();

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void g_V_mergeEXlabel_self_weight_05X() {
        this.g.addV("person").property((Object)"name", (Object)"stephen", new Object[0]).iterate();
        Traversal<Vertex, Edge> traversal = this.get_g_V_mergeEXlabel_self_weight_05X();
        this.printTraversalForm(traversal);
        Edge edge = (Edge)traversal.next();
        Assert.assertEquals((Object)"self", (Object)edge.label());
        Assert.assertEquals((double)0.5, (double)((Double)edge.value("weight")), (double)1.0E-4);
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void g_mergeEXlabel_knows_out_marko_in_vadasX() {
        this.g.addV("person").property((Object)T.id, (Object)100, new Object[0]).property((Object)"name", (Object)"marko", new Object[0]).addV("person").property((Object)T.id, (Object)101, new Object[0]).property((Object)"name", (Object)"vadas", new Object[0]).iterate();
        Traversal<Edge, Edge> traversal = this.get_g_mergeEXlabel_knows_out_marko_in_vadasX();
        this.printTraversalForm(traversal);
        Edge edge = (Edge)traversal.next();
        Assert.assertEquals((Object)"knows", (Object)edge.label());
        Assert.assertEquals((Object)100, (Object)edge.outVertex().id());
        Assert.assertEquals((Object)101, (Object)edge.inVertex().id());
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X_exists() {
        this.g.addV("person").property((Object)T.id, (Object)100, new Object[0]).property((Object)"name", (Object)"marko", new Object[0]).as("a", new String[0]).addV("person").property((Object)T.id, (Object)101, new Object[0]).property((Object)"name", (Object)"vadas", new Object[0]).as("b", new String[0]).addE("knows").from("a").to("b").iterate();
        Traversal<Edge, Edge> traversal = this.get_g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X_exists();
        this.printTraversalForm(traversal);
        Edge edge = (Edge)traversal.next();
        Assert.assertEquals((Object)"knows", (Object)edge.label());
        Assert.assertEquals((Object)100, (Object)edge.outVertex().id());
        Assert.assertEquals((Object)101, (Object)edge.inVertex().id());
        Assert.assertEquals((double)0.5, (double)((Double)edge.value("weight")), (double)1.0E-4);
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX() {
        Traversal<Edge, Edge> traversal = this.get_g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX();
        this.printTraversalForm(traversal);
        try {
            traversal.next();
            Assert.fail((String)"Should have failed as vertices are not created");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)StringEndsWith.endsWith((String)"Vertex id could not be resolved from mergeE: 100"));
        }
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists() {
        this.g.addV("person").property((Object)T.id, (Object)100, new Object[0]).property((Object)"name", (Object)"marko", new Object[0]).as("a", new String[0]).addV("person").property((Object)T.id, (Object)101, new Object[0]).property((Object)"name", (Object)"vadas", new Object[0]).as("b", new String[0]).addE("knows").from("a").to("b").iterate();
        Traversal<Edge, Edge> traversal = this.get_g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists();
        this.printTraversalForm(traversal);
        Edge edge = (Edge)traversal.next();
        Assert.assertEquals((Object)"knows", (Object)edge.label());
        Assert.assertEquals((Object)100, (Object)edge.outVertex().id());
        Assert.assertEquals((Object)101, (Object)edge.inVertex().id());
        Assert.assertEquals((Object)"N", (Object)edge.value("created"));
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated() {
        this.g.addV("person").property((Object)T.id, (Object)100, new Object[0]).property((Object)"name", (Object)"marko", new Object[0]).as("a", new String[0]).addV("person").property((Object)T.id, (Object)101, new Object[0]).property((Object)"name", (Object)"vadas", new Object[0]).as("b", new String[0]).addE("knows").from("a").to("b").property((Object)"created", (Object)"Y", new Object[0]).iterate();
        Traversal<Edge, Edge> traversal = this.get_g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated();
        this.printTraversalForm(traversal);
        Edge edge = (Edge)traversal.next();
        Assert.assertEquals((Object)"knows", (Object)edge.label());
        Assert.assertEquals((Object)100, (Object)edge.outVertex().id());
        Assert.assertEquals((Object)101, (Object)edge.inVertex().id());
        Assert.assertEquals((Object)"N", (Object)edge.value("created"));
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void g_V_hasXperson_name_marko_X_mergeEXlabel_knowsX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated() {
        this.g.addV("person").property((Object)T.id, (Object)100, new Object[0]).property((Object)"name", (Object)"marko", new Object[0]).as("a", new String[0]).addV("person").property((Object)T.id, (Object)101, new Object[0]).property((Object)"name", (Object)"vadas", new Object[0]).as("b", new String[0]).addE("knows").from("a").to("b").property((Object)"created", (Object)"Y", new Object[0]).addE("knows").from("a").to("b").iterate();
        Traversal<Vertex, Edge> traversal = this.get_g_V_hasXperson_name_marko_X_mergeEXlabel_knowsX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)2L, (long)IteratorUtils.count(traversal));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[0])));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0]).hasLabel("knows", new String[0]).has("created", (Object)"N")));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void g_injectXlabel_knows_out_marko_in_vadasX_mergeE() {
        this.g.addV("person").property((Object)T.id, (Object)100, new Object[0]).property((Object)"name", (Object)"marko", new Object[0]).addV("person").property((Object)T.id, (Object)101, new Object[0]).property((Object)"name", (Object)"vadas", new Object[0]).iterate();
        Traversal<Map<Object, Object>, Edge> traversal = this.get_g_injectXlabel_knows_out_marko_in_vadasX_mergeE();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count(traversal));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{100}).out(new String[]{"knows"}).hasId((Object)101, new Object[0])));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void g_mergeE_with_outV_inV_options() {
        this.g.addV("person").property((Object)T.id, (Object)1, new Object[0]).addV("person").property((Object)T.id, (Object)2, new Object[0]).iterate();
        Traversal<Edge, Edge> traversal = this.get_g_mergeE_with_outV_inV_options();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count(traversal));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{1}).out(new String[]{"knows"}).hasId((Object)2, new Object[0])));
    }

    public static class Traversals
    extends MergeEdgeTest {
        @Override
        public Traversal<Vertex, Edge> get_g_V_mergeEXlabel_self_weight_05X() {
            return this.g.V(new Object[0]).as("v", new String[0]).mergeE((Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "self", "weight", 0.5, Direction.OUT, Merge.outV, Direction.IN, Merge.inV})).option((Object)Merge.outV, (Traversal)__.select((String)"v")).option((Object)Merge.inV, (Traversal)__.select((String)"v"));
        }

        @Override
        public Traversal<Edge, Edge> get_g_mergeEXlabel_knows_out_marko_in_vadasX() {
            return this.g.mergeE((Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.IN, new ReferenceVertex((Object)101), Direction.OUT, new ReferenceVertex((Object)100)}));
        }

        @Override
        public Traversal<Edge, Edge> get_g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X_exists() {
            return this.g.mergeE((Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.IN, new ReferenceVertex((Object)101), Direction.OUT, new ReferenceVertex((Object)100), "weight", 0.5}));
        }

        @Override
        public Traversal<Edge, Edge> get_g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX() {
            return this.g.mergeE((Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.IN, new ReferenceVertex((Object)101), Direction.OUT, new ReferenceVertex((Object)100)})).option((Object)Merge.onCreate, (Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.IN, new ReferenceVertex((Object)101), Direction.OUT, new ReferenceVertex((Object)100), "created", "Y"})).option((Object)Merge.onMatch, (Map)CollectionFactory.asMap((Object[])new Object[]{"created", "N"}));
        }

        @Override
        public Traversal<Edge, Edge> get_g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists() {
            return this.g.mergeE((Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.IN, new ReferenceVertex((Object)101), Direction.OUT, new ReferenceVertex((Object)100)})).option((Object)Merge.onCreate, (Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.IN, new ReferenceVertex((Object)101), Direction.OUT, new ReferenceVertex((Object)100), "created", "Y"})).option((Object)Merge.onMatch, (Map)CollectionFactory.asMap((Object[])new Object[]{"created", "N"}));
        }

        @Override
        public Traversal<Edge, Edge> get_g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated() {
            return this.g.mergeE((Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.IN, new ReferenceVertex((Object)101), Direction.OUT, new ReferenceVertex((Object)100)})).option((Object)Merge.onCreate, (Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.IN, new ReferenceVertex((Object)101), Direction.OUT, new ReferenceVertex((Object)100), "created", "Y"})).option((Object)Merge.onMatch, (Map)CollectionFactory.asMap((Object[])new Object[]{"created", "N"}));
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_hasXperson_name_marko_X_mergeEXlabel_knowsX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated() {
            return this.g.V(new Object[0]).has("person", "name", (Object)"marko").mergeE((Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows"})).option((Object)Merge.onCreate, (Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.IN, new ReferenceVertex((Object)101), Direction.OUT, new ReferenceVertex((Object)100), "created", "Y"})).option((Object)Merge.onMatch, (Map)CollectionFactory.asMap((Object[])new Object[]{"created", "N"}));
        }

        @Override
        public Traversal<Map<Object, Object>, Edge> get_g_injectXlabel_knows_out_marko_in_vadasX_mergeE() {
            return this.g.inject((Object[])new Map[]{CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.IN, new ReferenceVertex((Object)101), Direction.OUT, new ReferenceVertex((Object)100)})}).mergeE();
        }

        @Override
        public Traversal<Edge, Edge> get_g_mergeE_with_outV_inV_options() {
            return this.g.mergeE((Map)CollectionFactory.asMap((Object[])new Object[]{T.label, "knows", Direction.OUT, Merge.outV, Direction.IN, Merge.inV})).option((Object)Merge.outV, (Map)CollectionFactory.asMap((Object[])new Object[]{T.id, 1})).option((Object)Merge.inV, (Map)CollectionFactory.asMap((Object[])new Object[]{T.id, 2}));
        }
    }
}

